/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.util;

import rice.p2p.commonapi.*;
import java.util.*;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 *
 * Util methods used in the bunshin classes
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */
 
public class Utilities {
	
	public static Collection convert(NodeHandleSet set) {
	   int size = set.size();	
	   Vector v = new Vector(size);	
	   
	   for (int i=0;i<size;i++) {
	   	  NodeHandle nh =  set.getHandle(i);
	   	  v.add(nh);	   	
	   }	   
	   return v;
	}	

    public static Id generateHash (String data) {    	
      return generateHash(data.getBytes());      
    }
    
    public static Id generateHash (byte[] data) {
      MessageDigest md = null;

      try {
        md = MessageDigest.getInstance("SHA");
      }
      catch (NoSuchAlgorithmException e) {
        System.err.println("No SHA support!");
      }

      md.update(data);
      byte[] digest = md.digest();

      Id newId = rice.pastry.NodeId.buildNodeId(digest);

      return newId;
    }
    
  
}	