/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.util;

import rice.p2p.commonapi.*;
import java.util.*;
 
/**
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */

public class ReplicaTable extends Hashtable {

	public void put(String context, Id key, Collection c) {
		Hashtable replicas = (Hashtable) get(context);
		if (replicas==null) {
			replicas = new Hashtable();
		}		
		replicas.put(key,c);
		put(context,replicas);

	}

	public Collection get(String context, Id key) {
		Hashtable replicas = (Hashtable) get(context);
		if (replicas!=null) {
			return (Collection)replicas.get(key);
		}		
		return null;
	}

	public Collection remove(String context, Id key) {
		Collection c = null;
		Hashtable replicas = (Hashtable) get(context);
		if (replicas!=null) {
			c = (Collection) replicas.remove(key);
			if (replicas.size()>0) put(context,replicas);
			else remove(context);
		}
		return c;
	}

	public Collection getValues() {
	   Vector c = new Vector();
       Iterator it = keySet().iterator();
	   while(it.hasNext()){
         String context = (String) it.next();
	     Hashtable pairs = (Hashtable) get(context);
         if (pairs!=null) c.addAll(pairs.values());	    
	   }
	   return c;
	}



}