/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.util;

import java.security.*;
import java.io.*;
 
/**
 *
 * Password class
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */

public class Password implements Serializable {
	
	private byte[] pass;
	private boolean getcheck;
	
	public Password(String text) {
	  MessageDigest md = null;
	  this.getcheck = true;

      try {
        md = MessageDigest.getInstance("SHA");
      }
      catch (NoSuchAlgorithmException e) {
        System.err.println("No SHA support!");
      }

      md.update(text.getBytes());
      pass = md.digest();
	}
	
	public Password(String text, boolean getchech) {
		  MessageDigest md = null;
		  this.getcheck = getcheck;

	      try {
	        md = MessageDigest.getInstance("SHA");
	      }
	      catch (NoSuchAlgorithmException e) {
	        System.err.println("No SHA support!");
	      }

	      md.update(text.getBytes());
	      pass = md.digest();
		}
	
	public byte[] getData() {
		return pass;
	}
	
	public boolean isGetCheck() {
		return getcheck;
	}
	
	public boolean equals(Password pwd) {
		if (pwd!=null) return MessageDigest.isEqual(pass, pwd.getData()); 
		else return false;
	}	

}