/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.util;

import rice.p2p.commonapi.*;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/**
 *
 * The bucket, a chunk of hashtable, to belongs to specific key's rank
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */

public class Bucket implements java.io.Serializable, Cloneable {
	
	private Hashtable bucket;
	
	public Bucket() {
	  bucket = new Hashtable();
	} 
	
	
	public Bucket(Bucket b) {

	  	this.bucket = (Hashtable)b.getMap().clone();
  
	}
		
	public Hashtable getMap() {
	  return bucket;
	}

	
	public int size() {
	  return bucket.size();	
	}
	
	public boolean containsKey(Id key) {
	  return bucket.containsKey(key);
	}
	
	public void add(Bucket newBucket) {
	  if (newBucket.size()>0) bucket.putAll(newBucket.getMap());	
	}
	
	public synchronized void insert(Id key, Object value, String field) {
      
	  Values values  = null;
       
	  if (bucket.containsKey(key))  {	  	
	    values = (Values) bucket.get(key);
	  }		  		  
	  else {	  	
	  	values = new Values();	  	
	  }	
	  values.put(field,value);  
	  bucket.put(key,values);		
	  		
    }
	
	public synchronized void overwrite(Id key, Object value) {      
		bucket.put(key,value);	
    }
          	
	public synchronized Object remove(Id key) {   
       return bucket.remove(key);       	    	  
    }
	
	public synchronized Values delete(Id key, String field) {
   		Values values = (Values) bucket.get(key);
   		if (values!=null) {   		
   		  values.remove(field);
   		  if (values.size()>0) {
   		  	bucket.put(key,values);
   		  	return values;
   		  }	
   		  else {
   		  	bucket.remove(key); 
   		  	return null;
   		  }	
   		}   
   		return null;	    
   	   
    }   
            
   	public synchronized Object load(Id key, String field) {
   		Values values = (Values) bucket.get(key);
		if (values!=null) return values.get(field);	  
		return null;
    }   
   	
   	public synchronized Values extract(Id key) {   	 	
   	  return (Values) bucket.get(key);   		  
   	}     	
  
    public synchronized Set keySet() {
   	  return bucket.keySet();
   	}
   	
   	public String toString() {
   	  return "Bucket : "+bucket.toString();	
   	}
        
      
}