/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.test;

import bunshin.*;
import bunshin.util.*;
import rice.p2p.commonapi.*;

import javax.swing.*;
import java.io.*;
import java.net.*;

/**
 *  Stores an image URL and restores it.
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */
 
public class BunshinURLTest {

	public static void show(ImageIcon logo) {

		JFrame frame = new JFrame("Bunshin");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);   

		JPanel panel= new JPanel();
		JLabel label = new JLabel();

		label.setIcon(logo);  
		panel.add(label);
		
		frame.getContentPane().add(panel);  
		frame.setSize(300,300);
		frame.setVisible(true);

	}

	public static void main(String args[]) 
	{
		try 
		{
			BunshinConnection c = new BunshinConnection("bunshin.properties");    
			c.init("bunshin.properties");
			c.setInfoContext("url_test","../images","http://localhost/filedir",null);

			Id id = Utilities.generateHash("bunshin logo");
			
			int whatToDo = (Integer.valueOf(args[0])).intValue();
			System.out.println("whatToDo == "+whatToDo);

			if (whatToDo==0) 
			{

          
				URL url = new URL("http://planet.urv.es/bunshin/images/logobunshin.jpg");
			
			    //URL url = new URL("http://ants.etse.urv.es/planetsim/planetsim_2.0.zip");			    
				c.insertURL("url_test",id,url); 
				URL file_url = c.retrieveURL("url_test",id);    
				System.out.println("URL Found : "+file_url);
				
			}
			else 
			{		
			
				Thread.sleep(2000);
				byte[] bytes = (byte[]) c.retrieve("url_test",id,"URL");
				ImageIcon logo=new ImageIcon(bytes);
				show(logo);
			}
			System.out.println("Press <RETURN> to exit...");
  			System.in.read();
			c.leave();
			System.exit(0);
		}
		catch (Exception ex) 
		{
			ex.printStackTrace();
		}
	}
}    
