/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.test;

import bunshin.*;
import bunshin.listeners.*;
import bunshin.util.*;

import rice.p2p.commonapi.*;

import java.io.*;
import java.util.*;


/**
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */
 
public class BunshinLinkTest {	
 
  public static void main(String args[]) {

  try {

  	BufferedReader dis = new BufferedReader(new InputStreamReader (System.in));
  	
    BunshinSearch c = new BunshinSearch("bunshin.properties");
    c.init("bunshin.properties");
    
    boolean end = false;   
    
    while (!end) {

      System.out.println ("\nBunshinLinkTest Menu :");
      System.out.println ("0 - add links (id,keys)");
      System.out.println ("1 - remove links (id,keys)");
      System.out.println ("2 - set link listener (id)");
      System.out.println ("3 - remove link listener (id)");
      System.out.println ("4 - get outgoing links (id)");
      System.out.println ("5 - get incoming links (id)");
      System.out.println ("6 - exit");
      System.out.print("Choose an option : ");
      String input = dis.readLine();
      int whatToDo = Integer.parseInt(input);
      
      String key,number;
      Id id;
      int num;
      Vector vector;
      
      switch(whatToDo) {
        case 0 : 
        	System.out.println ("Enter String key...");
        	key = dis.readLine();    	
        	System.out.println ("How many outgoing links for this key? ");
        	number = dis.readLine();
        	num = Integer.parseInt(number);
        	Vector links = new Vector();
        	for (int i=0;i<num;i++) {
        	  System.out.println ("Enter Link key number "+(i+1)+"...");
              String s = dis.readLine();
              Id link = Utilities.generateHash(s);  
              links.add(link);
        	}
        	id = Utilities.generateHash(key);
        	c.addLinks(id,links);
        	System.out.println("operation successful");
        break;
        case 1 :
        	System.out.println ("Enter String key...");
        	key = dis.readLine();    	
        	System.out.println ("How many links to remove? ");
        	number = dis.readLine();
        	num = Integer.parseInt(number);
        	links = new Vector();
        	for (int i=0;i<num;i++) {
        	  System.out.println ("Enter Link key number "+(i+1)+"...");
              String s = dis.readLine();
              Id link = Utilities.generateHash(s);  
              links.add(link);
        	}
        	id = Utilities.generateHash(key);
        	c.removeLinks(id,links);
        	System.out.println("operation successful");
        break;
        case 2 : 
            	System.out.println ("Enter String key...");
            	key = dis.readLine();    	
            	id = Utilities.generateHash(key);
            	c.setLinkListener(id,new RemoteListener(){
            	  public void eventArrived(Object value, boolean added) {
            	    if (added) System.out.println("\n New Link added : "+value);
            	    else System.out.println("Link removed : "+value);
            	  }
                });
            	System.out.println("operation successful");
        break;
        case 3 :
        	    System.out.println ("Enter String key...");
        	    key = dis.readLine();    	
        	    id = Utilities.generateHash(key);
        	    c.removeLinkListener(id);
        	    System.out.println("operation successful");
        break;
        case 4 : 
        	    System.out.println ("Enter String key...");
        	    key = dis.readLine(); 
        	    id = Utilities.generateHash(key);
        	    Collection outgoing = c.getOutgoingLinks(id);
        	    System.out.println("Outgoing links : "+outgoing);
        break;
        case 5 :
        	    System.out.println ("Enter String key...");
    	        key = dis.readLine(); 
    	        id = Utilities.generateHash(key);
    	        Collection incoming = c.getIncomingLinks(id);
    	        System.out.println("Incoming links : "+incoming);
        break;        
        default :
          c.leave();
          System.out.println("Press <RETURN> to exit...");
          System.in.read();
          System.exit(0);          
      }
    }
    }
    catch(Exception ex) {      
      ex.printStackTrace();  
    }
  }
}
