/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.storage;

import java.util.*;
import bunshin.util.*;
import rice.p2p.commonapi.*;


/**
 * 
 * @author Ruben Mondejar
 */
public interface StorageManager {
 
  public void init(Properties prop);
  
  public void add(String context, Bucket newBucket) throws StorageException ;

  public void put(String context, Bucket newBucket) throws StorageException ;
  
  public void removeBucket(String context) throws StorageException;
	
  public void write(String context,Id key, Object value, String field) throws StorageException;
  
  public Object retrieve(String context,Id key, String field);
  
  public Values extract(String context,Id key);

  public Object remove(String context,Id key) throws StorageException;
  
  public Object delete(String context,Id key, String field) throws StorageException;
  
  public Bucket getBucket(String context);

  public Hashtable getBuckets();
  
  public boolean exists(String context,Id key);
  
  public boolean isFull();  
  
}

