/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.messaging;

import rice.p2p.commonapi.*;
import bunshin.util.*;
import java.net.*;

/**
 *
 * The replica message.
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */

public class ReplicaMessage extends BunshinMessage {

  private Id key;
  private Values values;
  private NodeHandle source;

  //replicaURL
  private URL url = null;
  private String field = null;
	
  public ReplicaMessage(Id key, Values values, NodeHandle source) {  	
  	this.key = key;  
  	this.values = values;
  	this.source = source;
  }  
  
  public ReplicaMessage(Id key, Values values, NodeHandle source, URL url, String field) {  	
		this.key = key;  
		this.values = values;
		this.source = source;
	    this.url = url;
	    this.field = field;
  }  

  public Id getKey() {
  	return key;  	
  }
  
  public Values getValues() {
  	return values;
  }
  
  public NodeHandle getNH() {
  	return source;
  }
 
  public URL getURL() {
    return url;
  }
  
  public String getField() {
    return field;
  }

  public boolean isURLReplica() {
    return (url!=null && field!=null);
  }
  
  public int getPriority() {
  	return Message.MEDIUM_HIGH_PRIORITY;
  }

  public String toString() {
    return "ReplicaMessage from :"+source+" with key "+key+" values : "+values;
  }

}
