/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin.messaging;

import rice.p2p.commonapi.*;
import bunshin.util.*;
import java.net.*;

/**
 *
 * The get url message.
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */


public class GetURLMessage extends BunshinMessage {

  private Id key;
  private String field;
  private int phase;
  private URL url;
  private NodeHandle nh = null;
  private NodeHandle previousNH = null;
  
	
  public GetURLMessage(Id key, String field, NodeHandle nh) {  	
  	
  	this.key = key;
  	this.field = field;  	
  	this.phase = 1;	    
    this.nh = nh; 
    this.previousNH = nh;    
    
  }  
  
  public GetURLMessage(Id key, URL url) {  	
  	
  	this.phase = 2;  	
    this.key = key;
    this.url = url; 
    
  }  
  
  public void setPreviousNH(NodeHandle previous) {
  	previousNH = previous;  	
  }
  
  public Id getKey() {
  	return key;  	
  }
  
  public String getField() {
    return field;
  }
  
  
  public int getPhase() {
  	return phase;
  }
  
  
  public URL getURL() {
  	return url;
  }
  
  public NodeHandle getNH() {
  	return nh;  	
  }  

  
  public NodeHandle getPreviousNH() {
  	return previousNH;  	
  }
  
  public int getPriority() {
  	return Message.MEDIUM_HIGH_PRIORITY;
  }
  
  public String toString() {
    return "GetURLMessage"+phase+" key : "+key+":"+url;
  }

}