/*******************************************************************************
 * Bunshin : DHT Replication & Caching
 * Copyright (C) 2004-2005 Ruben Mondejar
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

package bunshin;

import bunshin.util.*;
import bunshin.listeners.*;
import bunshin.storage.*;

import rice.p2p.commonapi.*;

import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.*;
import rice.pastry.dist.*;
import rice.pastry.standard.*;
import rice.pastry.direct.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.nio.channels.*;

/**
 *
 * This class wraps a validation connection to Bunshin substrate and is used by the application as its main
 * DHT substrate.
 *
 * @author Ruben Mondejar  <Ruben.Mondejar@estudiants.urv.es>
 */
 
public class BunshinValidation extends BunshinConnection {
	 
	 /**
   * Creates a node and stablishs the connection with the network
   * @param String of the path of the properties bunshin file   
   */ 
   public BunshinValidation(String path) throws Exception {       
     super(path);    
   }
  
    /**
   * Creates a node and stablishs the connection with the network
   * @param Properties bunshin file   
   */
  public BunshinValidation(Properties prop) throws Exception { 
     super(prop);  
  }
  
    /**
   * Creates a node and stablishs the connection with the network
   * @param String host
   * @param int port   
   */
  public BunshinValidation(String bootHost, int bootPort) { 
    super(bootHost,bootPort);
  }
  
	/**
	 * Puts the pair (key,value) with a validation password
	 * @param Context string
	 * @param Id of the key
	 * @param Serializable value  
	 * @param String pass  
	 */
	public void storeObject(String context,Id id, Serializable value, String pass) {
		bunshinApp.putSecure(context,id,value,"Object", pass);	  	
	}
	
	/**
	 * Puts the pair (key,value) with a validation password
	 * @param Context string
	 * @param Id of the key
	 * @param Serializable value  
	 * @param String pass
	 * @param Secure write too   
	 */
	public void storeObject(String context,Id id, Serializable value, String pass, boolean getcheck) {
		bunshinApp.putSecure(context,id,value,"Object", pass, getcheck);	  	
	}
	
   /** 
   * Asynchronous get method with a validation password
   * @param String value
   * @param BunshinGetClient the callback client
   * @param String pass 
   */
  public void retrieveObject(String context, Id key, String pass, BunshinGetClient client) throws IOException {

  	bunshinApp.getSecure(context,key,"Object", pass, client);
  }

  
  /** 
   * Remove method with a validation password
   * @param Id of the key 
   * @param String pass  
   */
  public void removeObject(String context,Id id, String pass) throws IOException {
  	bunshinApp.removeSecure(context,id,"Object", pass);
  }  
  
}
