/*
 * Decompiled with CFR 0.152.
 */
package bunshin.util;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ResultSortedQueue {
    private Vector keyQueue = new Vector();
    private Vector valueQueue = new Vector();
    private int[] limits;
    private Set matches;

    public ResultSortedQueue(Set matches) {
        this.matches = matches;
        this.limits = new int[matches.size() + 1];
    }

    private int matchesCalc(Set elems) {
        int num = 0;
        Iterator it = this.matches.iterator();
        while (it.hasNext()) {
            if (!elems.contains(it.next())) continue;
            ++num;
        }
        return num;
    }

    private int getMatches(int pos) {
        boolean found = false;
        for (int i = 0; i < this.limits.length - 2; ++i) {
            if (pos <= this.limits[i] || pos >= this.limits[i + 1]) continue;
            return i;
        }
        if (!found) {
            return this.limits.length - 1;
        }
        return -1;
    }

    public void add(Object key, Set elems) {
        int num = this.matchesCalc(elems);
        int pos = this.limits[num];
        int i = num + 1;
        while (i < this.limits.length) {
            int n = i++;
            this.limits[n] = this.limits[n] + 1;
        }
        this.keyQueue.add(pos, key);
        this.valueQueue.add(pos, elems);
    }

    public void delete(Object key) {
        int limit;
        int pos = this.keyQueue.indexOf(key);
        this.keyQueue.removeElementAt(pos);
        this.valueQueue.removeElementAt(pos);
        int n = limit = this.getMatches(pos);
        this.limits[n] = this.limits[n] - 1;
    }

    public Iterator iterator() {
        return this.keyQueue.iterator();
    }

    public String toString() {
        String s = "\nResultSortedQueue (" + this.keyQueue.size() + " elements) :\n";
        for (int i = this.keyQueue.size() - 1; i >= 0; --i) {
            int num_matches = this.getMatches(i);
            Object key = this.keyQueue.get(i);
            Object value = this.valueQueue.get(i);
            int num = this.matchesCalc((Set)value);
            s = s + "Key : " + key + " (" + num + " matches) --> " + value + "\n";
        }
        return s;
    }

    public ResultIterator getItems() {
        return new ResultIterator();
    }

    public class Item {
        private Object value = null;
        private int numberMatches = 0;
        private Set matches = null;

        public Item(int index) {
            this.value = ResultSortedQueue.this.keyQueue.get(index);
            this.matches = (Set)ResultSortedQueue.this.valueQueue.get(index);
            this.numberMatches = ResultSortedQueue.this.matchesCalc(this.matches);
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public int getNumberOfMatches() {
            return this.numberMatches;
        }

        public Set getAllMatches() {
            return this.matches;
        }
    }

    public class ResultIterator {
        private int index = 0;

        public ResultIterator() {
            this.index = ResultSortedQueue.this.keyQueue.size() - 1;
        }

        public boolean hasNext() {
            return this.index >= 0;
        }

        public Item next() {
            Item item = new Item(this.index);
            --this.index;
            return item;
        }
    }
}

