/*
 * Decompiled with CFR 0.152.
 */
package bunshin.util;

import bunshin.util.Values;
import java.util.ArrayList;
import java.util.Iterator;
import rice.p2p.commonapi.Id;

public class Cache {
    private int TTL = 0;
    private int MAX_ELEM = 0;
    private ArrayList elems = new ArrayList();
    private ArrayList keys = new ArrayList();
    private ArrayList contexts = new ArrayList();
    private ArrayList ttls = new ArrayList();

    public Cache(int TTL, int MAX_ELEM) {
        this.TTL = TTL;
        this.MAX_ELEM = MAX_ELEM;
    }

    public synchronized void put(String context, Id key, Values values) {
        this.elems.add(values);
        this.keys.add(key);
        this.contexts.add(context);
        this.ttls.add(new Integer(0));
        if (this.keys.size() > this.MAX_ELEM) {
            this.elems.remove(0);
            this.keys.remove(0);
            this.contexts.remove(0);
            this.ttls.remove(0);
        }
    }

    public Values get(String context, Id key) {
        if (this.contains(context, key)) {
            int max = this.elems.size();
            for (int i = 0; i < max; ++i) {
                if (!this.contexts.get(i).equals(context) || !this.keys.get(i).equals(key)) continue;
                return (Values)this.elems.get(i);
            }
        }
        return null;
    }

    public boolean contains(String context, Id key) {
        return this.contexts.contains(context) && this.keys.contains(key);
    }

    public synchronized void incTime() {
        Iterator it = this.ttls.iterator();
        int i = 0;
        while (it.hasNext()) {
            int ttl = (Integer)it.next() + 1;
            if (ttl > this.TTL) {
                this.elems.remove(i);
                this.keys.remove(i);
                this.contexts.remove(i);
                this.ttls.remove(i);
                continue;
            }
            ++i;
        }
    }
}

