/*
 * Decompiled with CFR 0.152.
 */
package bunshin.test;

import bunshin.BunshinSearch;
import bunshin.RemoteListener;
import bunshin.storage.MemStorage;
import bunshin.util.Utilities;
import bunshin.util.Values;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import rice.p2p.commonapi.Id;

public class SimpleTest
extends TestCase {
    protected static BunshinSearch[] bunshin;
    protected static final int num = 5;
    protected static Id global_id;

    public SimpleTest(String name) {
        super(name);
    }

    protected void setUp() {
        try {
            bunshin = new BunshinSearch[5];
            for (int i = 0; i < 5; ++i) {
                SimpleTest.bunshin[i] = new BunshinSearch("auto", 5009);
                Thread.sleep(1000L);
                bunshin[i].init("BunshinTest", new MemStorage(), 3, 8, false, true);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void finishTest() {
        for (int i = 0; i < 5; ++i) {
            bunshin[i].leave();
        }
    }

    public static Test suite() {
        return new TestSuite(SimpleTest.class);
    }

    public void testStore() throws Exception {
        String id = "time";
        long time = System.currentTimeMillis();
        Id key = bunshin[0].storeObject(id, (Serializable)new Long(time));
        Thread.currentThread();
        Thread.sleep(5000L);
        long time2 = System.currentTimeMillis();
        bunshin[0].storeObject(id, (Serializable)new Long(time2));
        Thread.currentThread();
        Thread.sleep(5000L);
        Long tr = (Long)bunshin[4].retrieveObject(key);
        SimpleTest.assertEquals((long)time2, (long)tr);
        SimpleTest.finishTest();
    }

    public void testStoreDuplicate() throws Exception {
        String id = "time";
        long time = System.currentTimeMillis();
        Id key = bunshin[0].storeObject(id, (Serializable)new Long(time));
        Thread.currentThread();
        Thread.sleep(5000L);
        long time2 = System.currentTimeMillis();
        bunshin[1].storeObject(id, (Serializable)new Long(time2));
        Thread.currentThread();
        Thread.sleep(5000L);
        Long tr = (Long)bunshin[4].retrieveObject(key);
        SimpleTest.assertEquals((long)time2, (long)tr);
        SimpleTest.finishTest();
    }

    public void testStoreCVS() throws Exception {
        String id = "time";
        long time = System.currentTimeMillis();
        Values v1 = new Values();
        v1.put("Object", new Long(time));
        Id key = bunshin[0].storeObject(id, (Serializable)v1);
        Thread.currentThread();
        Thread.sleep(5000L);
        long time2 = System.currentTimeMillis();
        Values v2 = new Values();
        v2.put("Object", new Long(time2));
        bunshin[1].storeObject(id, (Serializable)v2);
        Thread.currentThread();
        Thread.sleep(5001L);
        long time3 = System.currentTimeMillis();
        Values v3 = new Values();
        v3.put("Object", new Long(time3));
        v3.put("CVS", new Integer(0));
        bunshin[2].storeObject(id, (Serializable)v3);
        Thread.currentThread();
        Thread.sleep(5001L);
        Long tr = (Long)bunshin[4].retrieveObject(key);
        SimpleTest.assertEquals((long)time2, (long)tr);
        SimpleTest.finishTest();
    }

    public void testMultiContext() throws Exception {
        String key = "time";
        Id id = Utilities.generateHash(key);
        long time = System.currentTimeMillis();
        bunshin[0].storeObject("context1", id, new Long(time));
        Thread.currentThread();
        Thread.sleep(5000L);
        long time2 = System.currentTimeMillis();
        bunshin[1].storeObject("context2", id, new Long(time2));
        Thread.currentThread();
        Thread.sleep(5000L);
        Long tr = (Long)bunshin[4].retrieveObject("context1", id);
        SimpleTest.assertEquals((long)time, (long)tr);
        tr = (Long)bunshin[4].retrieveObject("context2", id);
        SimpleTest.assertEquals((long)time2, (long)tr);
        SimpleTest.finishTest();
    }

    public void testLinkListener() throws Exception {
        String google_url = "http://www.google.com";
        Id google_id = Utilities.generateHash(google_url);
        Hashtable<String, Object> google_info = new Hashtable<String, Object>();
        google_info.put("url", google_url);
        google_info.put("date", new Date());
        bunshin[1].storeObject(google_id, google_info);
        Thread.currentThread();
        Thread.sleep(1000L);
        String etse_url = "http://www.etse.urv.es";
        Id etse_id = Utilities.generateHash(etse_url);
        Hashtable<String, Object> etse_info = new Hashtable<String, Object>();
        etse_info.put("url", etse_url);
        etse_info.put("date", new Date());
        bunshin[3].storeObject(etse_id, etse_info);
        Thread.currentThread();
        Thread.sleep(1000L);
        global_id = null;
        bunshin[0].setLinkListener(etse_id, new RemoteListener(){

            public void eventArrived(Object value, boolean added) {
                if (value instanceof Collection) {
                    Iterator it = ((Collection)value).iterator();
                    global_id = (Id)it.next();
                } else if (value instanceof Id) {
                    global_id = (Id)value;
                }
                System.out.println("\n New incoming link to http://www.etse.urv.es -> link_id : " + global_id + " \n");
            }
        });
        Thread.currentThread();
        Thread.sleep(2000L);
        Vector<Id> google_links = new Vector<Id>();
        google_links.add(etse_id);
        bunshin[2].addLinks(google_id, google_links);
        Thread.currentThread();
        Thread.sleep(1000L);
        SimpleTest.assertEquals((Object)google_id, (Object)global_id);
        SimpleTest.finishTest();
    }

    static {
        global_id = null;
    }
}

