/*
 * Decompiled with CFR 0.152.
 */
package bunshin.test;

import bunshin.BunshinConnection;
import bunshin.util.Utilities;
import java.io.Serializable;
import java.util.Vector;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDGenerator;
import rice.p2p.commonapi.Id;

public class BunshinPlanetLabTest {
    public static BunshinConnection c;
    public static Vector keys;

    public static String getUID() {
        UUIDGenerator gen = UUIDGenerator.getInstance();
        UUID id = gen.generateRandomBasedUUID();
        return id.toString();
    }

    public static void main(String[] args) {
        boolean allRight = true;
        try {
            c = new BunshinConnection("bunshin.properties");
            int num = Integer.valueOf(args[0]);
            keys = new Vector(num);
            c.init("bunshin.properties");
            Thread.sleep(5000L);
            for (int i = 0; i < num; ++i) {
                String random = BunshinPlanetLabTest.getUID();
                Id key = Utilities.generateHash(random);
                keys.add(key);
            }
            for (int valueFactor = 1; valueFactor < 4; ++valueFactor) {
                System.out.println("Test number " + valueFactor);
                for (int i = 0; i < num; ++i) {
                    Id key = (Id)keys.get(i);
                    c.storeObject(key, (Serializable)new Integer(i * valueFactor));
                    keys.add(key);
                    try {
                        System.out.println("Insert key " + key + " value " + i * valueFactor);
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                Thread.sleep(3000L);
                int miss = 0;
                int hits = 0;
                for (int i = 0; i < num; ++i) {
                    Id key = (Id)keys.get(i);
                    Integer value = (Integer)c.retrieveObject(key);
                    boolean successful = true;
                    if (value == null) {
                        successful = false;
                    } else if (value != i * valueFactor) {
                        successful = false;
                    }
                    for (int retry = 0; !successful && retry < 10; ++retry) {
                        value = (Integer)c.retrieveObject(key);
                    }
                    Thread.sleep(100L);
                    if (value != null && value == i * valueFactor) {
                        ++hits;
                        System.out.println("Hit in key " + key);
                        continue;
                    }
                    ++miss;
                    if (value != null) {
                        System.out.println("Miss in key " + key + " by bad version :" + value / i);
                        continue;
                    }
                    System.out.println("Miss in key " + key + " by null value");
                }
                System.out.println("Total: " + num + " -> Hits:" + hits + " / Miss:" + miss);
                if (miss <= 0) continue;
                allRight = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        c.leave();
        if (allRight) {
            System.out.println("Test successfull");
        } else {
            System.out.println("Test failed");
        }
        System.exit(0);
    }
}

