/*
 * Decompiled with CFR 0.152.
 */
package bunshin.storage;

import bunshin.storage.StorageException;
import bunshin.storage.StorageManager;
import bunshin.util.Bucket;
import bunshin.util.Values;
import java.util.Hashtable;
import java.util.Properties;
import rice.p2p.commonapi.Id;

public class MemStorage
implements StorageManager {
    private Hashtable memTable = new Hashtable();

    public void init(Properties prop) {
    }

    public void add(String context, Bucket newBucket) throws StorageException {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            mem.add(newBucket);
        }
    }

    public void put(String context, Bucket newBucket) throws StorageException {
        this.memTable.put(context, newBucket);
    }

    public void removeBucket(String context) throws StorageException {
        this.memTable.remove(context);
    }

    public void write(String context, Id key, Object value, String field) throws StorageException {
        Bucket mem = this.memTable.containsKey(context) ? (Bucket)this.memTable.get(context) : new Bucket();
        if (field != null && !(value instanceof Values)) {
            mem.insert(key, value, field);
        } else {
            mem.overwrite(key, value);
        }
        this.memTable.put(context, mem);
    }

    public Object retrieve(String context, Id key, String field) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            return mem.load(key, field);
        }
        return null;
    }

    public Values extract(String context, Id key) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            return mem.extract(key);
        }
        return null;
    }

    public Bucket getBucket(String context) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            return mem;
        }
        return null;
    }

    public Hashtable getBuckets() {
        return this.memTable;
    }

    public Object remove(String context, Id key) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            return mem.remove(key);
        }
        return null;
    }

    public Object delete(String context, Id key, String field) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            return mem.delete(key, field);
        }
        return null;
    }

    public boolean exists(String context, Id key) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            return mem.containsKey(key);
        }
        return false;
    }

    public boolean isFull() {
        return false;
    }
}

