/*
 * Decompiled with CFR 0.152.
 */
package bunshin.storage;

import bunshin.storage.StorageException;
import bunshin.storage.StorageManager;
import bunshin.util.Bucket;
import bunshin.util.Pair;
import bunshin.util.Values;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import rice.p2p.commonapi.Id;
import rice.pastry.NodeId;

public class DiskStorage
implements StorageManager {
    private String ROOT_PATH = "storage";
    private RescueTask rescueTask;
    private Timer timer = new Timer();
    private Hashtable paths = new Hashtable();
    private Hashtable maps = new Hashtable();
    private Hashtable memTable = new Hashtable();
    private long max = 0L;

    public DiskStorage() {
    }

    public DiskStorage(String root_path) {
        this.ROOT_PATH = root_path;
        this.loadInfoDir();
        this.loadAll();
    }

    public DiskStorage(String root_path, long max_size) {
        this.ROOT_PATH = root_path;
        long max = max_size;
        this.loadInfoDir();
        this.loadAll();
    }

    public DiskStorage(long max_size) {
        long max = max_size;
        this.loadInfoDir();
        this.loadAll();
    }

    public void init(Properties prop) {
        String root_path = (String)prop.get("BUNSHIN_STORAGE_ROOT_DIR");
        if (root_path != null) {
            this.ROOT_PATH = root_path + this.ROOT_PATH;
            System.out.println("ROOT_PATH : " + this.ROOT_PATH);
        }
        this.loadInfoDir();
        this.loadAll();
    }

    public void setPath(String context, String path) {
        String oldPath = (String)this.paths.get(context);
        if (oldPath != null && !oldPath.equals(path)) {
            File f = new File(oldPath);
            File f2 = new File(path);
            if (f != null) {
                f2.renameTo(f);
            } else {
                f2.mkdirs();
            }
        } else {
            File f2 = new File(path);
            f2.mkdirs();
        }
        this.paths.put(context, path);
        this.saveInfoDir();
    }

    public void add(String context, Bucket newBucket) throws StorageException {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            for (Id key : newBucket.keySet()) {
                Values values = newBucket.extract(key);
                this.mapping(context, key, values, null);
            }
            mem.add(newBucket);
            this.memTable.put(context, mem);
        } else {
            for (Id key : newBucket.keySet()) {
                Values values = newBucket.extract(key);
                this.mapping(context, key, values, null);
            }
            this.memTable.put(context, newBucket);
        }
        if (this.max == 0L || this.memSize() < this.max) {
            try {
                this.saveAll(context);
            }
            catch (IOException ex) {
                throw new StorageException(ex);
            }
        }
    }

    public void put(String context, Bucket newBucket) throws StorageException {
        for (Id key : newBucket.keySet()) {
            Values values = newBucket.extract(key);
            this.mapping(context, key, values, null);
        }
        this.memTable.put(context, newBucket);
        if (this.max == 0L || this.memSize() < this.max) {
            try {
                this.removeAll(context);
                this.saveAll(context);
            }
            catch (IOException ex) {
                throw new StorageException(ex);
            }
        }
    }

    private boolean mapping(String context, Id key, Values values, String field) {
        boolean successful = false;
        try {
            String filename = (String)values.get("#filename");
            if (filename != null) {
                Hashtable<Id, String> map = (Hashtable<Id, String>)this.maps.get(context);
                if (map == null) {
                    map = new Hashtable<Id, String>();
                }
                map.put(key, filename);
                this.maps.put(context, map);
                if (field == null && values.containsKey("#field")) {
                    field = (String)values.get("#field");
                }
                if (field != null) {
                    byte[] bytes = (byte[])values.remove(field);
                    if (bytes != null) {
                        this.saveMapFile(context, key, filename, bytes);
                    }
                    values.put(field, '#' + filename);
                }
                successful = true;
                System.out.println("mapping :" + values);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return successful;
    }

    public void write(String context, Id key, Object value, String field) throws StorageException {
        Bucket mem = this.memTable.containsKey(context) ? (Bucket)this.memTable.get(context) : new Bucket();
        boolean overwrite = false;
        if (value instanceof Values) {
            overwrite = this.mapping(context, key, (Values)value, field);
        }
        if (overwrite || field == null) {
            mem.overwrite(key, value);
        } else if (!(value instanceof Values)) {
            mem.insert(key, value, field);
        } else {
            mem.overwrite(key, value);
        }
        this.memTable.put(context, mem);
        if (this.max == 0L || this.memSize() < this.max) {
            try {
                this.save(context, key);
            }
            catch (IOException ex) {
                throw new StorageException(ex);
            }
        }
    }

    public Object remove(String context, Id key) throws StorageException {
        Object obj = null;
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            obj = mem.remove(key);
            if (this.max == 0L || this.memSize() < this.max) {
                try {
                    Hashtable map = (Hashtable)this.maps.get(context);
                    if (map != null && map.containsKey(key)) {
                        String filename = (String)map.remove(key);
                        this.removeMapFile(context, key, filename);
                    }
                    this.delete(context, key);
                }
                catch (IOException ex) {
                    throw new StorageException(ex);
                }
            }
        }
        return obj;
    }

    public Object delete(String context, Id key, String field) throws StorageException {
        System.out.println("delete in" + context + " & key " + key + " & field " + field);
        Values obj = null;
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            obj = mem.delete(key, field);
            try {
                if (obj != null) {
                    if (this.max == 0L || this.memSize() < this.max) {
                        this.save(context, key);
                    }
                } else {
                    this.delete(context, key);
                }
            }
            catch (IOException ex) {
                throw new StorageException(ex);
            }
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object retrieve(String context, Id key, String field) {
        if (!this.memTable.containsKey(context)) return null;
        Bucket mem = (Bucket)this.memTable.get(context);
        Object obj = mem.load(key, field);
        if (obj == null) return obj;
        if (!(obj instanceof String)) return obj;
        String s = (String)obj;
        if (s.charAt(0) != '#') return obj;
        Hashtable map = (Hashtable)this.maps.get(context);
        if (map == null) return null;
        String filename = (String)map.get(key);
        try {
            return this.loadMapFile(context, key, filename);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Values unmapping(String context, Id key, Values values) {
        Values values2 = (Values)values.clone();
        for (String field : values2.keySet()) {
            Hashtable map;
            String s;
            Object value = values.get(field);
            if (value == null || !(value instanceof String) || (s = (String)value).charAt(0) != '#' || (map = (Hashtable)this.maps.get(context)) == null) continue;
            String filename = (String)map.get(key);
            try {
                byte[] bytes = this.loadMapFile(context, key, filename);
                values.put("#filename", filename);
                values.put("#field", field);
                values.put(field, bytes);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return values;
    }

    public synchronized Values extract(String context, Id key) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            Values values = mem.extract(key);
            if (values != null) {
                values = this.unmapping(context, key, values);
            }
            return values;
        }
        return null;
    }

    public synchronized Bucket getBucket(String context) {
        if (this.memTable.containsKey(context)) {
            Bucket mem1 = (Bucket)this.memTable.get(context);
            Bucket mem = new Bucket(mem1);
            for (Id key : mem.keySet()) {
                Values values = mem.extract(key);
                if (values == null) continue;
                values = this.unmapping(context, key, values);
                mem.overwrite(key, values);
            }
            return mem;
        }
        return null;
    }

    public synchronized Hashtable getBuckets() {
        Hashtable<String, Bucket> buckets = new Hashtable<String, Bucket>();
        for (String context : this.memTable.keySet()) {
            Bucket mem = this.getBucket(context);
            buckets.put(context, mem);
        }
        return buckets;
    }

    public boolean exists(String context, Id key) {
        if (this.memTable.containsKey(context)) {
            Bucket mem = (Bucket)this.memTable.get(context);
            return mem.containsKey(key);
        }
        return false;
    }

    private void saveInfoDir() {
        try {
            File f = new File(this.ROOT_PATH);
            if (!f.exists()) {
                f.mkdirs();
            }
            f = new File(this.ROOT_PATH + "/" + "infoDir");
            f.createNewFile();
            FileOutputStream out = new FileOutputStream(f);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(this.paths);
            oos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadInfoDir() {
        try {
            File dir = new File(this.ROOT_PATH);
            if (dir.exists()) {
                File f = new File(this.ROOT_PATH + "/" + "infoDir");
                if (f.exists()) {
                    FileInputStream in = new FileInputStream(f);
                    ObjectInputStream ois = new ObjectInputStream(in);
                    this.paths = (Hashtable)ois.readObject();
                    ois.close();
                    if (this.paths == null) {
                        this.paths = new Hashtable();
                    }
                }
                File[] subdirs = dir.listFiles();
                for (int i = 0; i < subdirs.length; ++i) {
                    if (!subdirs[i].isDirectory()) continue;
                    this.paths.put(subdirs[i].getName(), subdirs[i].getPath());
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private void save(String context, Id key) throws IOException {
        File f;
        String dir = (String)this.paths.get(context);
        if (dir == null) {
            dir = this.ROOT_PATH + "/" + context;
        }
        if (!(f = new File(dir)).exists()) {
            f.mkdirs();
        }
        Bucket mem = (Bucket)this.memTable.get(context);
        Values values = mem.extract(key);
        Pair pair = new Pair(key, values);
        String name = ((NodeId)key).toStringFull();
        f = new File(dir + "/" + name + ".val");
        f.createNewFile();
        FileOutputStream out = new FileOutputStream(f);
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(pair);
        oos.close();
    }

    private void saveMapFile(String context, Id key, String filename, byte[] bytes) throws IOException {
        File f;
        String dir = (String)this.paths.get(context);
        if (dir == null) {
            dir = this.ROOT_PATH + "/" + context;
        }
        if (!(f = new File(dir)).exists()) {
            f.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(dir + "/mapping");
        ObjectOutputStream oos = new ObjectOutputStream(out);
        Hashtable map = (Hashtable)this.maps.get(context);
        if (map != null) {
            oos.writeObject(map);
        }
        oos.flush();
        oos.close();
        FileOutputStream fout = new FileOutputStream(dir + '/' + filename);
        fout.write(bytes);
        fout.flush();
        fout.close();
    }

    private void removeMapFile(String context, Id key, String filename) throws IOException {
        File f;
        String dir = (String)this.paths.get(context);
        if (dir == null) {
            dir = this.ROOT_PATH + "/" + context;
        }
        if (!(f = new File(dir)).exists()) {
            f.mkdirs();
        }
        File file = new File(dir + "/mapping");
        Hashtable map = (Hashtable)this.maps.get(context);
        if (map != null) {
            if (map.size() > 0) {
                FileOutputStream out = new FileOutputStream(file);
                ObjectOutputStream oos = new ObjectOutputStream(out);
                oos.writeObject(map);
                oos.flush();
                oos.close();
            } else {
                file.delete();
            }
        } else {
            file.delete();
        }
        File file2 = new File(dir + '/' + filename);
        file2.delete();
    }

    private byte[] loadMapFile(String context, Id key, String filename) throws IOException {
        File f;
        String dir = (String)this.paths.get(context);
        if (dir == null) {
            dir = this.ROOT_PATH + "/" + context;
        }
        if (!(f = new File(dir + '/' + filename)).exists()) {
            f.mkdirs();
        }
        FileInputStream fin = new FileInputStream(f);
        byte[] bytes = new byte[(int)f.length()];
        fin.read(bytes);
        fin.close();
        return bytes;
    }

    private void delete(String context, Id key) throws IOException {
        File f;
        String dir = (String)this.paths.get(context);
        if (dir == null) {
            dir = this.ROOT_PATH + "/" + context;
        }
        if (!(f = new File(dir)).exists()) {
            f.mkdirs();
        }
        String name = ((NodeId)key).toStringFull();
        f = new File(dir + "/" + name + ".val");
        f.delete();
    }

    public void removeBucket(String context) throws StorageException {
        this.memTable.remove(context);
        try {
            this.removeAll(context);
        }
        catch (IOException ex) {
            throw new StorageException(ex);
        }
    }

    private void removeAll(String context) throws IOException {
        File f;
        String dir = (String)this.paths.get(context);
        if (dir == null) {
            dir = this.ROOT_PATH + "/" + context;
        }
        if ((f = new File(dir)).exists()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
            f.delete();
        }
    }

    private void saveAll(String context) throws IOException {
        File f;
        String dir = (String)this.paths.get(context);
        if (dir == null) {
            dir = this.ROOT_PATH + "/" + context;
        }
        if (!(f = new File(dir)).exists()) {
            f.mkdirs();
        }
        Bucket mem = (Bucket)this.memTable.get(context);
        Set c = mem.keySet();
        for (Id key : c) {
            Values values = mem.extract(key);
            Pair pair = new Pair(key, values);
            String name = ((NodeId)key).toStringFull();
            f = new File(dir + "/" + name + ".val");
            f.createNewFile();
            FileOutputStream out = new FileOutputStream(f);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(pair);
            oos.close();
        }
    }

    private void saveAll() throws IOException {
        for (String context : this.paths.keySet()) {
            File f;
            String dir = (String)this.paths.get(context);
            if (dir == null) {
                dir = this.ROOT_PATH + "/" + context;
            }
            if (!(f = new File(dir)).exists()) {
                f.mkdirs();
            }
            Bucket mem = (Bucket)this.memTable.get(context);
            Set c = mem.keySet();
            for (Id key : c) {
                Values values = mem.extract(key);
                Pair pair = new Pair(key, values);
                String name = ((NodeId)key).toStringFull();
                f = new File(dir + "/" + name + ".val");
                f.createNewFile();
                FileOutputStream out = new FileOutputStream(f);
                ObjectOutputStream oos = new ObjectOutputStream(out);
                oos.writeObject(pair);
                oos.close();
            }
        }
    }

    private void loadAll() {
        Vector<Object> crashes = new Vector<Object>();
        for (String context : this.paths.keySet()) {
            File f;
            Bucket mem = (Bucket)this.memTable.get(context);
            if (mem == null) {
                mem = new Bucket();
            }
            String dir = (String)this.paths.get(context);
            System.out.println("context dir :" + dir);
            if (dir == null) {
                dir = this.ROOT_PATH + "/" + context;
            }
            if (!(f = new File(dir)).exists()) {
                f.mkdirs();
            }
            if (!f.isDirectory()) continue;
            try {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    ObjectInputStream ois;
                    FileInputStream in = new FileInputStream(files[i]);
                    String name = files[i].getName();
                    if (name.equals("mapping")) {
                        ois = new ObjectInputStream(in);
                        Hashtable map = (Hashtable)ois.readObject();
                        ois.close();
                        if (map == null) {
                            map = new Hashtable();
                        } else {
                            System.out.println("map loaded -> context " + context + " map : " + map);
                        }
                        this.maps.put(context, map);
                        continue;
                    }
                    if (!name.substring(name.length() - 3).equals("val")) continue;
                    ois = new ObjectInputStream(in);
                    System.out.println("TRYING :" + name);
                    try {
                        Pair pair = (Pair)ois.readObject();
                        Id key = pair.getKey();
                        Values values = pair.getValues();
                        mem.overwrite(key, values);
                        this.memTable.put(context, mem);
                    }
                    catch (Exception e) {
                        System.out.println("CRASHING :" + name);
                        crashes.add(files[i]);
                        crashes.add(context);
                        crashes.add(mem);
                    }
                    ois.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Size " + this.memSize());
        if (!crashes.isEmpty()) {
            this.rescueTask = new RescueTask(crashes);
            this.timer.schedule((TimerTask)this.rescueTask, 5000L);
            System.out.println("\n\n\nNew Timer, rescue files : " + crashes.size() / 3);
        }
    }

    private long memSize() {
        long size = 0L;
        for (String context : this.paths.keySet()) {
            File f;
            String dir = (String)this.paths.get(context);
            if (dir == null) {
                dir = this.ROOT_PATH + "/" + context;
            }
            if (!(f = new File(dir)).exists()) {
                f.mkdirs();
            }
            if (!f.isDirectory()) continue;
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                size += files[i].length();
            }
        }
        return size;
    }

    public boolean isFull() {
        return this.memSize() < this.max;
    }

    class RescueTask
    extends TimerTask {
        private Vector crashes;

        public RescueTask(Vector crashes) {
            this.crashes = crashes;
        }

        public void run() {
            Vector<Object> newCrashes = new Vector<Object>();
            try {
                Iterator it = this.crashes.iterator();
                while (it.hasNext()) {
                    ObjectInputStream ois;
                    File file = (File)it.next();
                    String context = (String)it.next();
                    Bucket mem = (Bucket)it.next();
                    FileInputStream in = new FileInputStream(file);
                    String name = file.getName();
                    if (name.equals("mapping")) {
                        ois = new ObjectInputStream(in);
                        Hashtable map = (Hashtable)ois.readObject();
                        ois.close();
                        if (map == null) {
                            map = new Hashtable();
                        } else {
                            System.out.println("map loaded -> context " + context + " map : " + map);
                        }
                        DiskStorage.this.maps.put(context, map);
                        continue;
                    }
                    if (!name.substring(name.length() - 3).equals("val")) continue;
                    ois = new ObjectInputStream(in);
                    System.out.println("TRYING :" + name);
                    try {
                        Pair pair = (Pair)ois.readObject();
                        Id key = pair.getKey();
                        Values values = pair.getValues();
                        mem.overwrite(key, values);
                        DiskStorage.this.memTable.put(context, mem);
                    }
                    catch (Exception e) {
                        System.out.println("CRASHING :" + name);
                        newCrashes.add(file);
                        newCrashes.add(context);
                        newCrashes.add(mem);
                    }
                    ois.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            if (!newCrashes.isEmpty()) {
                DiskStorage.this.rescueTask = new RescueTask(newCrashes);
                DiskStorage.this.timer.schedule((TimerTask)DiskStorage.this.rescueTask, 5000L);
                System.out.println("\n\n\nOther Timer, rescue files : " + newCrashes.size() / 3);
            }
        }
    }
}

