/*
 * Decompiled with CFR 0.152.
 */
package bunshin;

import bunshin.BunshinConnection;
import bunshin.RemoteListener;
import bunshin.util.ResultSortedQueue;
import bunshin.util.Utilities;
import bunshin.util.Values;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import rice.p2p.commonapi.Id;

public class BunshinSearch
extends BunshinConnection {
    public BunshinSearch(String path) throws Exception {
        super(path);
    }

    public BunshinSearch(Properties prop) throws Exception {
        super(prop);
    }

    public BunshinSearch(String bootHost, int bootPort) {
        super(bootHost, bootPort);
    }

    private Set getKeywords(String tokens) {
        StringTokenizer st = new StringTokenizer(tokens);
        TreeSet<String> keyworks = new TreeSet<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 2) continue;
            keyworks.add(token);
        }
        return keyworks;
    }

    public Id insert(String tokens, Serializable value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(value);
        os.close();
        byte[] bytes = bos.toByteArray();
        Id idValue = Utilities.generateHash(bytes);
        this.insert(tokens, idValue, value);
        return idValue;
    }

    public void insert(String tokens, Id idValue, Serializable value) throws IOException {
        System.err.println("Insert: " + tokens + " id " + idValue.toStringFull());
        Set keywords = this.getKeywords(tokens);
        super.storeObject(idValue, (Serializable)((Object)keywords), "#keywords");
        super.storeObject(idValue, value);
        for (String token : keywords) {
            Set keywords1 = (Set)((TreeSet)keywords).clone();
            Id key = Utilities.generateHash(token);
            System.err.println("Insert: lookup " + token + " key " + key.toStringFull());
            Hashtable<Id, Set> prop = (Hashtable<Id, Set>)super.retrieveObject(key, "#index");
            if (prop == null) {
                System.out.println("New prop + " + keywords1);
                prop = new Hashtable<Id, Set>();
                prop.put(idValue, keywords1);
            } else {
                Set previous = (Set)prop.get(idValue);
                System.out.println("Old prop --> " + previous + " + " + keywords1);
                if (previous != null) {
                    keywords1.addAll(previous);
                }
                prop.put(idValue, keywords1);
            }
            super.storeObject(key, prop, "#index");
        }
    }

    public ResultSortedQueue query(String query_key) throws IOException {
        System.err.println("Query: " + query_key);
        Set keywords = this.getKeywords(query_key);
        ResultSortedQueue result = new ResultSortedQueue(keywords);
        Hashtable<Id, Set<String>> merge = new Hashtable<Id, Set<String>>();
        for (String token : keywords) {
            Id key = Utilities.generateHash(token);
            System.err.println("Query token " + token + " key " + key.toStringFull());
            Hashtable prop = (Hashtable)super.retrieveObject(key, "#index");
            if (prop == null) continue;
            for (Id idValue : prop.keySet()) {
                Set<String> keywordSet;
                if (merge.containsKey(idValue)) {
                    keywordSet = (Set)merge.get(idValue);
                    System.out.println("previous " + keywordSet + " + new " + keywords);
                    keywordSet.add(token);
                    merge.put(idValue, keywordSet);
                    continue;
                }
                keywordSet = new TreeSet();
                keywordSet.add(token);
                merge.put(idValue, keywordSet);
            }
        }
        for (Id idValue : merge.keySet()) {
            Set elems = (Set)merge.get(idValue);
            result.add(idValue, elems);
        }
        return result;
    }

    public void remove(String tokens, Id idValue) throws IOException {
        System.err.println("IN REMOVE !!!! " + tokens + " id " + idValue.toStringFull());
        Set keywords = null;
        if (tokens != null) {
            keywords = this.getKeywords(tokens);
        }
        if (keywords == null || keywords.isEmpty()) {
            keywords = (Set)super.retrieveObject(idValue, "#keywords");
        }
        super.removeObject(idValue, "#keywords");
        super.removeObject(idValue);
        if (keywords != null) {
            for (String token : keywords) {
                Set previous;
                Set keywords1 = (Set)((TreeSet)keywords).clone();
                Id key = Utilities.generateHash(token);
                Hashtable prop = (Hashtable)super.retrieveObject(key, "#index");
                if (prop == null || (previous = (Set)prop.get(idValue)) == null) continue;
                prop.remove(idValue);
                super.storeObject(key, prop, "#index");
            }
        }
    }

    public void addLinks(Id id, Collection links) {
        this.bunshinApp.modify(id, links, "OutgoingLinks", true);
        for (Id key : links) {
            this.bunshinApp.modify(key, id, "IncomingLinks", true);
        }
    }

    public void removeLinks(Id id, Collection links) {
        this.bunshinApp.modify(id, links, "OutgoingLinks", false);
        for (Id key : links) {
            this.bunshinApp.modify(key, id, "IncomingLinks", false);
        }
    }

    public void setLinkListener(Id id, RemoteListener listener) {
        this.bunshinApp.setRemoteListener(id, listener, "IncomingLinks");
    }

    public void removeLinkListener(Id id) {
        this.bunshinApp.removeRemoteListener(id, "IncomingLinks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getIncomingLinks(Id key) {
        BunshinGetClient client = new BunshinGetClient("IncomingLinks");
        this.bunshinApp.get(key, client);
        BunshinGetClient bunshinGetClient = client;
        synchronized (bunshinGetClient) {
            for (int timeout = 0; !client.lookupResultArrived && timeout < 30; ++timeout) {
                try {
                    client.wait(100L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        return (Collection)client.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getOutgoingLinks(Id key) {
        BunshinGetClient client = new BunshinGetClient("OutgoingLinks");
        this.bunshinApp.get(key, client);
        BunshinGetClient bunshinGetClient = client;
        synchronized (bunshinGetClient) {
            for (int timeout = 0; !client.lookupResultArrived && timeout < 30; ++timeout) {
                try {
                    client.wait(100L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        return (Collection)client.value;
    }

    private class BunshinGetClient
    implements bunshin.listeners.BunshinGetClient {
        public boolean lookupResultArrived = false;
        public Object value = null;
        public String field;

        public BunshinGetClient(String _field) {
            this.field = _field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void get(Object result) {
            Object object = this.value;
            synchronized (object) {
                if (result != null) {
                    this.value = result;
                    this.value = ((Values)result).get(this.field);
                } else {
                    this.value = null;
                }
                this.lookupResultArrived = true;
            }
        }
    }
}

