/*
 * Decompiled with CFR 0.152.
 */
package bunshin;

import bunshin.Bunshin;
import bunshin.Context;
import bunshin.RemoteListener;
import bunshin.listeners.BunshinGetClient;
import bunshin.listeners.BunshinPutClient;
import bunshin.listeners.BunshinRemoveClient;
import bunshin.listeners.BunshinURLClient;
import bunshin.messaging.BunshinMessage;
import bunshin.messaging.CacheMessage;
import bunshin.messaging.GetMessage;
import bunshin.messaging.GetURLMessage;
import bunshin.messaging.LeaveMessage;
import bunshin.messaging.ListenerMessage;
import bunshin.messaging.ModifyMessage;
import bunshin.messaging.NotifyMessage;
import bunshin.messaging.PutAckMessage;
import bunshin.messaging.PutMessage;
import bunshin.messaging.PutURLMessage;
import bunshin.messaging.RemoveAckMessage;
import bunshin.messaging.RemoveMessage;
import bunshin.messaging.RemoveReplicaMessage;
import bunshin.messaging.ReplicaAckMessage;
import bunshin.messaging.ReplicaMessage;
import bunshin.storage.DiskStorage;
import bunshin.storage.MemStorage;
import bunshin.storage.StorageException;
import bunshin.storage.StorageManager;
import bunshin.storage.XMLStorage;
import bunshin.util.Bucket;
import bunshin.util.Cache;
import bunshin.util.Listeners;
import bunshin.util.Password;
import bunshin.util.PriorityList;
import bunshin.util.ReplicaTable;
import bunshin.util.Utilities;
import bunshin.util.Values;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;

public class BunshinImpl
implements Bunshin,
Application {
    public static ClassLoader extraClassLoader;
    private boolean first = true;
    private int time = 20000;
    private final int MAX_REQUEST_TIME = 30;
    private final int TTL_CACHE = 50;
    private final int MAX_CACHE = 16;
    private int replicationFactor = 1;
    private StorageManager storage;
    private ReplicaTable replicaNHs = new ReplicaTable();
    private Hashtable<NodeHandle, StorageManager> replicaBuckets = new Hashtable();
    private Hashtable<Id, NodeHandle> replicaKeyOwner = new Hashtable();
    private Cache cache = new Cache(50, 16);
    private Hashtable control = new Hashtable();
    private Hashtable urlContext = new Hashtable();
    private Hashtable pathContext = new Hashtable();
    private Hashtable listeners = new Hashtable();
    private Endpoint endPoint = null;
    private PeriodicTask refreshTask = new PeriodicTask();
    private Timer timer = new Timer();
    private boolean debug = false;
    private boolean caching = false;
    public static String applicationId;
    private String appId = applicationId;
    Hashtable put_clients = new Hashtable();
    Hashtable get_clients = new Hashtable();
    Hashtable remove_clients = new Hashtable();
    Hashtable url_clients = new Hashtable();

    public BunshinImpl() {
    }

    public BunshinImpl(String name) {
        this.appId = name;
    }

    public void setId(String name) {
        this.appId = name;
    }

    public String getId() {
        return this.appId;
    }

    public void setRefreshTime(int time) {
        this.time = time;
    }

    public void setEndPoint(Endpoint ep) {
        this.endPoint = ep;
        if (this.first) {
            this.timer.schedule((TimerTask)this.refreshTask, 0L, (long)this.time);
        } else {
            this.first = false;
        }
        this.log("I'm node " + this.endPoint.getLocalNodeHandle().getId());
    }

    public void setStorageManager(StorageManager storage) {
        this.storage = storage;
    }

    public void setInfoContext(String context, String path, String url, URL[] URLsList) {
        if (path != null) {
            this.pathContext.put(context, path);
        }
        if (url != null) {
            this.urlContext.put(context, url);
        }
        if (this.storage instanceof DiskStorage) {
            ((DiskStorage)this.storage).setPath(context, path);
        }
        if (this.storage instanceof XMLStorage) {
            ((XMLStorage)this.storage).setPath(context, path);
        }
        if (URLsList != null) {
            for (int i = 0; i < URLsList.length; ++i) {
                System.out.println(URLsList[i]);
            }
            extraClassLoader = new URLClassLoader(URLsList);
        }
    }

    public void activateDebug() {
        this.debug = true;
        System.out.println("DEBUG ON");
    }

    public void activateCache() {
        this.caching = true;
        System.out.println("CACHE ON");
    }

    public StorageManager getStorageManager() {
        return this.storage;
    }

    private void log(String text) {
        if (this.debug) {
            System.out.println(text);
        }
    }

    public boolean isOwner(Id key) {
        NodeHandleSet set = this.endPoint.replicaSet(key, 1);
        if (set == null) {
            return false;
        }
        Id x = this.endPoint.getId();
        NodeHandle nh = set.getHandle(0);
        if (nh == null) {
            return false;
        }
        return nh.getId().equals(x);
    }

    public void leave() {
        this.timer.cancel();
    }

    public Hashtable getStorageInfo() {
        Hashtable buckets = this.storage.getBuckets();
        Hashtable<String, Hashtable> nodeInfo = new Hashtable<String, Hashtable>();
        for (String context : buckets.keySet()) {
            Bucket bucket = (Bucket)buckets.get(context);
            Hashtable contextInfo = bucket.getMap();
            if (contextInfo.size() <= 0) continue;
            nodeInfo.put(context, contextInfo);
        }
        return nodeInfo;
    }

    public Hashtable getReplicaInfo() {
        Hashtable storageInfo = new Hashtable();
        for (NodeHandle nh : this.replicaBuckets.keySet()) {
            StorageManager replicaNode = this.replicaBuckets.get(nh);
            Hashtable buckets = replicaNode.getBuckets();
            Hashtable<String, Hashtable> nodeInfo = new Hashtable<String, Hashtable>();
            for (String context : buckets.keySet()) {
                Bucket bucket = (Bucket)buckets.get(context);
                Hashtable contextInfo = bucket.getMap();
                if (contextInfo.size() <= 0) continue;
                nodeInfo.put(context, contextInfo);
            }
            if (nodeInfo.size() <= 0) continue;
            storageInfo.put(nh, nodeInfo);
        }
        return storageInfo;
    }

    public void setReplicationFactor(int replicas) {
        this.replicationFactor = replicas;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    private void checkMyKeys() {
        Hashtable buckets = this.storage.getBuckets();
        for (String context : buckets.keySet()) {
            Bucket store = this.storage.getBucket(context);
            Vector v = new Vector(store.keySet());
            for (int i = 0; i < v.size(); ++i) {
                Id key = (Id)v.get(i);
                if (this.isOwner(key)) continue;
                this.undoReplica(context, key);
                Values obj = this.storage.extract(context, key);
                Password pwd = null;
                if (obj instanceof Values) {
                    Values values = obj;
                    String field = (String)values.get("#field");
                    pwd = (Password)values.get("Password");
                    if (field != null) {
                        this.putSecure(context, key, (Object)values, field, pwd, (BunshinPutClient)new BunshinAutoPutClient(context, key));
                        continue;
                    }
                    this.putSecure(context, key, (Object)values, Context.DEFAULT_FIELD, pwd, (BunshinPutClient)new BunshinAutoPutClient(context, key));
                    continue;
                }
                this.putSecure(context, key, (Object)obj, Context.DEFAULT_FIELD, pwd, (BunshinPutClient)new BunshinAutoPutClient(context, key));
            }
        }
    }

    private Collection remFailNH(Collection c) {
        NodeHandle localNH = this.endPoint.getLocalNodeHandle();
        Vector<NodeHandle> c2 = new Vector<NodeHandle>();
        for (NodeHandle nh : c) {
            if (!nh.isAlive() && !nh.equals(localNH)) continue;
            c2.add(nh);
        }
        return c2;
    }

    private void addReplica(String context, Id key, Collection c, int tries) {
        NodeHandle nh;
        NodeHandle localNH = this.endPoint.getLocalNodeHandle();
        Values values = this.storage.extract(context, key);
        Collection v = Utilities.convert(this.endPoint.replicaSet(key, c.size() + tries + 1));
        v.remove(localNH);
        v.removeAll(c);
        Iterator it = v.iterator();
        if (it.hasNext() && (nh = (NodeHandle)it.next()) != null && !nh.equals(localNH)) {
            ReplicaMessage msg = new ReplicaMessage(key, values, localNH);
            msg.setContext(context);
            this.endPoint.route(null, (Message)msg, nh);
        }
    }

    private void checkMyRemoteReplicas() {
        Hashtable buckets = this.storage.getBuckets();
        for (String context : buckets.keySet()) {
            Bucket store = this.storage.getBucket(context);
            Vector v = new Vector(store.keySet());
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                HashSet nhs1;
                Collection nhs2;
                int tries;
                Id key = (Id)v.get(i);
                HashSet nhs = this.replicaNHs.get(context, key);
                nhs = nhs == null ? new HashSet() : new HashSet(nhs);
                this.replicaNHs.put(context, key, nhs);
                if (nhs == null || (tries = this.replicationFactor - (nhs2 = this.remFailNH((Collection)(nhs1 = new HashSet(nhs)).clone())).size()) <= 0) continue;
                this.addReplica(context, key, nhs2, tries);
            }
        }
    }

    private void checkReplicas() {
        Vector<NodeHandle> v = new Vector<NodeHandle>(this.replicaBuckets.keySet());
        for (int i = 0; i < v.size(); ++i) {
            StorageManager replicas;
            NodeHandle nh = v.get(i);
            if (nh.isAlive() || (replicas = this.replicaBuckets.remove(nh)) == null) continue;
            Hashtable buckets = replicas.getBuckets();
            for (String context : buckets.keySet()) {
                Bucket bucket = replicas.getBucket(context);
                if (bucket == null) continue;
                Vector c = new Vector(bucket.keySet());
                while (!c.isEmpty()) {
                    try {
                        Id key = (Id)c.firstElement();
                        Object obj = replicas.remove(context, key);
                        c.remove(key);
                        this.replicaKeyOwner.remove(key);
                        Password pwd = null;
                        boolean getcheck = true;
                        if (obj instanceof Values) {
                            Values values = (Values)obj;
                            String field = (String)values.get("#field");
                            pwd = (Password)values.get("Password");
                            if (field != null) {
                                this.putSecure(context, key, (Object)values, field, pwd);
                                continue;
                            }
                            this.putSecure(context, key, obj, Context.DEFAULT_FIELD, pwd);
                            continue;
                        }
                        if (obj == null) continue;
                        this.putSecure(context, key, obj, Context.DEFAULT_FIELD, pwd);
                    }
                    catch (StorageException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public void update(NodeHandle handle, boolean joined) {
        if (joined) {
            this.refresh(1);
        } else {
            this.refresh(2);
        }
    }

    public boolean forward(RouteMessage message) {
        GetMessage gmsg;
        boolean forward = true;
        BunshinMessage msg = (BunshinMessage)message.getMessage();
        String context = msg.getContext();
        if (this.caching && msg instanceof GetMessage && (gmsg = (GetMessage)msg).getPhase() == 1) {
            GetMessage fmsg;
            boolean validate;
            Password oldPwd;
            Values values;
            Password pwd;
            Id key = gmsg.getKey();
            String field = gmsg.getField();
            Object value = null;
            boolean haveValue = false;
            if (this.isOwner(key)) {
                value = field != null ? this.storage.retrieve(context, key, field) : this.storage.extract(context, key);
                if (value != null) {
                    haveValue = true;
                }
            } else if (this.replicaKeyOwner.containsKey(key)) {
                pwd = gmsg.getPassword();
                values = this.getReplicaValue(context, key);
                if (values != null) {
                    oldPwd = (Password)values.get("Password");
                    boolean bl = validate = oldPwd == null || pwd != null && oldPwd.equals(pwd);
                    if (validate) {
                        value = field != null ? values.get(field) : values;
                    }
                }
                fmsg = new GetMessage(key, value);
                fmsg.setContext(context);
                this.endPoint.route(null, (Message)fmsg, gmsg.getNH());
                forward = false;
                haveValue = true;
                this.log("Replica response " + key);
            } else if (this.cache.contains(context, key)) {
                pwd = gmsg.getPassword();
                values = this.cache.get(context, key);
                if (values != null) {
                    oldPwd = (Password)values.get("Password");
                    boolean bl = validate = oldPwd == null || pwd != null && oldPwd.equals(pwd);
                    if (validate) {
                        value = field != null ? values.get(field) : values;
                    }
                }
                fmsg = new GetMessage(key, value);
                fmsg.setContext(context);
                this.endPoint.route(null, (Message)fmsg, gmsg.getNH());
                forward = false;
                haveValue = true;
                this.log("Cache response " + key);
            }
            if (haveValue) {
                PriorityList list;
                NodeHandle previous = gmsg.getPreviousNH();
                Id obj_key = gmsg.getKey();
                Hashtable<Id, PriorityList> pairs = (Hashtable<Id, PriorityList>)this.control.get(context);
                if (pairs == null) {
                    pairs = new Hashtable<Id, PriorityList>();
                }
                if ((list = (PriorityList)pairs.get(obj_key)) == null) {
                    list = new PriorityList();
                }
                list.update(previous);
                pairs.put(obj_key, list);
                this.control.put(context, pairs);
                this.log("Request updated from " + previous.getId() + " key " + obj_key);
            }
            gmsg.setPreviousNH(this.endPoint.getLocalNodeHandle());
        }
        return forward;
    }

    public void deliver(Id id, Message message) {
        BunshinMessage bm = (BunshinMessage)message;
        String context2 = bm.getContext();
        this.log("Deliver app [" + this.appId + "] node [" + this.endPoint.getId() + "] \nmessage : " + message);
        if (message instanceof PutMessage) {
            PutMessage mesg = (PutMessage)message;
            Id key = mesg.getKey();
            Object value = mesg.getValue();
            String field = mesg.getField();
            try {
                Password pwd = mesg.getPassword();
                Password oldPwd = (Password)this.storage.retrieve(context2, key, "Password");
                boolean validate = oldPwd == null || pwd != null && oldPwd.equals(pwd);
                boolean addVersion = false;
                if (value instanceof Values) {
                    validate &= this.CVS(value, this.storage.extract(context2, key));
                } else {
                    addVersion = true;
                }
                System.out.println("PUT REQUEST :" + key);
                if (validate) {
                    Values oldValues;
                    this.storage.write(context2, key, value, field);
                    this.remoteListeners(context2, key, value, field, true);
                    if (addVersion && (oldValues = this.storage.extract(context2, key)).containsKey("CVS")) {
                        int oldVersion = (Integer)oldValues.get("CVS");
                        this.storage.write(context2, key, new Integer(oldVersion + 1), "CVS");
                    }
                    if (oldPwd == null && pwd != null) {
                        this.storage.write(context2, key, pwd, "Password");
                    }
                    Values values = this.storage.extract(context2, key);
                    this.replicate(context2, key, values);
                    this.log("I'm the owner of the " + value);
                } else {
                    this.log("Wrong validation of put key : " + key);
                }
                Vector<NodeHandle> c = this.replicaNHs.get(context2, key);
                if (c == null) {
                    c = new Vector<NodeHandle>();
                }
                c.add(mesg.getNH());
                this.replicaNHs.put(context2, key, c);
                PutAckMessage msg = new PutAckMessage(key, field, validate, this.endPoint.getLocalNodeHandle());
                msg.setContext(context2);
                this.endPoint.route(null, (Message)msg, mesg.getNH());
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else if (message instanceof PutAckMessage) {
            Vector id_clients;
            PutAckMessage mesg = (PutAckMessage)message;
            Id key = mesg.getKey();
            String field = mesg.getField();
            boolean successful = mesg.getSuccessful();
            if (this.put_clients != null && (id_clients = (Vector)this.put_clients.remove(key)) != null) {
                for (int i = 0; i < id_clients.size(); ++i) {
                    BunshinPutClient client = (BunshinPutClient)id_clients.get(i);
                    client.put(successful, mesg.getSource());
                }
            }
        } else if (message instanceof PutURLMessage) {
            PutURLMessage mesg = (PutURLMessage)message;
            Id key = mesg.getKey();
            URL url = mesg.getURL();
            String field = mesg.getField();
            Values values = this.storage.extract(context2, key);
            if (values == null) {
                values = new Values();
            }
            this.replicateURL(context2, key, values, url, field);
            Object file = this.download(url);
            if (file != null) {
                try {
                    String filename = url.getFile();
                    filename = filename.substring(filename.lastIndexOf(47) + 1);
                    values.put("#filename", filename);
                    values.put(field, file);
                    this.storage.write(context2, key, values, field);
                    this.log("I'm the owner of the url value : " + url);
                }
                catch (StorageException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (message instanceof ModifyMessage) {
            ModifyMessage mesg = (ModifyMessage)message;
            Id key = mesg.getKey();
            Collection value = (Collection)mesg.getValue();
            String field = mesg.getField();
            try {
                Collection c = null;
                this.undoReplica(context2, key);
                if (mesg.isAdd()) {
                    c = (Vector)this.storage.retrieve(context2, key, field);
                    if (c == null) {
                        c = new Vector();
                    }
                    c.addAll(value);
                    this.storage.write(context2, key, c, field);
                    this.remoteListeners(context2, key, value, field, true);
                } else {
                    c = (Collection)this.storage.retrieve(context2, key, field);
                    if (c == null) {
                        c = new Vector();
                    } else {
                        c.removeAll(value);
                    }
                    this.storage.write(context2, key, c, field);
                    this.remoteListeners(context2, key, value, field, false);
                }
                Values values = this.storage.extract(context2, key);
                this.replicate(context2, key, values);
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else if (message instanceof ListenerMessage) {
            try {
                ListenerMessage mesg = (ListenerMessage)message;
                Id key = mesg.getKey();
                String field = mesg.getField();
                this.undoReplica(context2, key);
                Listeners ls = (Listeners)this.storage.retrieve(context2, key, "Listeners");
                if (mesg.isAdd()) {
                    if (ls == null) {
                        ls = new Listeners();
                    }
                    ls.add(mesg.getNH(), mesg.getField());
                } else if (ls != null) {
                    ls.remove(mesg.getNH(), mesg.getField());
                } else {
                    ls = new Listeners();
                }
                this.storage.write(context2, key, ls, "Listeners");
                Values values = this.storage.extract(context2, key);
                this.replicate(context2, key, values);
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else if (message instanceof NotifyMessage) {
            NotifyMessage mesg = (NotifyMessage)message;
            Id key = mesg.getKey();
            Object value = mesg.getValue();
            RemoteListener rl = (RemoteListener)this.listeners.get(key);
            if (rl != null) {
                rl.eventArrived(value, mesg.isAdd());
            }
        } else if (message instanceof RemoveMessage) {
            RemoveMessage mesg = (RemoveMessage)message;
            Id key = mesg.getKey();
            String field = mesg.getField();
            try {
                boolean validate;
                Password pwd = mesg.getPassword();
                Password oldPwd = (Password)this.storage.retrieve(context2, key, "Password");
                boolean bl = validate = oldPwd == null || pwd != null && oldPwd.equals(pwd);
                if (validate) {
                    this.undoReplica(context2, key);
                    this.log("Removing " + key);
                    if (field != null) {
                        Object value = this.storage.retrieve(context2, key, field);
                        this.remoteListeners(context2, key, value, field, false);
                        this.storage.delete(context2, key, field);
                        Values values = this.storage.extract(context2, key);
                        if (values != null && (values != null && values.size() == 2 && values.containsKey("CVS") && values.containsKey("Password") || values.size() == 1 && (values.containsKey("CVS") || values.containsKey("Password")) || values.size() == 0)) {
                            this.storage.remove(context2, key);
                        }
                    } else {
                        this.storage.remove(context2, mesg.getKey());
                    }
                }
                RemoveAckMessage msg = new RemoveAckMessage(key, field, validate);
                msg.setContext(context2);
                this.endPoint.route(null, (Message)msg, mesg.getNH());
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else if (message instanceof RemoveAckMessage) {
            Vector id_clients;
            RemoveAckMessage mesg = (RemoveAckMessage)message;
            Id key = mesg.getKey();
            String field = mesg.getField();
            boolean successful = mesg.getSuccessful();
            if (this.remove_clients != null && (id_clients = (Vector)this.remove_clients.remove(key)) != null) {
                for (int i = 0; i < id_clients.size(); ++i) {
                    BunshinRemoveClient client = (BunshinRemoveClient)id_clients.get(i);
                    client.remove(successful);
                }
            }
        } else if (message instanceof RemoveReplicaMessage) {
            RemoveReplicaMessage mesg = (RemoveReplicaMessage)message;
            NodeHandle owner = this.replicaKeyOwner.remove(mesg.getKey());
            if (owner != null && this.replicaBuckets.containsKey(owner)) {
                StorageManager replicaStorage = this.replicaBuckets.remove(owner);
                Bucket replicas = replicaStorage.getBucket(context2);
                this.log("Replicas " + replicas);
                if (replicas != null) {
                    try {
                        replicas.remove(mesg.getKey());
                        if (replicas.size() > 0) {
                            replicaStorage.put(context2, replicas);
                        } else {
                            replicaStorage.removeBucket(context2);
                        }
                        this.replicaBuckets.put(mesg.getNH(), replicaStorage);
                        this.log("Replicas Final " + this.replicaBuckets);
                    }
                    catch (StorageException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        } else if (message instanceof GetMessage) {
            GetMessage mesg = (GetMessage)message;
            int phase = mesg.getPhase();
            switch (phase) {
                case 1: {
                    Id key = mesg.getKey();
                    String field = mesg.getField();
                    Object value = null;
                    Password pwd = mesg.getPassword();
                    Password oldPwd = (Password)this.storage.retrieve(context2, key, "Password");
                    boolean validate = true;
                    if (oldPwd != null) {
                        System.out.println("Getcheck key " + key + ": " + oldPwd.isGetCheck());
                        validate = oldPwd.isGetCheck() ? pwd != null && oldPwd.equals(pwd) : true;
                    }
                    if (validate) {
                        value = field != null ? this.storage.retrieve(context2, key, field) : this.storage.extract(context2, key);
                    } else {
                        this.log("Wrong validation of get key : " + key);
                    }
                    GetMessage msg = new GetMessage(key, value);
                    msg.setContext(context2);
                    this.endPoint.route(null, (Message)msg, mesg.getNH());
                    break;
                }
                case 2: {
                    Vector id_clients;
                    Id key = mesg.getKey();
                    Object value = mesg.getValue();
                    if (this.get_clients == null || (id_clients = (Vector)this.get_clients.remove(key)) == null) break;
                    for (int i = 0; i < id_clients.size(); ++i) {
                        BunshinGetClient client = (BunshinGetClient)id_clients.get(i);
                        client.get(value);
                    }
                    break;
                }
            }
        } else if (message instanceof GetURLMessage) {
            GetURLMessage mesg = (GetURLMessage)message;
            int phase = mesg.getPhase();
            switch (phase) {
                case 1: {
                    String filename;
                    Id key = mesg.getKey();
                    String field = mesg.getField();
                    URL url = null;
                    Values values = this.storage.extract(context2, key);
                    String f = (String)values.get("#field");
                    if (f != null && f.equals(field) && (filename = (String)values.get("#filename")) != null) {
                        String url_base = (String)this.urlContext.get(context2);
                        try {
                            url = new URL(url_base + '/' + filename);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    GetURLMessage msg = new GetURLMessage(key, url);
                    msg.setContext(context2);
                    this.endPoint.route(null, (Message)msg, mesg.getNH());
                    break;
                }
                case 2: {
                    Vector id_clients;
                    Id key = mesg.getKey();
                    URL url_value = mesg.getURL();
                    if (this.url_clients == null || (id_clients = (Vector)this.url_clients.remove(key)) == null) break;
                    for (int i = 0; i < id_clients.size(); ++i) {
                        BunshinURLClient client = (BunshinURLClient)id_clients.get(i);
                        client.get(url_value);
                    }
                    break;
                }
            }
        } else if (message instanceof ReplicaMessage) {
            ReplicaMessage mesg = (ReplicaMessage)message;
            Id key = mesg.getKey();
            Values values = mesg.getValues();
            if (mesg.isURLReplica()) {
                Object value = this.download(mesg.getURL());
                values.put(mesg.getField(), value);
                String filename = mesg.getURL().getFile();
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                values.put(filename, "filename");
            }
            if (!this.storage.exists(context2, key)) {
                this.putReplica(mesg.getNH(), context2, key, values);
                ReplicaAckMessage msg = new ReplicaAckMessage(key, this.endPoint.getLocalNodeHandle());
                msg.setContext(context2);
                this.endPoint.route(null, (Message)msg, mesg.getNH());
                System.out.println("REPLICA REQUEST :" + key);
                this.log("Saving replica in context" + context2 + " values : " + values + " of " + mesg.getNH().getId());
            }
        } else if (message instanceof ReplicaAckMessage) {
            ReplicaAckMessage mesg = (ReplicaAckMessage)message;
            Id key = mesg.getKey();
            Vector<NodeHandle> c = this.replicaNHs.get(context2, key);
            if (c == null) {
                c = new Vector<NodeHandle>();
            }
            c.add(mesg.getNH());
            this.replicaNHs.put(context2, key, c);
            this.log("Replica ack " + key + " of " + mesg.getNH().getId());
        } else if (message instanceof LeaveMessage) {
            Hashtable buckets;
            StorageManager replicas;
            LeaveMessage mesg = (LeaveMessage)message;
            NodeHandle source = mesg.getNH();
            if (mesg.isContent()) {
                Hashtable newBuckets = (Hashtable)mesg.getContent();
                for (String context2 : newBuckets.keySet()) {
                    Bucket newKeys = (Bucket)newBuckets.get(context2);
                    if (newKeys.size() <= 0) continue;
                    try {
                        this.storage.add(context2, newKeys);
                        this.log("New keys received : " + newKeys);
                    }
                    catch (StorageException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if ((replicas = this.replicaBuckets.remove(mesg.getNH())) != null && (buckets = replicas.getBuckets()) != null) {
                for (Bucket bucket : buckets.values()) {
                    for (Id k : bucket.keySet()) {
                        NodeHandle owner = this.replicaKeyOwner.get(k);
                        if (owner == null || !owner.equals(mesg.getNH())) continue;
                        this.replicaKeyOwner.remove(k);
                    }
                }
            }
        } else if (message instanceof CacheMessage) {
            if (this.caching) {
                CacheMessage mesg = (CacheMessage)message;
                Id key = mesg.getKey();
                Values values = mesg.getValues();
                if (values != null) {
                    this.cache.put(context2, key, values);
                }
                this.log("Cacheando key " + key);
            }
        } else {
            this.log("Deliver Error : Wrong message : " + message);
        }
    }

    public void put(Id key, Object value) {
        this.put(Context.DEFAULT_CONTEXT, key, value, Context.DEFAULT_FIELD);
    }

    public void put(Id key, Object value, String field) {
        this.put(Context.DEFAULT_CONTEXT, key, value, field);
    }

    public void put(String context, Id key, Object value) {
        this.put(context, key, value, Context.DEFAULT_FIELD);
    }

    public void put(String context, Id key, Object value, String field) {
        Password pwd = null;
        this.putSecure(context, key, value, field, pwd);
    }

    public void putSecure(String context, Id key, Object value, String field, String pass) {
        Password pwd = null;
        if (pass != null) {
            pwd = new Password(pass);
        }
        this.putSecure(context, key, value, field, pwd);
    }

    public void putSecure(String context, Id key, Object value, String field, String pass, boolean getcheck) {
        Password pwd = null;
        if (pass != null) {
            pwd = new Password(pass, getcheck);
        }
        this.putSecure(context, key, value, field, pwd);
    }

    private void putSecure(String context, Id key, Object value, String field, Password pwd) {
        block11: {
            if (this.isOwner(key)) {
                try {
                    Password oldPwd = (Password)this.storage.retrieve(context, key, "Password");
                    boolean validate = oldPwd == null || pwd != null && oldPwd.equals(pwd);
                    boolean addVersion = false;
                    if (value instanceof Values) {
                        validate &= this.CVS(value, this.storage.extract(context, key));
                    } else {
                        addVersion = true;
                    }
                    if (validate) {
                        Values oldValues;
                        this.storage.write(context, key, value, field);
                        this.remoteListeners(context, key, value, field, true);
                        if (addVersion && (oldValues = this.storage.extract(context, key)).containsKey("CVS")) {
                            int oldVersion = (Integer)oldValues.get("CVS");
                            this.storage.write(context, key, new Integer(oldVersion + 1), "CVS");
                        }
                        if (oldPwd == null && pwd != null) {
                            this.storage.write(context, key, pwd, "Password");
                        }
                        Values values = this.storage.extract(context, key);
                        this.replicate(context, key, values);
                        this.log("I'm the owner of the " + value);
                        Vector id_clients = (Vector)this.put_clients.remove(key);
                        if (id_clients != null) {
                            for (int i = 0; i < id_clients.size(); ++i) {
                                BunshinPutClient client = (BunshinPutClient)id_clients.get(i);
                                client.put(true, this.endPoint.getLocalNodeHandle());
                            }
                        }
                        break block11;
                    }
                    this.log("Wrong validation of put key : " + key);
                }
                catch (StorageException ex) {
                    ex.printStackTrace();
                }
            } else {
                PutMessage msg = new PutMessage(key, value, field, pwd, this.endPoint.getLocalNodeHandle());
                msg.setContext(context);
                this.endPoint.route(key, (Message)msg, null);
            }
        }
    }

    public void put(Id key, Object value, BunshinPutClient client) {
        Vector id_clients = !this.put_clients.containsKey(key) ? new Vector() : (Vector)this.put_clients.get(key);
        id_clients.add(client);
        this.put_clients.put(key, id_clients);
        this.put(Context.DEFAULT_CONTEXT, key, value, Context.DEFAULT_FIELD);
    }

    public void put(String context, Id key, Object value, BunshinPutClient client) {
        Vector id_clients = !this.put_clients.containsKey(key) ? new Vector() : (Vector)this.put_clients.get(key);
        id_clients.add(client);
        this.put_clients.put(key, id_clients);
        this.put(context, key, value, Context.DEFAULT_FIELD);
    }

    public void put(Id key, Object value, String field, BunshinPutClient client) {
        Vector id_clients = !this.put_clients.containsKey(key) ? new Vector() : (Vector)this.put_clients.get(key);
        id_clients.add(client);
        this.put_clients.put(key, id_clients);
        this.put(Context.DEFAULT_CONTEXT, key, value, field);
    }

    public void put(String context, Id key, Object value, String field, BunshinPutClient client) {
        Vector id_clients = !this.put_clients.containsKey(key) ? new Vector() : (Vector)this.put_clients.get(key);
        id_clients.add(client);
        this.put_clients.put(key, id_clients);
        this.put(context, key, value, field);
    }

    public void putSecure(String context, Id key, Object value, String field, String pass, BunshinPutClient client) {
        Vector id_clients = !this.put_clients.containsKey(key) ? new Vector() : (Vector)this.put_clients.get(key);
        id_clients.add(client);
        this.put_clients.put(key, id_clients);
        this.putSecure(context, key, value, field, pass, true);
    }

    public void putSecure(String context, Id key, Object value, String field, String pass, boolean getcheck, BunshinPutClient client) {
        Vector id_clients = !this.put_clients.containsKey(key) ? new Vector() : (Vector)this.put_clients.get(key);
        id_clients.add(client);
        this.put_clients.put(key, id_clients);
        this.putSecure(context, key, value, field, pass, getcheck);
    }

    private void putSecure(String context, Id key, Object value, String field, Password pwd, BunshinPutClient client) {
        Vector id_clients = !this.put_clients.containsKey(key) ? new Vector() : (Vector)this.put_clients.get(key);
        id_clients.add(client);
        this.put_clients.put(key, id_clients);
        this.putSecure(context, key, value, field, pwd);
    }

    public void putURL(Id key, URL url, String field) {
        this.putURL(Context.DEFAULT_CONTEXT, key, url, field);
    }

    public void putURL(String context, Id key, URL url, String field) {
        if (this.isOwner(key)) {
            try {
                Object file;
                Values values = this.storage.extract(context, key);
                if (values == null) {
                    values = new Values();
                }
                if ((file = this.download(url)) != null) {
                    String filename = url.getFile();
                    filename = filename.substring(filename.lastIndexOf(47) + 1);
                    values.put("#filename", filename);
                    values.put(field, file);
                    this.storage.write(context, key, values, field);
                    this.remoteListeners(context, key, url, field, true);
                    this.log("I'm the owner of the url value : " + url);
                }
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else {
            PutURLMessage msg = new PutURLMessage(key, url, field);
            msg.setContext(context);
            this.endPoint.route(key, (Message)msg, null);
        }
    }

    private Object download(URL url) {
        byte[] bite = null;
        try {
            int offset;
            InputStream in;
            int contentLength;
            String contentType;
            String protocol = url.getProtocol();
            System.out.println("URL protocol : " + protocol);
            if (protocol.equals("file")) {
                File file = new File(url.getFile());
                contentType = "file";
                contentLength = (int)file.length();
                in = new FileInputStream(file);
            } else {
                URLConnection uc = url.openConnection();
                contentType = uc.getContentType();
                contentLength = uc.getContentLength();
                InputStream raw = uc.getInputStream();
                in = new BufferedInputStream(raw);
            }
            bite = new byte[contentLength];
            int bytesRead = 0;
            for (offset = 0; offset < contentLength && (bytesRead = in.read(bite, offset, bite.length - offset)) != -1; offset += bytesRead) {
            }
            in.close();
            if (offset != contentLength) {
                throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bite;
    }

    public void modify(Id key, Object value, String field, boolean add) {
        this.modify(Context.DEFAULT_CONTEXT, key, value, field, add);
    }

    public void modify(String context, Id key, Object value, String field, boolean add) {
        if (this.isOwner(key)) {
            try {
                Collection<Object> c = null;
                this.undoReplica(context, key);
                if (add) {
                    c = (Vector<Object>)this.storage.retrieve(context, key, field);
                    if (c == null) {
                        c = new Vector<Object>();
                    }
                    c.add(value);
                    this.storage.write(context, key, c, field);
                    this.remoteListeners(context, key, value, field, true);
                } else {
                    c = (Collection)this.storage.retrieve(context, key, field);
                    if (c == null) {
                        c = new Vector();
                    } else {
                        c.remove(value);
                    }
                    this.storage.write(context, key, c, field);
                    this.remoteListeners(context, key, value, field, false);
                }
                Values values = this.storage.extract(context, key);
                this.replicate(context, key, values);
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else {
            Vector<Object> values = new Vector<Object>();
            values.add(value);
            ModifyMessage msg = new ModifyMessage(key, values, field, add);
            msg.setContext(context);
            this.endPoint.route(key, (Message)msg, null);
        }
    }

    public void modify(Id key, Collection list, String field, boolean add) {
        this.modify(Context.DEFAULT_CONTEXT, key, list, field, add);
    }

    public void modify(String context, Id key, Collection list, String field, boolean add) {
        if (this.isOwner(key)) {
            try {
                Collection c = null;
                this.undoReplica(context, key);
                if (add) {
                    c = (Vector)this.storage.retrieve(context, key, field);
                    if (c == null) {
                        c = new Vector();
                    }
                    c.addAll(list);
                    this.storage.write(context, key, c, field);
                    this.remoteListeners(context, key, list, field, true);
                } else {
                    c = (Collection)this.storage.retrieve(context, key, field);
                    if (c == null) {
                        c = new Vector();
                    } else {
                        c.removeAll(list);
                    }
                    this.storage.write(context, key, c, field);
                    this.remoteListeners(context, key, list, field, false);
                }
                Values values = this.storage.extract(context, key);
                this.replicate(context, key, values);
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else {
            ModifyMessage msg = new ModifyMessage(key, list, field, add);
            msg.setContext(context);
            this.endPoint.route(key, (Message)msg, null);
        }
    }

    public void get(Id key, BunshinGetClient client) {
        this.get(Context.DEFAULT_CONTEXT, key, Context.DEFAULT_FIELD, client);
    }

    public void get(String context, Id key, BunshinGetClient client) {
        this.get(context, key, Context.DEFAULT_FIELD, client);
    }

    public void get(Id key, String field, BunshinGetClient client) {
        this.get(Context.DEFAULT_CONTEXT, key, field, client);
    }

    public void get(String context, Id key, String field, BunshinGetClient client) {
        this.getSecure(context, key, field, null, client);
    }

    public void getSecure(String context, Id key, String field, String pass, BunshinGetClient client) {
        Values value = null;
        Values values = null;
        boolean found = false;
        Password pwd = null;
        if (pass != null) {
            pwd = new Password(pass);
        }
        if (this.isOwner(key)) {
            values = this.storage.extract(context, key);
            if (values != null) {
                found = true;
            }
        } else if (this.replicaKeyOwner.containsKey(key)) {
            values = this.getReplicaValue(context, key);
            if (values != null) {
                found = true;
            }
        } else if (this.cache.contains(context, key) && (values = this.cache.get(context, key)) != null) {
            found = true;
        }
        if (found) {
            Password oldPwd = (Password)values.get("Password");
            value = field != null && values != null ? values.get(field) : values;
            boolean validate = true;
            if (oldPwd != null) {
                System.out.println("Getcheck key " + key + ": " + oldPwd.isGetCheck());
                validate = oldPwd.isGetCheck() ? pwd != null && oldPwd.equals(pwd) : true;
            }
            if (validate) {
                client.get(value);
            } else {
                client.get(null);
            }
        } else {
            Vector id_clients = !this.get_clients.containsKey(key) ? new Vector() : (Vector)this.get_clients.get(key);
            id_clients.add(client);
            this.get_clients.put(key, id_clients);
            GetMessage msg = new GetMessage(key, field, pwd, this.endPoint.getLocalNodeHandle());
            msg.setContext(context);
            this.endPoint.route(key, (Message)msg, null);
        }
    }

    public Object getLocal(Id key) {
        return this.getLocal(Context.DEFAULT_CONTEXT, key, Context.DEFAULT_FIELD);
    }

    public Object getLocal(Id key, String field) {
        return this.getLocal(Context.DEFAULT_CONTEXT, key, field);
    }

    public Object getLocal(String context, Id key) {
        return this.getLocal(context, key, Context.DEFAULT_FIELD);
    }

    public Object getLocal(String context, Id key, String field) {
        return this.getLocalSecure(context, key, field, null);
    }

    public Object getLocalSecure(String context, Id key, String field, String pass) {
        Values value = null;
        Values values = null;
        boolean found = false;
        Password pwd = null;
        if (pass != null) {
            pwd = new Password(pass);
        }
        if (this.isOwner(key)) {
            values = this.storage.extract(context, key);
            if (values != null) {
                found = true;
            }
        } else if (this.replicaKeyOwner.containsKey(key)) {
            values = this.getReplicaValue(context, key);
            if (values != null) {
                found = true;
            }
        } else if (this.cache.contains(context, key) && (values = this.cache.get(context, key)) != null) {
            found = true;
        }
        if (found) {
            Password oldPwd = (Password)values.get("Password");
            value = field != null && values != null ? values.get(field) : values;
            boolean validate = true;
            if (oldPwd != null) {
                System.out.println("Getcheck key " + key + ": " + oldPwd.isGetCheck());
                validate = oldPwd.isGetCheck() ? pwd != null && oldPwd.equals(pwd) : true;
            }
            if (validate) {
                return value;
            }
            return null;
        }
        return null;
    }

    public void getURL(Id key, String field, BunshinURLClient client) {
        this.getURL(Context.DEFAULT_CONTEXT, key, field, client);
    }

    public void getURL(String context, Id key, String field, BunshinURLClient client) {
        if (this.isOwner(key)) {
            URL url = null;
            Values values = this.storage.extract(context, key);
            String f = (String)values.get("#field");
            if (f != null && f.equals(field)) {
                String filename = (String)values.get("#filename");
                if (filename != null) {
                    String url_base = (String)this.urlContext.get(context);
                    try {
                        url = new URL(url_base + '/' + filename);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    client.get(url);
                } else {
                    client.get(null);
                }
            } else {
                client.get(null);
            }
        } else {
            Vector id_clients = !this.url_clients.containsKey(key) ? new Vector() : (Vector)this.url_clients.get(key);
            id_clients.add(client);
            this.url_clients.put(key, id_clients);
            GetURLMessage msg = new GetURLMessage(key, field, this.endPoint.getLocalNodeHandle());
            msg.setContext(context);
            this.endPoint.route(key, (Message)msg, null);
        }
    }

    public void remove(Id key) {
        this.remove(Context.DEFAULT_CONTEXT, key, Context.DEFAULT_FIELD);
    }

    public void remove(Id key, String field) {
        this.remove(Context.DEFAULT_CONTEXT, key, field);
    }

    public void remove(String context, Id key) {
        this.remove(context, key, Context.DEFAULT_FIELD);
    }

    public void remove(String context, Id key, String field) {
        this.removeSecure(context, key, field, null);
    }

    public void removeSecure(String context, Id key, String field, String pass) {
        block9: {
            Password pwd = null;
            if (pass != null) {
                pwd = new Password(pass);
            }
            if (this.isOwner(key)) {
                try {
                    boolean validate;
                    Password oldPwd = (Password)this.storage.retrieve(context, key, "Password");
                    boolean bl = validate = oldPwd == null || pwd != null && oldPwd.equals(pwd);
                    if (validate) {
                        this.undoReplica(context, key);
                        this.log("Removing " + key);
                        if (field != null) {
                            Object value = this.storage.retrieve(context, key, field);
                            this.remoteListeners(context, key, value, field, false);
                            this.storage.delete(context, key, field);
                            Values values = this.storage.extract(context, key);
                            if (values != null && (values != null && values.size() == 2 && values.containsKey("CVS") && values.containsKey("Password") || values.size() == 1 && (values.containsKey("CVS") || values.containsKey("Password")) || values.size() == 0)) {
                                this.storage.remove(context, key);
                            }
                        } else {
                            this.storage.remove(context, key);
                        }
                        break block9;
                    }
                    this.log("Wrong validation of remove key : " + key);
                }
                catch (StorageException ex) {
                    ex.printStackTrace();
                }
            } else {
                RemoveMessage msg = new RemoveMessage(key, field, pwd, this.endPoint.getLocalNodeHandle());
                msg.setContext(context);
                this.endPoint.route(key, (Message)msg, null);
            }
        }
    }

    public void remove(Id key, BunshinRemoveClient client) {
        this.remove(Context.DEFAULT_CONTEXT, key, Context.DEFAULT_FIELD, client);
    }

    public void remove(Id key, String field, BunshinRemoveClient client) {
        this.remove(Context.DEFAULT_CONTEXT, key, field, client);
    }

    public void remove(String context, Id key, BunshinRemoveClient client) {
        this.remove(context, key, Context.DEFAULT_FIELD, client);
    }

    public void remove(String context, Id key, String field, BunshinRemoveClient client) {
        this.removeSecure(context, key, field, null, client);
    }

    public void removeSecure(String context, Id key, String field, String pass, BunshinRemoveClient client) {
        Vector id_clients = !this.remove_clients.containsKey(key) ? new Vector() : (Vector)this.remove_clients.get(key);
        id_clients.add(client);
        this.remove_clients.put(key, id_clients);
        this.removeSecure(context, key, field, pass);
    }

    public void setRemoteListener(Id id, RemoteListener listener, String field) {
        this.setRemoteListener(Context.DEFAULT_CONTEXT, id, listener, field);
    }

    public void setRemoteListener(String context, Id id, RemoteListener listener, String field) {
        this.listeners.put(id, listener);
        if (this.isOwner(id)) {
            try {
                this.undoReplica(context, id);
                Listeners ls = (Listeners)this.storage.retrieve(context, id, "Listeners");
                if (ls == null) {
                    ls = new Listeners();
                }
                ls.add(this.endPoint.getLocalNodeHandle(), field);
                this.storage.write(context, id, ls, "Listeners");
                Values values = this.storage.extract(context, id);
                this.replicate(context, id, values);
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else {
            ListenerMessage mesg = new ListenerMessage(id, field, this.endPoint.getLocalNodeHandle(), true);
            mesg.setContext(context);
            this.endPoint.route(id, (Message)mesg, null);
        }
    }

    public void removeRemoteListener(Id id, String field) {
        this.removeRemoteListener(Context.DEFAULT_CONTEXT, id, field);
    }

    public void removeRemoteListener(String context, Id id, String field) {
        this.listeners.remove(id);
        if (this.isOwner(id)) {
            try {
                this.undoReplica(context, id);
                Listeners ls = (Listeners)this.storage.retrieve(context, id, "Listeners");
                if (ls != null) {
                    ls.remove(this.endPoint.getLocalNodeHandle(), field);
                } else {
                    ls = new Listeners();
                }
                this.storage.write(context, id, ls, "Listeners");
                Values values = this.storage.extract(context, id);
                this.replicate(context, id, values);
            }
            catch (StorageException ex) {
                ex.printStackTrace();
            }
        } else {
            ListenerMessage mesg = new ListenerMessage(id, field, this.endPoint.getLocalNodeHandle(), false);
            mesg.setContext(context);
            this.endPoint.route(id, (Message)mesg, null);
        }
    }

    private void putReplica(NodeHandle own, String context, Id key, Values value) {
        try {
            StorageManager replicas = this.replicaBuckets.containsKey(own) ? this.replicaBuckets.get(own) : new MemStorage();
            replicas.write(context, key, value, null);
            this.log("Put Replica in context " + context + " key : " + key + " value " + value + " --> " + replicas.getBucket(context));
            this.replicaBuckets.put(own, replicas);
            this.replicaKeyOwner.put(key, own);
        }
        catch (StorageException ex) {
            ex.printStackTrace();
        }
    }

    private void replicate(String context, Id key, Values values) {
        this.replicaNHs.remove(context, key);
        NodeHandle nh = this.endPoint.getLocalNodeHandle();
        Collection c = Utilities.convert(this.endPoint.replicaSet(key, this.replicationFactor + 1));
        if (c != null) {
            for (NodeHandle to : c) {
                if (to.getId().equals(nh.getId())) continue;
                this.log("Sending replica to " + to.getId());
                ReplicaMessage msg = new ReplicaMessage(key, values, nh);
                msg.setContext(context);
                this.endPoint.route(null, (Message)msg, to);
            }
        }
    }

    private void replicateURL(String context, Id key, Values values, URL url, String field) {
        this.replicaNHs.remove(context, key);
        NodeHandle nh = this.endPoint.getLocalNodeHandle();
        Collection c = Utilities.convert(this.endPoint.replicaSet(key, this.replicationFactor + 1));
        if (c != null) {
            for (NodeHandle to : c) {
                if (to.getId().equals(nh.getId())) continue;
                this.log("Sending replica to " + to.getId());
                ReplicaMessage msg = new ReplicaMessage(key, values, nh, url, field);
                msg.setContext(context);
                this.endPoint.route(null, (Message)msg, to);
            }
        }
    }

    private void undoReplica(String context, Id key) {
        Collection c = this.replicaNHs.remove(context, key);
        if (c != null) {
            for (NodeHandle nh : c) {
                this.log("Removing replica from " + nh.getId());
                RemoveReplicaMessage msg = new RemoveReplicaMessage(nh, key);
                msg.setContext(context);
                this.endPoint.route(null, (Message)msg, nh);
            }
        }
    }

    private Values getReplicaValue(String context, Id key) {
        boolean found = false;
        Values values = null;
        Iterator<StorageManager> it = this.replicaBuckets.values().iterator();
        while (it.hasNext() && !found) {
            StorageManager s = it.next();
            values = s.extract(context, key);
            found = values != null;
        }
        return values;
    }

    private void remoteListeners(String context, Id key, Object value, String field, boolean add) {
        Collection c;
        Listeners ls = (Listeners)this.storage.retrieve(context, key, "Listeners");
        if (ls != null && field != null && (c = ls.getSubscribers(field)) != null) {
            for (NodeHandle destiny : c) {
                NotifyMessage msg = new NotifyMessage(key, value, field, true);
                msg.setContext(context);
                this.endPoint.route(null, (Message)msg, destiny);
            }
        }
    }

    private boolean CVS(Object v1, Object v2) {
        Values values = (Values)v1;
        Values oldValues = (Values)v2;
        if (values != null && values.get("CVS") != null) {
            int version = (Integer)values.get("CVS");
            if (oldValues != null && oldValues.get("CVS") != null) {
                int oldVersion = (Integer)oldValues.get("CVS");
                return version > oldVersion;
            }
            values.put("CVS", new Integer(0));
            return true;
        }
        if (values == null) {
            return false;
        }
        if (oldValues != null && oldValues.get("CVS") != null) {
            int oldVersion = (Integer)oldValues.get("CVS");
            int newVersion = oldVersion + 1;
            values.put("CVS", new Integer(newVersion));
        } else {
            values.put("CVS", new Integer(0));
        }
        return true;
    }

    private synchronized void refresh(int mode) {
        if (mode == 0) {
            this.checkMyKeys();
            this.checkMyRemoteReplicas();
            this.checkReplicas();
        } else if (mode == 1) {
            this.checkMyKeys();
        } else {
            this.checkMyRemoteReplicas();
            this.checkReplicas();
        }
    }

    static {
        applicationId = "Bunshin";
    }

    class PeriodicTask
    extends TimerTask {
        PeriodicTask() {
        }

        public void run() {
            BunshinImpl.this.refresh(0);
            if (BunshinImpl.this.caching) {
                BunshinImpl.this.cache.incTime();
                for (String context : BunshinImpl.this.control.keySet()) {
                    Hashtable pairs = (Hashtable)BunshinImpl.this.control.get(context);
                    if (pairs == null) continue;
                    for (Id key : pairs.keySet()) {
                        Values values = null;
                        if (BunshinImpl.this.isOwner(key)) {
                            values = BunshinImpl.this.storage.extract(context, key);
                        } else if (BunshinImpl.this.replicaKeyOwner.containsKey(key)) {
                            values = BunshinImpl.this.getReplicaValue(context, key);
                        } else if (BunshinImpl.this.cache.contains(context, key)) {
                            values = BunshinImpl.this.cache.get(context, key);
                        }
                        PriorityList pl = (PriorityList)pairs.get(key);
                        BunshinImpl.this.log("cache key " + key + " max request : " + pl.getMax());
                        if (pl.getMax() > 30) {
                            NodeHandle nh = (NodeHandle)pl.peak();
                            BunshinImpl.this.log("send CacheMessage (key : " + key + ", values : " + values);
                            CacheMessage msg = new CacheMessage(key, values);
                            msg.setContext(context);
                            BunshinImpl.this.endPoint.route(null, (Message)msg, nh);
                        }
                        pl.clear();
                    }
                }
            }
        }
    }

    class BunshinAutoPutClient
    implements BunshinPutClient {
        String context;
        Id key;

        public BunshinAutoPutClient(String context, Id key) {
            this.context = context;
            this.key = key;
        }

        public void put(boolean ack, NodeHandle owner) {
            if (ack) {
                try {
                    Values values = BunshinImpl.this.storage.extract(this.context, this.key);
                    BunshinImpl.this.storage.remove(this.context, this.key);
                    if (owner != null && values != null) {
                        BunshinImpl.this.putReplica(owner, this.context, this.key, values);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

