/*
 * Decompiled with CFR 0.152.
 */
package bunshin;

import bunshin.Bunshin;
import bunshin.BunshinImpl;
import bunshin.Context;
import bunshin.storage.StorageManager;
import bunshin.util.Utilities;
import bunshin.util.Values;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.util.Properties;
import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public class BunshinConnection {
    public static Environment env = new Environment();
    public static int PORT = 5019;
    public static int BOOTSTRAP_PORT = 5019;
    public static String BOOTSTRAP_HOST = "localhost";
    private PastryNode node;
    protected BunshinImpl bunshinApp;
    protected Endpoint endPoint;

    public BunshinConnection(String bootHost, int bootPort) {
        this.createNode(bootHost, bootPort);
    }

    public BunshinConnection(Properties prop) throws Exception {
        String bootHost = (String)prop.get("BUNSHIN_HOST");
        if (bootHost == null) {
            bootHost = "auto";
        }
        int bootPort = Integer.parseInt((String)prop.get("BUNSHIN_PORT"));
        this.createNode(bootHost, bootPort);
    }

    public BunshinConnection(String path) throws Exception {
        Properties prop = this.loadProp(path);
        String bootHost = (String)prop.get("BUNSHIN_HOST");
        if (bootHost == null) {
            bootHost = "auto";
        }
        int bootPort = Integer.parseInt((String)prop.get("BUNSHIN_PORT"));
        this.createNode(bootHost, bootPort);
    }

    private Properties loadProp(String path) throws Exception {
        FileInputStream fis = new FileInputStream(path);
        Properties prop = new Properties();
        prop.load(fis);
        fis.close();
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNode(String bootHost, int bootPort) {
        if (!bootHost.equalsIgnoreCase("auto")) {
            BOOTSTRAP_HOST = bootHost;
        }
        BOOTSTRAP_PORT = bootPort;
        PORT = bootPort;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = null;
        int newPort = PORT;
        while (true) {
            DatagramChannel channel = null;
            try {
                channel = DatagramChannel.open();
                channel.configureBlocking(false);
                InetSocketAddress isa = new InetSocketAddress(newPort);
                channel.socket().bind(isa);
                channel.socket().close();
                channel.close();
                factory = new SocketPastryNodeFactory((NodeIdFactory)nidFactory, newPort, env);
            }
            catch (Exception e) {
                System.out.println("Port " + ((newPort += 100) - 100) + " already bound. Trying " + newPort + "...");
                continue;
            }
            finally {
                channel.socket().close();
                try {
                    channel.close();
                }
                catch (IOException ex) {}
                continue;
            }
            break;
        }
        InetSocketAddress address = new InetSocketAddress(BOOTSTRAP_HOST, BOOTSTRAP_PORT);
        NodeHandle bootHandle = factory.getNodeHandle(address);
        this.node = factory.newNode(bootHandle);
        while (!this.node.isReady()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex1) {}
        }
    }

    public void init(String id, StorageManager manager, int replicaFactor, boolean cache, boolean debug) {
        this.bunshinApp = new BunshinImpl(id);
        this.bunshinApp.setStorageManager(manager);
        this.bunshinApp.setReplicationFactor(replicaFactor);
        if (cache) {
            this.bunshinApp.activateCache();
        }
        if (debug) {
            this.bunshinApp.activateDebug();
        }
        this.endPoint = this.node.registerApplication((Application)this.bunshinApp, id);
        this.bunshinApp.setRefreshTime(20000);
        this.bunshinApp.setEndPoint(this.endPoint);
    }

    public void init(String id, StorageManager manager, int replicaFactor, int time_sec, boolean cache, boolean debug) {
        this.bunshinApp = new BunshinImpl(id);
        this.bunshinApp.setStorageManager(manager);
        this.bunshinApp.setReplicationFactor(replicaFactor);
        if (cache) {
            this.bunshinApp.activateCache();
        }
        if (debug) {
            this.bunshinApp.activateDebug();
        }
        this.endPoint = this.node.registerApplication((Application)this.bunshinApp, id);
        this.bunshinApp.setRefreshTime(time_sec * 1000);
        this.bunshinApp.setEndPoint(this.endPoint);
    }

    public void init(String path) throws Exception {
        Properties prop = this.loadProp(path);
        String id = (String)prop.get("BUNSHIN_ID_APPLICATION");
        StorageManager manager = (StorageManager)Class.forName((String)prop.get("BUNSHIN_STORAGE_MANAGER")).newInstance();
        manager.init(prop);
        int replicaFactor = Integer.parseInt((String)prop.get("BUNSHIN_REPLICA_FACTOR"));
        boolean cache = "TRUE".equals((String)prop.get("BUNSHIN_CACHE"));
        boolean debug = "TRUE".equals((String)prop.get("BUNSHIN_DEBUG"));
        int time = Integer.parseInt((String)prop.get("BUNSHIN_REFRESH_TIME_SEC"));
        this.init(id, manager, replicaFactor, time, cache, debug);
    }

    public Bunshin getBunshinApp() {
        return this.bunshinApp;
    }

    public void setInfoContext(String context, String path, String url, URL[] URLsList) {
        this.bunshinApp.setInfoContext(context, path, url, URLsList);
    }

    public void retrieveObject(String context, Id key, bunshin.listeners.BunshinGetClient client) throws IOException {
        this.bunshinApp.get(context, key, "Object", client);
    }

    public void storeObject(Id id, Serializable value) {
        this.bunshinApp.put(id, (Object)value, "Object");
    }

    public void storeObject(Id id, Serializable value, String field) {
        this.bunshinApp.put(id, (Object)value, field);
    }

    public void storeObject(String context, Id id, Serializable value) {
        this.bunshinApp.put(context, id, (Object)value, "Object");
    }

    public void insertURL(String context, Id id, URL url) {
        this.bunshinApp.putURL(context, id, url, "URL");
    }

    public Id storeObject(String key, Serializable value) {
        Id id = Utilities.generateHash(key);
        this.bunshinApp.put(id, (Object)value, "Object");
        return id;
    }

    public Object retrieveObject(String key) throws IOException {
        Id id = Utilities.generateHash(key);
        return this.retrieveObject(id);
    }

    public Object retrieveObject(String context, Id key) throws IOException {
        return this.retrieveObject(context, key, "Object");
    }

    public Object retrieveObject(Id key) throws IOException {
        return this.retrieveObject(Context.DEFAULT_CONTEXT, key, "Object");
    }

    public Object retrieveObject(Id key, String field) throws IOException {
        return this.retrieveObject(Context.DEFAULT_CONTEXT, key, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrieveObject(String context, Id key, String field) throws IOException {
        int timeout;
        System.err.println("RetrieveObject key: " + key.toStringFull());
        Object value = null;
        BunshinGetClient client = new BunshinGetClient(field);
        this.bunshinApp.get(context, key, field, client);
        BunshinGetClient bunshinGetClient = client;
        synchronized (bunshinGetClient) {
            for (timeout = 0; !client.lookupResultArrived && timeout < 30; ++timeout) {
                try {
                    client.wait(100L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        System.err.println("RetrieveObject key " + key.toStringFull() + " returning value: " + value + " timeout " + timeout);
        return client.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL retrieveURL(String context, Id key) throws IOException {
        BunshinURLClient client = new BunshinURLClient();
        this.bunshinApp.getURL(context, key, "URL", client);
        BunshinURLClient bunshinURLClient = client;
        synchronized (bunshinURLClient) {
            for (int timeout = 0; !client.lookupResultArrived && timeout < 30; ++timeout) {
                try {
                    client.wait(100L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        return client.urlValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrieve(String context, Id key, String field) throws IOException {
        BunshinGetClient client = new BunshinGetClient(field);
        this.bunshinApp.get(context, key, field, client);
        BunshinGetClient bunshinGetClient = client;
        synchronized (bunshinGetClient) {
            for (int timeout = 0; !client.lookupResultArrived && timeout < 30; ++timeout) {
                try {
                    client.wait(100L);
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        return client.value;
    }

    public void removeObject(String key) throws IOException {
        Id id = Utilities.generateHash(key);
        this.bunshinApp.remove(id, "Object");
    }

    public void removeObject(Id idValue) throws IOException {
        this.bunshinApp.remove(idValue, "Object");
    }

    public void removeObject(String key, String field) throws IOException {
        Id id = Utilities.generateHash(key);
        this.bunshinApp.remove(id, field);
    }

    public void removeObject(Id idValue, String field) throws IOException {
        this.bunshinApp.remove(idValue, field);
    }

    public void leave() {
        this.bunshinApp.leave();
    }

    static {
        try {
            BOOTSTRAP_HOST = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private class BunshinURLClient
    implements bunshin.listeners.BunshinURLClient {
        public boolean lookupResultArrived = false;
        public URL urlValue = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void get(URL result) {
            BunshinURLClient bunshinURLClient = this;
            synchronized (bunshinURLClient) {
                this.urlValue = result != null ? result : null;
                this.lookupResultArrived = true;
            }
        }
    }

    private class BunshinGetClient
    implements bunshin.listeners.BunshinGetClient {
        public boolean lookupResultArrived = false;
        public Object value = null;
        public String field;

        public BunshinGetClient(String _field) {
            this.field = _field;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void get(Object result) {
            BunshinGetClient bunshinGetClient = this;
            synchronized (bunshinGetClient) {
                this.value = result != null ? (result instanceof Values ? ((Values)result).get(this.field) : result) : null;
                this.lookupResultArrived = true;
            }
        }
    }
}

