/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;
import junit.runner.Version;

public class TestRunner
extends BaseTestRunner {
    PrintStream fWriter = System.out;
    int fColumn = 0;

    public TestRunner() {
    }

    public TestRunner(PrintStream writer) {
        this();
        if (writer == null) {
            throw new IllegalArgumentException("Writer can't be null");
        }
        this.fWriter = writer;
    }

    public synchronized void addError(Test test, Throwable t) {
        this.writer().print("E");
    }

    public synchronized void addFailure(Test test, AssertionFailedError t) {
        this.writer().print("F");
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected TestResult doRun(Test suite, boolean wait) {
        TestResult result;
        block2: {
            result = this.createTestResult();
            result.addListener(this);
            long startTime = System.currentTimeMillis();
            suite.run(result);
            long endTime = System.currentTimeMillis();
            long runTime = endTime - startTime;
            this.writer().println();
            this.writer().println("Time: " + this.elapsedTimeAsString(runTime));
            this.print(result);
            this.writer().println();
            if (!wait) break block2;
            this.writer().println("<RETURN> to continue");
            try {
                System.in.read();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public void endTest(Test test) {
    }

    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    public static void main(String[] args) {
        TestRunner aTestRunner = new TestRunner();
        try {
            TestResult r = aTestRunner.start(args);
            if (!r.wasSuccessful()) {
                System.exit(-1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-2);
        }
    }

    public synchronized void print(TestResult result) {
        this.printErrors(result);
        this.printFailures(result);
        this.printHeader(result);
    }

    public void printErrors(TestResult result) {
        if (result.errorCount() != 0) {
            if (result.errorCount() == 1) {
                this.writer().println("There was " + result.errorCount() + " error:");
            } else {
                this.writer().println("There were " + result.errorCount() + " errors:");
            }
            int i = 1;
            Enumeration e = result.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.writer().println(String.valueOf(i) + ") " + failure.failedTest());
                this.writer().print(BaseTestRunner.getFilteredTrace(failure.thrownException()));
                ++i;
            }
        }
    }

    public void printFailures(TestResult result) {
        if (result.failureCount() != 0) {
            if (result.failureCount() == 1) {
                this.writer().println("There was " + result.failureCount() + " failure:");
            } else {
                this.writer().println("There were " + result.failureCount() + " failures:");
            }
            int i = 1;
            Enumeration e = result.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.writer().print(String.valueOf(i) + ") " + failure.failedTest());
                Throwable t = failure.thrownException();
                if (t.getMessage() != null) {
                    this.writer().println(" \"" + BaseTestRunner.truncate(t.getMessage()) + "\"");
                } else {
                    this.writer().println();
                    this.writer().print(BaseTestRunner.getFilteredTrace(failure.thrownException()));
                }
                ++i;
            }
        }
    }

    public void printHeader(TestResult result) {
        if (result.wasSuccessful()) {
            this.writer().println();
            this.writer().print("OK");
            this.writer().println(" (" + result.runCount() + " tests)");
        } else {
            this.writer().println();
            this.writer().println("FAILURES!!!");
            this.writer().println("Tests run: " + result.runCount() + ",  Failures: " + result.failureCount() + ",  Errors: " + result.errorCount());
        }
    }

    public static void run(Class testClass) {
        TestRunner.run(new TestSuite(testClass));
    }

    public static void run(Test suite) {
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.doRun(suite, false);
    }

    public static void runAndWait(Test suite) {
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.doRun(suite, true);
    }

    protected void runFailed(String message) {
        System.err.println(message);
        System.exit(-1);
    }

    protected TestResult start(String[] args) throws Exception {
        String testCase = "";
        boolean wait = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-wait")) {
                wait = true;
            } else if (args[i].equals("-c")) {
                testCase = this.extractClassName(args[++i]);
            } else if (args[i].equals("-v")) {
                System.err.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
            } else {
                testCase = args[i];
            }
            ++i;
        }
        if (testCase.equals("")) {
            throw new Exception("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
        }
        try {
            Test suite = this.getTest(testCase);
            return this.doRun(suite, wait);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    public synchronized void startTest(Test test) {
        this.writer().print(".");
        if (this.fColumn++ >= 40) {
            this.writer().println();
            this.fColumn = 0;
        }
    }

    protected PrintStream writer() {
        return this.fWriter;
    }
}

