/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.runner.BaseTestRunner;
import junit.runner.FailureDetailView;
import junit.runner.SimpleTestCollector;
import junit.runner.TestCollector;
import junit.runner.Version;
import junit.swingui.AboutDialog;
import junit.swingui.CounterPanel;
import junit.swingui.DefaultFailureDetailView;
import junit.swingui.FailureRunView;
import junit.swingui.ProgressBar;
import junit.swingui.StatusLine;
import junit.swingui.TestHierarchyRunView;
import junit.swingui.TestRunContext;
import junit.swingui.TestRunView;
import junit.swingui.TestSelector;

public class TestRunner
extends BaseTestRunner
implements TestRunContext {
    protected JFrame fFrame;
    private Thread fRunner;
    private TestResult fTestResult;
    private JComboBox fSuiteCombo;
    private ProgressBar fProgressIndicator;
    private DefaultListModel fFailures;
    private JLabel fLogo;
    private CounterPanel fCounterPanel;
    private JButton fRun;
    private JButton fQuitButton;
    private JButton fRerunButton;
    private StatusLine fStatusLine;
    private FailureDetailView fFailureView;
    private JTabbedPane fTestViewTab;
    private JCheckBox fUseLoadingRunner;
    private Vector fTestRunViews = new Vector();
    private int fNonLoadingRuns = 0;
    private static Font PLAIN_FONT = StatusLine.PLAIN_FONT;
    private static Font BOLD_FONT = StatusLine.BOLD_FONT;
    private static final int GAP = 4;
    private static final int HISTORY_LENGTH = 5;
    private static final String TESTCOLLECTOR_KEY = "TestCollectorClass";
    private static final String FAILUREDETAILVIEW_KEY = "FailureViewClass";
    static /* synthetic */ Class class$junit$runner$BaseTestRunner;
    static /* synthetic */ Class class$java$lang$String;

    private void about() {
        AboutDialog about = new AboutDialog(this.fFrame);
        about.show();
    }

    protected void aboutToStart(Test testSuite) {
        Enumeration e = this.fTestRunViews.elements();
        while (e.hasMoreElements()) {
            TestRunView v = (TestRunView)e.nextElement();
            v.aboutToStart(testSuite, this.fTestResult);
        }
    }

    static /* synthetic */ Thread access$14(TestRunner $0) {
        return $0.fRunner;
    }

    public void addError(final Test test, final Throwable t) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fCounterPanel.setErrorValue(fTestResult.errorCount());
                this.appendFailure("Error", test, t);
            }
        });
    }

    public void addFailure(final Test test, final AssertionFailedError t) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fCounterPanel.setFailureValue(fTestResult.failureCount());
                this.appendFailure("Failure", test, t);
            }
        });
    }

    private void addGrid(JPanel p, Component co, int x, int y, int w, int fill, double wx, int anchor) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = w;
        c.anchor = anchor;
        c.weightx = wx;
        c.fill = fill;
        if (fill == 1 || fill == 3) {
            c.weighty = 1.0;
        }
        c.insets = new Insets(y == 0 ? 4 : 0, x == 0 ? 4 : 0, 4, 4);
        p.add(co, c);
    }

    private void addToHistory(String suite) {
        int i = 0;
        while (i < this.fSuiteCombo.getItemCount()) {
            if (suite.equals(this.fSuiteCombo.getItemAt(i))) {
                this.fSuiteCombo.removeItemAt(i);
                this.fSuiteCombo.insertItemAt(suite, 0);
                this.fSuiteCombo.setSelectedIndex(0);
                return;
            }
            ++i;
        }
        this.fSuiteCombo.insertItemAt(suite, 0);
        this.fSuiteCombo.setSelectedIndex(0);
        this.pruneHistory();
    }

    private void appendFailure(String kind, Test test, Throwable t) {
        this.fFailures.addElement(new TestFailure(test, t));
        if (this.fFailures.size() == 1) {
            this.revealFailure(test);
        }
    }

    public void browseTestClasses() {
        TestCollector collector = this.createTestCollector();
        TestSelector selector = new TestSelector((Frame)this.fFrame, collector);
        if (selector.isEmpty()) {
            JOptionPane.showMessageDialog(this.fFrame, "No Test Cases found.\nCheck that the configured 'TestCollector' is supported on this platform.");
            return;
        }
        selector.show();
        String className = selector.getSelectedItem();
        if (className != null) {
            this.setSuite(className);
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.textChanged();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void clearStatus() {
        this.fStatusLine.clear();
    }

    protected Component createBrowseButton() {
        JButton browse = new JButton("...");
        browse.setToolTipText("Select a Test class");
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestRunner.this.browseTestClasses();
            }
        });
        return browse;
    }

    protected CounterPanel createCounterPanel() {
        return new CounterPanel();
    }

    protected JPanel createFailedPanel() {
        JPanel failedPanel = new JPanel(new GridLayout(0, 1, 0, 2));
        this.fRerunButton = new JButton("Run");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestRunner.this.rerun();
            }
        });
        failedPanel.add(this.fRerunButton);
        return failedPanel;
    }

    protected FailureDetailView createFailureDetailView() {
        String className = BaseTestRunner.getPreference(FAILUREDETAILVIEW_KEY);
        if (className != null) {
            Class<?> viewClass = null;
            try {
                viewClass = Class.forName(className);
                return (FailureDetailView)viewClass.newInstance();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.fFrame, "Could not create Failure DetailView - using default view");
            }
        }
        return new DefaultFailureDetailView();
    }

    protected JFrame createFrame(String title) {
        JFrame frame = new JFrame("JUnit");
        Image icon = this.loadFrameIcon();
        if (icon != null) {
            ((Frame)frame).setIconImage(icon);
        }
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TestRunner.this.terminate();
            }
        });
        return frame;
    }

    protected JMenu createJUnitMenu() {
        JMenu menu = new JMenu("JUnit");
        menu.setMnemonic('J');
        JMenuItem mi1 = new JMenuItem("About...");
        mi1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TestRunner.this.about();
            }
        });
        mi1.setMnemonic('A');
        menu.add(mi1);
        menu.addSeparator();
        JMenuItem mi2 = new JMenuItem(" Exit ");
        mi2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TestRunner.this.terminate();
            }
        });
        mi2.setMnemonic('x');
        menu.add(mi2);
        return menu;
    }

    protected JLabel createLogo() {
        Icon icon = TestRunner.getIconResource(class$junit$runner$BaseTestRunner != null ? class$junit$runner$BaseTestRunner : (class$junit$runner$BaseTestRunner = TestRunner.class$("junit.runner.BaseTestRunner")), "logo.gif");
        JLabel label = icon != null ? new JLabel(icon) : new JLabel("JV");
        label.setToolTipText("JUnit Version " + Version.id());
        return label;
    }

    protected void createMenus(JMenuBar mb) {
        mb.add(this.createJUnitMenu());
    }

    protected JButton createQuitButton() {
        JButton quit = new JButton(" Exit ");
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestRunner.this.terminate();
            }
        });
        return quit;
    }

    protected JButton createRunButton() {
        JButton run = new JButton("Run");
        run.setEnabled(true);
        run.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestRunner.this.runSuite();
            }
        });
        return run;
    }

    protected StatusLine createStatusLine() {
        return new StatusLine(420);
    }

    protected JComboBox createSuiteCombo() {
        JComboBox combo = new JComboBox();
        combo.setEditable(true);
        combo.setLightWeightPopupEnabled(false);
        combo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                TestRunner.this.textChanged();
                if (e.getKeyChar() == '\n') {
                    TestRunner.this.runSuite();
                }
            }
        });
        try {
            this.loadHistory(combo);
        }
        catch (IOException iOException) {}
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    TestRunner.this.textChanged();
                }
            }
        });
        return combo;
    }

    TestCollector createTestCollector() {
        String className = BaseTestRunner.getPreference(TESTCOLLECTOR_KEY);
        if (className != null) {
            Class<?> collectorClass = null;
            try {
                collectorClass = Class.forName(className);
                return (TestCollector)collectorClass.newInstance();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.fFrame, "Could not create TestCollector - using default collector");
            }
        }
        return new SimpleTestCollector();
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected JTabbedPane createTestRunViews() {
        JTabbedPane pane = new JTabbedPane(3);
        FailureRunView lv = new FailureRunView(this);
        this.fTestRunViews.addElement(lv);
        lv.addTab(pane);
        TestHierarchyRunView tv = new TestHierarchyRunView(this);
        this.fTestRunViews.addElement(tv);
        tv.addTab(pane);
        pane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TestRunner.this.testViewChanged();
            }
        });
        return pane;
    }

    protected JFrame createUI(String suiteName) {
        JFrame frame = this.createFrame("JUnit");
        JMenuBar mb = new JMenuBar();
        this.createMenus(mb);
        frame.setJMenuBar(mb);
        JLabel suiteLabel = new JLabel("Test class name:");
        this.fSuiteCombo = this.createSuiteCombo();
        this.fRun = this.createRunButton();
        frame.getRootPane().setDefaultButton(this.fRun);
        Component browseButton = this.createBrowseButton();
        this.fUseLoadingRunner = this.createUseLoaderCheckBox();
        this.fProgressIndicator = new ProgressBar();
        this.fCounterPanel = this.createCounterPanel();
        JLabel failureLabel = new JLabel("Errors and Failures:");
        this.fFailures = new DefaultListModel();
        this.fTestViewTab = this.createTestRunViews();
        JPanel failedPanel = this.createFailedPanel();
        this.fFailureView = this.createFailureDetailView();
        JScrollPane tracePane = new JScrollPane(this.fFailureView.getComponent(), 22, 32);
        this.fStatusLine = this.createStatusLine();
        this.fQuitButton = this.createQuitButton();
        this.fLogo = this.createLogo();
        JPanel panel = new JPanel(new GridBagLayout());
        this.addGrid(panel, suiteLabel, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fSuiteCombo, 0, 1, 1, 2, 1.0, 17);
        this.addGrid(panel, browseButton, 1, 1, 1, 0, 0.0, 17);
        this.addGrid(panel, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(panel, this.fUseLoadingRunner, 0, 2, 3, 2, 1.0, 17);
        this.addGrid(panel, new JSeparator(), 0, 3, 3, 2, 1.0, 17);
        this.addGrid(panel, this.fProgressIndicator, 0, 4, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fLogo, 2, 4, 1, 0, 0.0, 11);
        this.addGrid(panel, this.fCounterPanel, 0, 5, 2, 0, 0.0, 10);
        JSplitPane splitter = new JSplitPane(0, this.fTestViewTab, tracePane);
        this.addGrid(panel, splitter, 0, 6, 2, 1, 1.0, 17);
        this.addGrid(panel, failedPanel, 2, 6, 1, 2, 0.0, 11);
        this.addGrid(panel, this.fStatusLine, 0, 8, 2, 2, 1.0, 10);
        this.addGrid(panel, this.fQuitButton, 2, 8, 1, 2, 0.0, 10);
        frame.setContentPane(panel);
        frame.pack();
        ((Component)frame).setLocation(200, 200);
        return frame;
    }

    protected JCheckBox createUseLoaderCheckBox() {
        boolean useLoader = this.useReloadingTestSuiteLoader();
        JCheckBox box = new JCheckBox("Reload classes every run", useLoader);
        box.setToolTipText("Use a custom class loader to reload the classes for every run");
        return box;
    }

    private void doRunTest(final Test testSuite) {
        this.setButtonLabel(this.fRun, "Stop");
        this.fRunner = new Thread("TestRunner-Thread"){

            public void run() {
                this.start(testSuite);
                this.postInfo("Running...");
                long startTime = System.currentTimeMillis();
                testSuite.run(fTestResult);
                if (fTestResult.shouldStop()) {
                    this.postStatus("Stopped");
                } else {
                    long endTime = System.currentTimeMillis();
                    long runTime = endTime - startTime;
                    this.postInfo("Finished: " + this.elapsedTimeAsString(runTime) + " seconds");
                }
                this.runFinished(testSuite);
                this.setButtonLabel(fRun, "Run");
                fRunner = null;
                System.gc();
            }
        };
        this.fTestResult = this.createTestResult();
        this.fTestResult.addListener(this);
        this.aboutToStart(testSuite);
        this.fRunner.start();
    }

    public void endTest(Test test) {
        this.postEndTest(test);
    }

    public ListModel getFailures() {
        return this.fFailures;
    }

    public static Icon getIconResource(Class clazz, String name) {
        URL url = clazz.getResource(name);
        if (url == null) {
            System.err.println("Warning: could not load \"" + name + "\" icon");
            return null;
        }
        return new ImageIcon(url);
    }

    private File getSettingsFile() {
        String home = System.getProperty("user.home");
        return new File(home, ".junitsession");
    }

    protected String getSuiteText() {
        if (this.fSuiteCombo == null) {
            return "";
        }
        return (String)this.fSuiteCombo.getEditor().getItem();
    }

    public void handleTestSelected(Test test) {
        this.fRerunButton.setEnabled(test != null && test instanceof TestCase);
        this.showFailureDetail(test);
    }

    public void insertUpdate(DocumentEvent event) {
        this.textChanged();
    }

    private Image loadFrameIcon() {
        ImageIcon icon = (ImageIcon)TestRunner.getIconResource(class$junit$runner$BaseTestRunner != null ? class$junit$runner$BaseTestRunner : (class$junit$runner$BaseTestRunner = TestRunner.class$("junit.runner.BaseTestRunner")), "smalllogo.gif");
        if (icon != null) {
            return icon.getImage();
        }
        return null;
    }

    private void loadHistory(JComboBox combo) throws IOException {
        BufferedReader br;
        block3: {
            br = new BufferedReader(new FileReader(this.getSettingsFile()));
            int itemCount = 0;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    combo.addItem(line);
                    ++itemCount;
                }
                if (itemCount <= 0) break block3;
                combo.setSelectedIndex(0);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                br.close();
                throw throwable;
            }
        }
        Object var5_5 = null;
        br.close();
    }

    public static void main(String[] args) {
        new TestRunner().start(args);
    }

    private void postEndTest(Test test) {
        this.synchUI();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (TestRunner.this.fTestResult != null) {
                    TestRunner.this.fCounterPanel.setRunValue(TestRunner.this.fTestResult.runCount());
                    TestRunner.this.fProgressIndicator.step(TestRunner.this.fTestResult.wasSuccessful());
                }
            }
        });
    }

    private void postInfo(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                this.showInfo(message);
            }
        });
    }

    private void postStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                this.showStatus(status);
            }
        });
    }

    private void pruneHistory() {
        int historyLength = BaseTestRunner.getPreference("maxhistory", 5);
        if (historyLength < 1) {
            historyLength = 1;
        }
        int i = this.fSuiteCombo.getItemCount() - 1;
        while (i > historyLength - 1) {
            this.fSuiteCombo.removeItemAt(i);
            --i;
        }
    }

    public void removeUpdate(DocumentEvent event) {
        this.textChanged();
    }

    private void rerun() {
        TestRunView view = (TestRunView)this.fTestRunViews.elementAt(this.fTestViewTab.getSelectedIndex());
        Test rerunTest = view.getSelectedTest();
        if (rerunTest != null) {
            this.rerunTest(rerunTest);
        }
    }

    private void rerunTest(Test test) {
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test reloadedTest = null;
        try {
            Class reloadedTestClass = this.getLoader().reload(test.getClass());
            Class[] classArgs = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TestRunner.class$("java.lang.String"))};
            Object[] args = new Object[]{((TestCase)test).name()};
            Constructor constructor = reloadedTestClass.getConstructor(classArgs);
            reloadedTest = (Test)constructor.newInstance(args);
        }
        catch (Exception exception) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        TestResult result = new TestResult();
        reloadedTest.run(result);
        String message = reloadedTest.toString();
        if (result.wasSuccessful()) {
            this.showInfo(String.valueOf(message) + " was successful");
        } else if (result.errorCount() == 1) {
            this.showStatus(String.valueOf(message) + " had an error");
        } else {
            this.showStatus(String.valueOf(message) + " had a failure");
        }
    }

    protected void reset() {
        this.fCounterPanel.reset();
        this.fProgressIndicator.reset();
        this.fRerunButton.setEnabled(false);
        this.fFailureView.clear();
        this.fFailures.clear();
    }

    private void revealFailure(Test test) {
        Enumeration e = this.fTestRunViews.elements();
        while (e.hasMoreElements()) {
            TestRunView v = (TestRunView)e.nextElement();
            v.revealFailure(test);
        }
    }

    public void run() {
        this.runSuite();
    }

    public static void run(Class test) {
        String[] args = new String[]{test.getName()};
        TestRunner.main(args);
    }

    protected void runFailed(String message) {
        this.showStatus(message);
        this.fRun.setText("Run");
        this.fRunner = null;
    }

    protected void runFinished(final Test testSuite) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Enumeration e = fTestRunViews.elements();
                while (e.hasMoreElements()) {
                    TestRunView v = (TestRunView)e.nextElement();
                    v.runFinished(testSuite, fTestResult);
                }
            }
        });
    }

    public synchronized void runSuite() {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            if (!this.setUseLoadingRunner()) {
                return;
            }
            this.reset();
            this.showInfo("Load Test Case...");
            String suiteName = this.getSuiteText();
            Test testSuite = this.getTest(suiteName);
            if (testSuite != null) {
                this.addToHistory(suiteName);
                this.doRunTest(testSuite);
            }
        }
    }

    protected synchronized void runTest(Test testSuite) {
        if (this.fRunner != null) {
            this.fTestResult.stop();
        } else {
            this.reset();
            if (testSuite != null) {
                this.doRunTest(testSuite);
            }
        }
    }

    private void saveHistory() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.getSettingsFile()));
        try {
            int i = 0;
            while (i < this.fSuiteCombo.getItemCount()) {
                String testsuite = this.fSuiteCombo.getItemAt(i).toString();
                bw.write(testsuite, 0, testsuite.length());
                bw.newLine();
                ++i;
            }
        }
        finally {
            Object var3_4 = null;
            bw.close();
        }
    }

    private void setButtonLabel(final JButton button, final String label) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                button.setText(label);
            }
        });
    }

    private void setLabelValue(final JTextField label, final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                label.setText(Integer.toString(value));
            }
        });
    }

    public void setSuite(String suiteName) {
        this.fSuiteCombo.getEditor().setItem(suiteName);
    }

    private boolean setUseLoadingRunner() {
        this.setLoading(this.fUseLoadingRunner.isSelected());
        if (!this.fUseLoadingRunner.isSelected()) {
            ++this.fNonLoadingRuns;
        }
        if (this.fNonLoadingRuns > 1) {
            String message = "You are running the tests more than once with the standard class loader.\nCode modifications you made since the last run will be ignored.\nIt is recommended to restart the TestRunner.\nDo you still want to continue?";
            int returnCode = JOptionPane.showConfirmDialog(this.fFrame, message, "Warning", 0);
            return returnCode == 0;
        }
        return true;
    }

    private void showFailureDetail(Test test) {
        if (test != null) {
            ListModel failures = this.getFailures();
            int i = 0;
            while (i < failures.getSize()) {
                TestFailure failure = (TestFailure)failures.getElementAt(i);
                if (failure.failedTest() == test) {
                    this.fFailureView.showFailure(failure);
                    return;
                }
                ++i;
            }
        }
        this.fFailureView.clear();
    }

    private void showInfo(String message) {
        this.fStatusLine.showInfo(message);
    }

    private void showStatus(String status) {
        this.fStatusLine.showError(status);
    }

    private void start(final Test test) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                fProgressIndicator.start(test.countTestCases());
            }
        });
    }

    public void start(String[] args) {
        String suiteName = this.processArguments(args);
        this.fFrame = this.createUI(suiteName);
        this.fFrame.pack();
        ((Component)this.fFrame).setVisible(true);
        if (suiteName != null) {
            this.setSuite(suiteName);
            this.runSuite();
        }
    }

    public void startTest(Test test) {
        this.postInfo("Running: " + test);
    }

    private void synchUI() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (Exception exception) {}
    }

    public void terminate() {
        this.fFrame.dispose();
        try {
            this.saveHistory();
        }
        catch (IOException iOException) {
            System.out.println("Couldn't save test run history");
        }
        System.exit(0);
    }

    public void testViewChanged() {
        TestRunView view = (TestRunView)this.fTestRunViews.elementAt(this.fTestViewTab.getSelectedIndex());
        view.activate();
    }

    public void textChanged() {
        this.fRun.setEnabled(this.getSuiteText().length() > 0);
        this.clearStatus();
    }
}

