/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.doomdark.uuid.EthernetAddress;
import org.doomdark.uuid.TagURI;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDTimer;

public final class UUIDGenerator {
    private static final UUIDGenerator sSingleton = new UUIDGenerator();
    private SecureRandom mRnd = null;
    private final Object mDummyAddressLock = new Object();
    private EthernetAddress mDummyAddress = null;
    private final Object mTimerLock = new Object();
    private UUIDTimer mTimer = null;
    private MessageDigest mHasher = null;

    private UUIDGenerator() {
    }

    public static UUIDGenerator getInstance() {
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EthernetAddress getDummyAddress() {
        Object object = this.mDummyAddressLock;
        synchronized (object) {
            if (this.mDummyAddress == null) {
                SecureRandom secureRandom = this.getRandomNumberGenerator();
                byte[] byArray = new byte[6];
                secureRandom.nextBytes(byArray);
                byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
                try {
                    this.mDummyAddress = new EthernetAddress(byArray);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.mDummyAddress;
    }

    public SecureRandom getRandomNumberGenerator() {
        if (this.mRnd == null) {
            this.mRnd = new SecureRandom();
        }
        return this.mRnd;
    }

    public MessageDigest getHashAlgorithm() {
        if (this.mHasher == null) {
            try {
                this.mHasher = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new Error("Couldn't instantiate an MD5 MessageDigest instance: " + noSuchAlgorithmException.toString());
            }
        }
        return this.mHasher;
    }

    public UUID generateRandomBasedUUID() {
        return this.generateRandomBasedUUID(this.getRandomNumberGenerator());
    }

    public UUID generateRandomBasedUUID(SecureRandom secureRandom) {
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        return new UUID(4, byArray);
    }

    public UUID generateTimeBasedUUID() {
        return this.generateTimeBasedUUID(this.getDummyAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID generateTimeBasedUUID(EthernetAddress ethernetAddress) {
        byte[] byArray = new byte[16];
        ethernetAddress.toByteArray(byArray, 10);
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer == null) {
                this.mTimer = new UUIDTimer(this.getRandomNumberGenerator());
            }
            this.mTimer.getTimestamp(byArray);
        }
        return new UUID(1, byArray);
    }

    public UUID generateNameBasedUUID(UUID uUID, String string, MessageDigest messageDigest) {
        messageDigest.reset();
        if (uUID != null) {
            messageDigest.update(uUID.asByteArray());
        }
        messageDigest.update(string.getBytes());
        return new UUID(3, messageDigest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID generateNameBasedUUID(UUID uUID, String string) {
        MessageDigest messageDigest;
        MessageDigest messageDigest2 = messageDigest = this.getHashAlgorithm();
        synchronized (messageDigest2) {
            return this.generateNameBasedUUID(uUID, string, this.getHashAlgorithm());
        }
    }

    public UUID generateTagURIBasedUUID(TagURI tagURI) {
        return this.generateNameBasedUUID(null, tagURI.toString());
    }

    public UUID generateTagURIBasedUUID(TagURI tagURI, MessageDigest messageDigest) {
        return this.generateNameBasedUUID(null, tagURI.toString(), messageDigest);
    }

    public static void main(String[] stringArray) {
        Iterator iterator;
        UUIDGenerator uUIDGenerator = UUIDGenerator.getInstance();
        UUID uUID = new UUID("6ba7b811-9dad-11d1-80b4-00c04fd430c8");
        System.out.println("UUIDGenerator.main()");
        System.out.println("--------------------");
        System.out.println();
        TreeSet<UUID> treeSet = new TreeSet<UUID>();
        ArrayList<UUID> arrayList = new ArrayList<UUID>(4);
        int n = 0;
        while (n < 4) {
            System.out.print("Random UUID: ");
            UUID uUID2 = uUIDGenerator.generateRandomBasedUUID();
            treeSet.add(uUID2);
            UUIDGenerator.doTest(uUID2, System.out, 4);
            System.out.print("Time-based UUID: ");
            uUID2 = uUIDGenerator.generateTimeBasedUUID();
            treeSet.add(uUID2);
            arrayList.add(uUID2);
            UUIDGenerator.doTest(uUID2, System.out, 1);
            iterator = "test-round-" + n;
            System.out.print("Named-based UUID: (namespace URL, name '" + iterator + "')");
            uUID2 = uUIDGenerator.generateNameBasedUUID(uUID, (String)((Object)iterator));
            treeSet.add(uUID2);
            UUIDGenerator.doTest(uUID2, System.out, 3);
            ++n;
        }
        int n2 = treeSet.size();
        System.out.print("Created 12 uuids; ordered treeset contains " + n2);
        System.out.println(n2 == 12 ? " [OK]" : " [FAIL]");
        System.out.println("Checking ordering:");
        iterator = treeSet.iterator();
        int n3 = -1;
        System.out.print("Overall ordering by type: ");
        while (iterator.hasNext()) {
            System.out.print(".");
            UUID uUID3 = (UUID)iterator.next();
            int n4 = uUID3.getType();
            if (n4 < n3) break;
            n3 = n4;
        }
        System.out.println(iterator.hasNext() ? "FAIL" : "OK");
        iterator = treeSet.iterator();
        int n5 = -1;
        System.out.print("Time-based UUID ordering on creation time: ");
        while (iterator.hasNext()) {
            UUID uUID4 = (UUID)iterator.next();
            int n6 = arrayList.indexOf(uUID4);
            if (n6 < 0) continue;
            System.out.print("[");
            System.out.print(n6);
            System.out.print("]");
            if (n6 <= n5) break;
        }
        System.out.println(iterator.hasNext() ? "FAIL" : "OK");
        UUIDGenerator.doTestNull();
    }

    private static final void doTest(UUID uUID, PrintStream printStream, int n) {
        UUID uUID2;
        System.out.print(uUID.toString());
        System.out.print(" [type: " + uUID.getType());
        System.out.print(", expected " + n);
        System.out.print(n == uUID.getType() ? ": OK" : ": FAIL");
        System.out.println("]");
        System.out.print("... conversion UUID<->String: ");
        try {
            uUID2 = UUID.valueOf(uUID.toString());
            System.out.println(uUID2.toString());
            System.out.print("  -> ");
            System.out.println(uUID.equals(uUID2) ? "OK" : "FAIL");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("[FAIL: " + numberFormatException.toString() + "]");
        }
        System.out.print("... conversion UUID<->byte array: ");
        uUID2 = UUID.valueOf(uUID.asByteArray());
        System.out.println(uUID2.toString());
        System.out.print("  -> ");
        System.out.println(uUID.equals(uUID2) ? "OK" : "FAIL");
        System.out.print("... considered null? ");
        boolean bl = uUID.isNullUUID();
        System.out.print(bl);
        System.out.print(" (shouldn't be) -> ");
        System.out.println(bl ? "FAIL" : "OK");
    }

    private static final void doTestNull() {
        UUID uUID = UUID.getNullUUID();
        System.out.println("Testing null UUID checks:");
        System.out.println("-------------------------");
        System.out.print("Testing shared null uuid; considered null: ");
        boolean bl = uUID.isNullUUID();
        System.out.print(bl);
        System.out.print("; expected true -> ");
        System.out.println(bl ? "OK" : "FAIL");
        UUID uUID2 = new UUID(new byte[16]);
        System.out.print("Testing explicit null uuid; considered null: ");
        bl = uUID2.isNullUUID();
        System.out.print(bl);
        System.out.print("; expected true -> ");
        System.out.println(bl ? "OK" : "FAIL");
    }
}

