/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lesson7;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Vector;
import rice.Continuation;
import rice.environment.Environment;
import rice.p2p.commonapi.Id;
import rice.p2p.past.Past;
import rice.p2p.past.PastImpl;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.persistence.LRUCache;
import rice.persistence.MemoryStorage;
import rice.persistence.PersistentStorage;
import rice.persistence.StorageManagerImpl;
import rice.tutorial.lesson7.MyPastContent;

public class PastTutorial {
    Vector apps = new Vector();

    public PastTutorial(int bindport, InetSocketAddress bootaddress, int numNodes, Environment env) throws Exception {
        int ctr;
        RandomNodeIdFactory nidFactory = new RandomNodeIdFactory(env);
        SocketPastryNodeFactory factory = new SocketPastryNodeFactory(nidFactory, bindport, env);
        for (int curNode = 0; curNode < numNodes; ++curNode) {
            NodeHandle bootHandle = factory.getNodeHandle(bootaddress);
            PastryNode node = ((PastryNodeFactory)factory).newNode(bootHandle);
            while (!node.isReady()) {
                Thread.sleep(100L);
            }
            System.out.println("Finished creating new node " + node);
            PastryIdFactory idf = new PastryIdFactory(env);
            String storageDirectory = "./storage" + node.getId().hashCode();
            PersistentStorage stor = new PersistentStorage(idf, storageDirectory, 0x400000L, node.getEnvironment());
            PastImpl app = new PastImpl(node, new StorageManagerImpl(idf, stor, new LRUCache(new MemoryStorage(idf), 524288, node.getEnvironment())), 3, "");
            this.apps.add(app);
        }
        Thread.sleep(5000L);
        PastryIdFactory localFactory = new PastryIdFactory(env);
        System.out.println("Storing 5 keys");
        Id[] storedKey = new Id[5];
        for (ctr = 0; ctr < storedKey.length; ++ctr) {
            String s = "test" + env.getRandomSource().nextInt();
            final MyPastContent myContent = new MyPastContent(localFactory.buildId(s), s);
            storedKey[ctr] = myContent.getId();
            Past p = (Past)this.apps.get(env.getRandomSource().nextInt(numNodes));
            System.out.println("Inserting " + myContent + " at node " + p.getLocalNodeHandle());
            p.insert(myContent, new Continuation(){

                public void receiveResult(Object result) {
                    Boolean[] results = (Boolean[])result;
                    int numSuccessfulStores = 0;
                    for (int ctr = 0; ctr < results.length; ++ctr) {
                        if (!results[ctr].booleanValue()) continue;
                        ++numSuccessfulStores;
                    }
                    System.out.println(myContent + " successfully stored at " + numSuccessfulStores + " locations.");
                }

                public void receiveException(Exception result) {
                    System.out.println("Error storing " + myContent);
                    result.printStackTrace();
                }
            });
        }
        Thread.sleep(5000L);
        System.out.println("Looking up the 5 keys");
        for (ctr = 0; ctr < storedKey.length; ++ctr) {
            final Id lookupKey = storedKey[ctr];
            Past p = (Past)this.apps.get(env.getRandomSource().nextInt(numNodes));
            System.out.println("Looking up " + lookupKey + " at node " + p.getLocalNodeHandle());
            p.lookup(lookupKey, new Continuation(){

                public void receiveResult(Object result) {
                    System.out.println("Successfully looked up " + result + " for key " + lookupKey + ".");
                }

                public void receiveException(Exception result) {
                    System.out.println("Error looking up " + lookupKey);
                    result.printStackTrace();
                }
            });
        }
        Thread.sleep(5000L);
        System.out.println("Looking up a bogus key");
        final Id bogusKey = localFactory.buildId("bogus");
        Past p = (Past)this.apps.get(env.getRandomSource().nextInt(numNodes));
        System.out.println("Looking up bogus key " + bogusKey + " at node " + p.getLocalNodeHandle());
        p.lookup(bogusKey, new Continuation(){

            public void receiveResult(Object result) {
                System.out.println("Successfully looked up " + result + " for key " + bogusKey + ".  Notice that the result is null.");
            }

            public void receiveException(Exception result) {
                System.out.println("Error looking up " + bogusKey);
                result.printStackTrace();
            }
        });
    }

    public static void main(String[] args) throws Exception {
        Environment env = new Environment();
        try {
            int bindport = Integer.parseInt(args[0]);
            InetAddress bootaddr = InetAddress.getByName(args[1]);
            int bootport = Integer.parseInt(args[2]);
            InetSocketAddress bootaddress = new InetSocketAddress(bootaddr, bootport);
            int numNodes = Integer.parseInt(args[3]);
            PastTutorial dt = new PastTutorial(bindport, bootaddress, numNodes, env);
        }
        catch (Exception e) {
            System.out.println("Usage:");
            System.out.println("java [-cp FreePastry-<version>.jar] rice.tutorial.lesson4.DistTutorial localbindport bootIP bootPort numNodes");
            System.out.println("example java rice.tutorial.DistTutorial 9001 pokey.cs.almamater.edu 9001 10");
            throw e;
        }
    }
}

