/*
 * Decompiled with CFR 0.152.
 */
package rice.tutorial.lesson6;

import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.Node;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.scribe.Scribe;
import rice.p2p.scribe.ScribeClient;
import rice.p2p.scribe.ScribeContent;
import rice.p2p.scribe.ScribeImpl;
import rice.p2p.scribe.Topic;
import rice.pastry.commonapi.PastryIdFactory;
import rice.tutorial.lesson6.MyScribeContent;

public class MyScribeClient
implements ScribeClient,
Application {
    int seqNum = 0;
    CancellableTask publishTask;
    Scribe myScribe;
    Topic myTopic;
    protected Endpoint endpoint;

    public MyScribeClient(Node node) {
        this.endpoint = node.registerApplication((Application)this, "myinstance");
        this.myScribe = new ScribeImpl(node, "lesson6instance");
        this.myTopic = new Topic(new PastryIdFactory(node.getEnvironment()), "example topic");
        System.out.println("myTopic = " + this.myTopic);
    }

    public boolean isRoot() {
        return this.myScribe.isRoot(this.myTopic);
    }

    public NodeHandle getParent() {
        return ((ScribeImpl)this.myScribe).getParent(this.myTopic);
    }

    public NodeHandle[] getChildren() {
        return this.myScribe.getChildren(this.myTopic);
    }

    public void subscribe() {
        this.myScribe.subscribe(this.myTopic, this);
    }

    public void startPublishTask() {
        this.publishTask = this.endpoint.scheduleMessage(new PublishContent(), 5000L, 5000L);
    }

    public void deliver(Id id, Message message) {
        if (message instanceof PublishContent) {
            this.sendMulticast();
            this.sendAnycast();
        }
    }

    public void sendMulticast() {
        System.out.println("Node " + this.endpoint.getLocalNodeHandle() + " broadcasting " + this.seqNum);
        MyScribeContent myMessage = new MyScribeContent(this.endpoint.getLocalNodeHandle(), this.seqNum);
        this.myScribe.publish(this.myTopic, myMessage);
        ++this.seqNum;
    }

    public void deliver(Topic topic, ScribeContent content) {
        System.out.println("MyScribeClient.deliver(" + topic + "," + content + ")");
    }

    public void sendAnycast() {
        System.out.println("Node " + this.endpoint.getLocalNodeHandle() + " anycasting " + this.seqNum);
        MyScribeContent myMessage = new MyScribeContent(this.endpoint.getLocalNodeHandle(), this.seqNum);
        this.myScribe.anycast(this.myTopic, myMessage);
        ++this.seqNum;
    }

    public boolean anycast(Topic topic, ScribeContent content) {
        boolean returnValue = this.myScribe.getEnvironment().getRandomSource().nextInt(3) == 0;
        System.out.println("MyScribeClient.anycast(" + topic + "," + content + "):" + returnValue);
        return returnValue;
    }

    public void childAdded(Topic topic, NodeHandle child) {
    }

    public void childRemoved(Topic topic, NodeHandle child) {
    }

    public void subscribeFailed(Topic topic) {
    }

    public boolean forward(RouteMessage message) {
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    class PublishContent
    implements Message {
        PublishContent() {
        }

        public int getPriority() {
            return 0;
        }
    }
}

