/*
 * Decompiled with CFR 0.152.
 */
package rice.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.processing.WorkRequest;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.IdRange;
import rice.p2p.commonapi.IdSet;
import rice.p2p.util.ImmutableSortedMap;
import rice.p2p.util.RedBlackMap;
import rice.p2p.util.ReverseTreeMap;
import rice.p2p.util.XMLObjectInputStream;
import rice.p2p.util.XMLObjectOutputStream;
import rice.persistence.Storage;
import rice.selector.Timer;
import rice.selector.TimerTask;

public class PersistentStorage
implements Storage {
    private Object statLock = new Object();
    private long statsLastWritten;
    private long statsWriteInterval = 60000L;
    private long numWrites = 0L;
    private long numReads = 0L;
    private long numRenames = 0L;
    private long numDeletes = 0L;
    private long numMetadataWrites = 0L;
    private IdFactory factory;
    private String name;
    private File rootDirectory;
    private File backupDirectory;
    private File appDirectory;
    private File lostDirectory;
    private boolean index;
    private HashMap directories;
    private HashMap prefixes;
    private HashSet dirty;
    private ReverseTreeMap metadata;
    private String rootDir;
    private long storageSize;
    private long usedSize;
    Environment environment;
    Logger logger;
    public static final long PERSISTENCE_MAGIC_NUMBER = 8038844221L;
    public static final long PERSISTENCE_VERSION_2 = 2L;
    public static final long PERSISTENCE_REVISION_2_0 = 0L;
    public static final long PERSISTENCE_REVISION_2_1 = 1L;
    public static final String BACKUP_DIRECTORY = "/FreePastry-Storage-Root/";
    public static final String LOST_AND_FOUND_DIRECTORY = "lost+found";
    public static final String METADATA_FILENAME = "metadata.cache";
    public static final int MAX_FILES = 256;
    public static final int MAX_DIRECTORIES = 32;
    public static final int METADATA_SYNC_TIME = 300000;
    public static final String ZERO_LENGTH_NAME = "!";

    public PersistentStorage(IdFactory factory, String rootDir, long size, Environment env) throws IOException {
        this(factory, "default", rootDir, size, env);
    }

    public PersistentStorage(IdFactory factory, String name, String rootDir, long size, Environment env) throws IOException {
        this(factory, name, rootDir, size, true, env);
    }

    public PersistentStorage(IdFactory factory, String name, String rootDir, long size, boolean index, Environment env) throws IOException {
        this.environment = env;
        this.logger = this.environment.getLogManager().getLogger(PersistentStorage.class, null);
        this.factory = factory;
        this.name = name;
        this.rootDir = rootDir;
        this.storageSize = size;
        this.index = index;
        this.directories = new HashMap();
        this.prefixes = new HashMap();
        this.statsLastWritten = this.environment.getTimeSource().currentTimeMillis();
        if (index) {
            this.dirty = new HashSet();
            this.metadata = new ReverseTreeMap();
        }
        if (this.logger.level <= 800) {
            this.logger.log("Launching persistent storage in " + rootDir + " with name " + name + " spliting factor " + 256);
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getMetadata(Id id) {
        if (this.index) {
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return (Serializable)this.metadata.get(id);
            }
        }
        throw new UnsupportedOperationException("getMetadata() not supported without indexing");
    }

    public void getObject(final Id id, Continuation c) {
        this.printStats();
        if (this.index && !this.exists(id)) {
            c.receiveResult(null);
        } else {
            this.environment.getProcessor().processBlockingIO(new WorkRequest(c, this.environment.getSelectorManager()){

                public String toString() {
                    return "getObject " + id;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doWork() throws Exception {
                    Object object = PersistentStorage.this.statLock;
                    synchronized (object) {
                        PersistentStorage.this.numReads++;
                    }
                    File objFile = PersistentStorage.this.getFile(id);
                    try {
                        if (objFile == null || !objFile.exists()) {
                            return null;
                        }
                        if (PersistentStorage.this.logger.level <= 400) {
                            PersistentStorage.this.logger.log("COUNT: Fetching data under " + id.toStringFull() + " of size " + objFile.length() + " in " + PersistentStorage.this.name);
                        }
                        return PersistentStorage.readData(objFile);
                    }
                    catch (Exception e) {
                        if (PersistentStorage.this.index) {
                            ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                            synchronized (reverseTreeMap) {
                                PersistentStorage.this.metadata.remove(id);
                                PersistentStorage.this.dirty.add(objFile.getParentFile());
                            }
                        }
                        PersistentStorage.this.moveToLost(objFile);
                        throw e;
                    }
                }
            });
        }
    }

    public long getTotalSize() {
        return this.usedSize;
    }

    public int getSize() {
        if (this.index) {
            return this.metadata.size();
        }
        throw new UnsupportedOperationException("getSize() not supported without indexing");
    }

    private String[] getMatchingDirectories(String prefix, String[] dirNames) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < dirNames.length; ++i) {
            if (!dirNames[i].startsWith(prefix)) continue;
            result.add(dirNames[i]);
        }
        return result.toArray(new String[0]);
    }

    private String[] getDirectories(String[] names) {
        int length = this.getPrefixLength(names);
        String prefix = names[0].substring(0, length);
        CharacterHashSet set = new CharacterHashSet();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].length() <= length) continue;
            set.put(names[i].charAt(length));
        }
        char[] splits = set.get();
        String[] result = new String[splits.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + splits[i];
        }
        return result;
    }

    private int getPrefixLength(String[] names) {
        int length = names[0].length() - 1;
        for (int i = 0; i < names.length; ++i) {
            length = this.getPrefixLength(names[0], names[i], length);
        }
        return length;
    }

    private int getPrefixLength(String a, String b, int max) {
        int i;
        for (i = 0; i < a.length() - 1 && i < b.length() - 1 && i < max; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return i;
        }
        return i;
    }

    private boolean isTemporaryFile(String name) {
        return name.indexOf(".") >= 0;
    }

    private boolean isAncestor(File file, File ancestor) {
        while (file != null && !file.equals(ancestor)) {
            file = file.getParentFile();
        }
        return file != null;
    }

    private File getFile(Id id) throws IOException {
        File file;
        File dir = this.getDirectoryForId(id);
        String name = id.toStringFull().substring(this.getPrefix(dir).length());
        if (name.equals("")) {
            name = ZERO_LENGTH_NAME;
        }
        if ((file = new File(dir, name)).exists() && file.isDirectory()) {
            file = new File(file, ZERO_LENGTH_NAME);
        }
        return file;
    }

    private File getDirectoryForId(Id id) throws IOException {
        return this.getDirectoryForName(id.toStringFull());
    }

    private File getDirectoryForName(String name) throws IOException {
        return this.getDirectoryForName(name, this.appDirectory);
    }

    private File getDirectoryForName(String name, File dir) throws IOException {
        File[] subDirs = (File[])this.directories.get(dir);
        if (subDirs.length == 0) {
            return dir;
        }
        for (int i = 0; i < subDirs.length; ++i) {
            if (name.startsWith(subDirs[i].getName())) {
                return this.getDirectoryForName(name.substring(subDirs[i].getName().length()), subDirs[i]);
            }
            if (name.length() != 0 || !subDirs[i].getName().equals(ZERO_LENGTH_NAME)) continue;
            return this.getDirectoryForName(name, subDirs[i]);
        }
        if (name.length() >= subDirs[0].getName().length() || name.length() == 0 && subDirs[0].getName().length() == 1) {
            File newDir = new File(dir, name.length() == 0 ? ZERO_LENGTH_NAME : name.substring(0, subDirs[0].getName().length()));
            if (this.logger.level <= 500) {
                this.logger.log("Necessarily creating dir " + newDir.getName());
            }
            PersistentStorage.createDirectory(newDir);
            this.directories.put(dir, this.append(subDirs, newDir));
            this.directories.put(newDir, new File[0]);
            if (this.checkDirectory(dir)) {
                return this.getDirectoryForName(name, dir);
            }
            return newDir;
        }
        String[] dirs = new String[subDirs.length + 1];
        for (int i = 0; i < subDirs.length; ++i) {
            dirs[i] = subDirs[i].getName();
        }
        dirs[subDirs.length] = name.length() == 0 ? ZERO_LENGTH_NAME : name;
        this.reformatDirectory(dir, this.getDirectories(dirs));
        return this.getDirectoryForName(name, dir);
    }

    private String getPostfix(Id id, File file) {
        return id.toStringFull().substring(this.getPrefix(file).length());
    }

    private String getPrefix(File file) {
        if (this.prefixes.get(file) != null) {
            return (String)this.prefixes.get(file);
        }
        StringBuffer buffer = new StringBuffer();
        while (!file.equals(this.appDirectory)) {
            buffer.insert(0, file.getName().replaceAll(ZERO_LENGTH_NAME, ""));
            file = file.getParentFile();
        }
        this.prefixes.put(file, buffer.toString());
        return this.getPrefix(file);
    }

    private boolean isFile(File parent, String name) {
        return !new File(parent, name).isDirectory() && !name.equals(METADATA_FILENAME);
    }

    private boolean isDirectory(File parent, String name) {
        return new File(parent, name).isDirectory();
    }

    protected IdRange getRangeForDirectory(File dir) {
        String result = "";
        while (!dir.equals(this.appDirectory)) {
            result = dir.getName() + result;
            dir = dir.getParentFile();
        }
        return this.factory.buildIdRangeFromPrefix(result);
    }

    public String getRoot() {
        return this.rootDir;
    }

    public long getStorageSize() {
        if (this.storageSize > 0L) {
            return this.storageSize;
        }
        return Long.MAX_VALUE;
    }

    private long getUsedSpace() {
        return this.usedSize;
    }

    public String getName() {
        return this.name;
    }

    public void setTimer(Timer timer) {
        if (this.index) {
            timer.scheduleAtFixedRate(new TimerTask(){

                public String toString() {
                    return "persistence dirty purge enqueue";
                }

                public void run() {
                    PersistentStorage.this.environment.getProcessor().processBlockingIO(new WorkRequest(new Continuation.ListenerContinuation("Enqueue of writeMetadataFile", PersistentStorage.this.environment), PersistentStorage.this.environment.getSelectorManager()){

                        public String toString() {
                            return "persistence dirty purge";
                        }

                        public Object doWork() throws Exception {
                            PersistentStorage.this.writeDirty();
                            return Boolean.TRUE;
                        }
                    });
                }
            }, this.environment.getRandomSource().nextInt(300000), 300000L);
        }
    }

    public void setMetadata(final Id id, final Serializable metadata, Continuation c) {
        this.printStats();
        if (!this.exists(id)) {
            c.receiveResult(new Boolean(false));
        } else {
            this.environment.getProcessor().processBlockingIO(new WorkRequest(c, this.environment.getSelectorManager()){

                public String toString() {
                    return "setMetadata " + id;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doWork() throws Exception {
                    Object object = PersistentStorage.this.statLock;
                    synchronized (object) {
                        PersistentStorage.this.numMetadataWrites++;
                    }
                    if (PersistentStorage.this.logger.level <= 400) {
                        PersistentStorage.this.logger.log("COUNT: Updating metadata for " + id.toStringFull() + " in " + PersistentStorage.this.name);
                    }
                    File objFile = PersistentStorage.this.getFile(id);
                    PersistentStorage.writeMetadata(objFile, metadata);
                    if (PersistentStorage.this.index) {
                        ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                        synchronized (reverseTreeMap) {
                            PersistentStorage.this.metadata.put(id, metadata);
                            PersistentStorage.this.dirty.add(objFile.getParentFile());
                        }
                    }
                    return Boolean.TRUE;
                }
            });
        }
    }

    public boolean setRoot(String dir) {
        this.rootDir = dir;
        return true;
    }

    public boolean setStorageSize(long size) {
        if (this.storageSize <= size) {
            this.storageSize = size;
            return true;
        }
        if (size > this.usedSize) {
            this.storageSize = size;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStats() {
        Object object = this.statLock;
        synchronized (object) {
            long now = this.environment.getTimeSource().currentTimeMillis();
            if (this.statsLastWritten / this.statsWriteInterval != now / this.statsWriteInterval) {
                if (this.logger.level <= 800) {
                    this.logger.log("@L.PE name=" + this.name + " interval=" + this.statsLastWritten + "-" + now);
                }
                this.statsLastWritten = now;
                if (this.logger.level <= 800) {
                    this.logger.log("@L.PE   objsTotal=" + (this.index ? "" + this.metadata.keySet().size() : "?") + " objsBytesTotal=" + this.getTotalSize());
                }
                if (this.logger.level <= 800) {
                    this.logger.log("@L.PE   numWrites=" + this.numWrites + " numReads=" + this.numReads + " numDeletes=" + this.numDeletes);
                }
                if (this.logger.level <= 800) {
                    this.logger.log("@L.PE   numMetadataWrites=" + this.numMetadataWrites + " numRenames=" + this.numRenames);
                }
            }
        }
    }

    public void rename(final Id oldId, final Id newId, Continuation c) {
        this.printStats();
        this.environment.getProcessor().processBlockingIO(new WorkRequest(c, this.environment.getSelectorManager()){

            public String toString() {
                return "rename " + oldId + " " + newId;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Object object = PersistentStorage.this.statLock;
                synchronized (object) {
                    PersistentStorage.this.numRenames++;
                }
                File f = PersistentStorage.this.getFile(oldId);
                if (f != null && f.exists()) {
                    File g = PersistentStorage.this.getFile(newId);
                    PersistentStorage.renameFile(f, g);
                    PersistentStorage.this.checkDirectory(g.getParentFile());
                    if (PersistentStorage.this.index) {
                        ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                        synchronized (reverseTreeMap) {
                            PersistentStorage.this.metadata.put(newId, PersistentStorage.this.metadata.get(oldId));
                            PersistentStorage.this.metadata.remove(oldId);
                        }
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    public void store(final Id id, final Serializable metadata, final Serializable obj, Continuation c) {
        if (id == null || obj == null) {
            c.receiveResult(new Boolean(false));
            return;
        }
        this.printStats();
        this.environment.getProcessor().processBlockingIO(new WorkRequest(c, this.environment.getSelectorManager()){

            public String toString() {
                return "store " + id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Object object = PersistentStorage.this.statLock;
                synchronized (object) {
                    PersistentStorage.this.numWrites++;
                }
                if (PersistentStorage.this.logger.level <= 400) {
                    PersistentStorage.this.logger.log("Storing object " + obj + " under id " + id.toStringFull() + " in root " + PersistentStorage.this.appDirectory);
                }
                File objFile = PersistentStorage.this.getFile(id);
                File transcFile = PersistentStorage.this.makeTemporaryFile(id);
                if (PersistentStorage.this.logger.level <= 400) {
                    PersistentStorage.this.logger.log("Writing object " + obj + " to temporary file " + transcFile + " and renaming to " + objFile);
                }
                try {
                    PersistentStorage.writeObject(obj, metadata, id, PersistentStorage.this.environment.getTimeSource().currentTimeMillis(), transcFile);
                    if (PersistentStorage.this.logger.level <= 400) {
                        PersistentStorage.this.logger.log("Done writing object " + obj + " under id " + id.toStringFull() + " in root " + PersistentStorage.this.appDirectory);
                    }
                    if (PersistentStorage.this.getUsedSpace() + PersistentStorage.getFileLength(transcFile) > PersistentStorage.this.getStorageSize()) {
                        throw new OutofDiskSpaceException();
                    }
                }
                catch (Exception e) {
                    if (PersistentStorage.this.logger.level <= 900) {
                        PersistentStorage.this.logger.logException("", e);
                    }
                    PersistentStorage.deleteFile(transcFile);
                    throw e;
                }
                if (PersistentStorage.this.logger.level <= 400) {
                    PersistentStorage.this.logger.log("COUNT: Storing data of class " + obj.getClass().getName() + " under " + id.toStringFull() + " of size " + transcFile.length() + " in " + PersistentStorage.this.name);
                }
                PersistentStorage.this.decreaseUsedSpace(PersistentStorage.getFileLength(objFile));
                PersistentStorage.this.increaseUsedSpace(PersistentStorage.getFileLength(transcFile));
                PersistentStorage.renameFile(transcFile, objFile);
                if (PersistentStorage.this.index) {
                    ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                    synchronized (reverseTreeMap) {
                        PersistentStorage.this.metadata.put(id, metadata);
                        PersistentStorage.this.dirty.add(objFile.getParentFile());
                    }
                }
                PersistentStorage.this.checkDirectory(objFile.getParentFile());
                return Boolean.TRUE;
            }
        });
    }

    public void unstore(final Id id, Continuation c) {
        this.printStats();
        this.environment.getProcessor().processBlockingIO(new WorkRequest(c, this.environment.getSelectorManager()){

            public String toString() {
                return "unstore " + id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doWork() throws Exception {
                Object object = PersistentStorage.this.statLock;
                synchronized (object) {
                    PersistentStorage.this.numDeletes++;
                }
                File objFile = PersistentStorage.this.getFile(id);
                if (PersistentStorage.this.logger.level <= 400) {
                    PersistentStorage.this.logger.log("COUNT: Unstoring data under " + id.toStringFull() + " of size " + objFile.length() + " in " + PersistentStorage.this.name);
                }
                if (PersistentStorage.this.index) {
                    ReverseTreeMap reverseTreeMap = PersistentStorage.this.metadata;
                    synchronized (reverseTreeMap) {
                        PersistentStorage.this.metadata.remove(id);
                        PersistentStorage.this.dirty.add(objFile.getParentFile());
                    }
                }
                if (objFile == null || !objFile.exists()) {
                    return Boolean.FALSE;
                }
                PersistentStorage.this.decreaseUsedSpace(objFile.length());
                PersistentStorage.deleteFile(objFile);
                return Boolean.TRUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Id id) {
        if (this.index) {
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return this.metadata.containsKey(id);
            }
        }
        throw new UnsupportedOperationException("exists() not supported without indexing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdSet scan(IdRange range) {
        if (this.index) {
            if (range.isEmpty()) {
                return this.factory.buildIdSet();
            }
            if (range.getCCWId().equals(range.getCWId())) {
                return this.scan();
            }
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return this.factory.buildIdSet(new ImmutableSortedMap(this.metadata.keySubMap(range.getCCWId(), range.getCWId())));
            }
        }
        throw new UnsupportedOperationException("scan() not supported without indexing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdSet scan() {
        if (this.index) {
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return this.factory.buildIdSet(new ImmutableSortedMap(this.metadata.keyMap()));
            }
        }
        throw new UnsupportedOperationException("scan() not supported without indexing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap scanMetadata(IdRange range) {
        if (this.index) {
            if (range.isEmpty()) {
                return new RedBlackMap();
            }
            if (range.getCCWId().equals(range.getCWId())) {
                return this.scanMetadata();
            }
            ReverseTreeMap reverseTreeMap = this.metadata;
            synchronized (reverseTreeMap) {
                return new ImmutableSortedMap(this.metadata.keySubMap(range.getCCWId(), range.getCWId()));
            }
        }
        throw new UnsupportedOperationException("scanMetadata() not supported without indexing");
    }

    public SortedMap scanMetadata() {
        if (this.index) {
            return new ImmutableSortedMap(this.metadata.keyMap());
        }
        throw new UnsupportedOperationException("scanMetadata() not supported without indexing");
    }

    public SortedMap scanMetadataValuesHead(Object value) {
        if (this.index) {
            return new ImmutableSortedMap(this.metadata.valueHeadMap(value));
        }
        throw new UnsupportedOperationException("scanMetadataValuesHead() not supported without indexing");
    }

    public SortedMap scanMetadataValuesNull() {
        if (this.index) {
            return new ImmutableSortedMap(this.metadata.valueNullMap());
        }
        throw new UnsupportedOperationException("scanMetadataValuesNull() not supported without indexing");
    }

    public void flush(Continuation c) {
        this.environment.getProcessor().processBlockingIO(new WorkRequest(c, this.environment.getSelectorManager()){

            public String toString() {
                return "flush";
            }

            public Object doWork() throws Exception {
                if (PersistentStorage.this.logger.level <= 400) {
                    PersistentStorage.this.logger.log("COUNT: Flushing all data in " + PersistentStorage.this.name);
                }
                PersistentStorage.this.flushDirectory(PersistentStorage.this.appDirectory);
                return Boolean.TRUE;
            }
        });
    }

    private void init() throws IOException {
        if (this.logger.level <= 800) {
            this.logger.log("Initing directories");
        }
        this.initDirectories();
        if (this.logger.level <= 800) {
            this.logger.log("Initing directory map");
        }
        this.initDirectoryMap(this.appDirectory);
        if (this.logger.level <= 800) {
            this.logger.log("Initing files");
        }
        this.initFiles(this.appDirectory);
        if (this.logger.level <= 800) {
            this.logger.log("Initing file map");
        }
        this.initFileMap(this.appDirectory);
        if (this.logger.level <= 800) {
            this.logger.log("Syncing metadata");
        }
        if (this.index) {
            this.writeDirty();
        }
        if (this.logger.level <= 800) {
            this.logger.log("Done initing");
        }
    }

    private void initDirectories() throws IOException {
        this.rootDirectory = new File(this.rootDir);
        PersistentStorage.createDirectory(this.rootDirectory);
        this.backupDirectory = new File(this.rootDirectory, BACKUP_DIRECTORY);
        PersistentStorage.createDirectory(this.backupDirectory);
        this.appDirectory = new File(this.backupDirectory, this.getName());
        PersistentStorage.createDirectory(this.appDirectory);
        this.lostDirectory = new File(this.backupDirectory, LOST_AND_FOUND_DIRECTORY);
        PersistentStorage.createDirectory(this.lostDirectory);
    }

    private void initDirectoryMap(File dir) {
        File[] files = dir.listFiles(new DirectoryFilter());
        this.directories.put(dir, files);
        for (int i = 0; i < files.length; ++i) {
            this.initDirectoryMap(files[i]);
        }
    }

    private void initFiles(File dir) throws IOException {
        int i;
        String[] dirs = dir.list(new DirectoryFilter());
        String[] files = dir.list(new FileFilter());
        for (i = 0; i < files.length; ++i) {
            try {
                if (this.initTemporaryFile(dir, files[i]) || dirs.length <= 0) continue;
                this.moveFileToCorrectDirectory(dir, files[i]);
                continue;
            }
            catch (Exception e) {
                if (this.logger.level <= 900) {
                    this.logger.logException("Got exception " + e + " initting file " + files[i] + " - moving to lost+found.", e);
                }
                this.moveToLost(new File(dir, files[i]));
            }
        }
        for (i = 0; i < dirs.length; ++i) {
            this.initFiles(new File(dir, dirs[i]));
        }
        if (dirs.length > 0) {
            PersistentStorage.deleteFile(new File(dir, METADATA_FILENAME));
        }
    }

    private boolean initTemporaryFile(File parent, String name) throws IOException {
        if (!this.isTemporaryFile(name)) {
            return false;
        }
        this.moveToLost(new File(parent, name));
        return true;
    }

    private void initFileMap(File dir) throws IOException {
        int i;
        long modified;
        block13: {
            if (this.logger.level <= 500) {
                this.logger.log("Initting directory " + dir);
            }
            this.checkDirectory(dir);
            if (!dir.exists()) {
                return;
            }
            modified = 0L;
            if (this.index) {
                try {
                    modified = this.readMetadataFile(dir);
                }
                catch (IOException e) {
                    if (this.logger.level > 1000) break block13;
                    this.logger.logException("Got exception " + e + " reading metadata file - regenerating", e);
                }
            }
        }
        File[] files = dir.listFiles(new FileFilter());
        File[] dirs = dir.listFiles(new DirectoryFilter());
        for (i = 0; i < files.length; ++i) {
            try {
                Id id = this.readKey(files[i]);
                long len = PersistentStorage.getFileLength(files[i]);
                if (id == null && this.logger.level <= 800) {
                    this.logger.log("READING " + files[i] + " RETURNED NULL!");
                }
                if (len > 0L) {
                    this.increaseUsedSpace(len);
                    if (!this.index || this.metadata.containsKey(id) && files[i].lastModified() <= modified) continue;
                    if (this.logger.level <= 400) {
                        this.logger.log("Reading newer metadata out of file " + files[i] + " id " + id.toStringFull() + " " + files[i].lastModified() + " " + modified + " " + this.metadata.containsKey(id));
                    }
                    this.metadata.put(id, this.readMetadata(files[i]));
                    this.dirty.add(dir);
                    continue;
                }
                this.moveToLost(files[i]);
                if (!this.index || !this.metadata.containsKey(id)) continue;
                this.metadata.remove(id);
                this.dirty.add(dir);
                continue;
            }
            catch (Exception e) {
                if (this.logger.level <= 900) {
                    this.logger.logException("ERROR: Received Exception " + e + " while initing file " + files[i] + " - moving to lost+found.", e);
                }
                this.moveToLost(files[i]);
            }
        }
        for (i = 0; i < dirs.length; ++i) {
            this.initFileMap(dirs[i]);
        }
        this.checkDirectory(dir);
    }

    private void resolveConflict(File file1, File file2, File output) throws IOException {
        if (!file2.exists()) {
            PersistentStorage.renameFile(file1, output);
        } else if (!file1.exists()) {
            PersistentStorage.renameFile(file2, output);
        } else if (file1.equals(file2)) {
            PersistentStorage.renameFile(file1, output);
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("resolving conflict between " + file1 + " and " + file2);
            }
            if (PersistentStorage.readVersion(file1) < PersistentStorage.readVersion(file2)) {
                this.moveToLost(file1);
                PersistentStorage.renameFile(file2, output);
            } else {
                this.moveToLost(file2);
                PersistentStorage.renameFile(file1, output);
            }
        }
    }

    private void moveToLost(File file) throws IOException {
        PersistentStorage.renameFile(file, new File(this.lostDirectory, this.getPrefix(file.getParentFile()) + file.getName()));
    }

    private boolean checkDirectory(File directory) throws IOException {
        int files = this.numFilesDir(directory);
        int dirs = this.numDirectoriesDir(directory);
        if (this.logger.level <= 500) {
            this.logger.log("Checking directory " + directory + " for oversize " + files + "/" + dirs);
        }
        if (files > 256) {
            this.expandDirectory(directory);
            return true;
        }
        if (dirs > 32) {
            this.reformatDirectory(directory);
            return true;
        }
        if (files == 0 && dirs == 0 && !directory.equals(this.appDirectory)) {
            this.pruneDirectory(directory);
            return true;
        }
        return false;
    }

    private void pruneDirectory(File dir) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("Pruning directory " + dir + " due to emptiness");
        }
        PersistentStorage.deleteFile(new File(dir, METADATA_FILENAME));
        PersistentStorage.deleteDirectory(dir);
        this.directories.remove(dir);
        this.prefixes.remove(dir);
        this.directories.put(dir.getParentFile(), dir.getParentFile().listFiles(new DirectoryFilter()));
    }

    private void reformatDirectory(File dir) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("Expanding directory " + dir + " due to too many subdirectories");
        }
        String[] newDirNames = this.getDirectories(dir.list(new DirectoryFilter()));
        this.reformatDirectory(dir, newDirNames);
        if (this.logger.level <= 500) {
            this.logger.log("Done expanding directory " + dir);
        }
    }

    private void reformatDirectory(File dir, String[] newDirNames) throws IOException {
        String[] dirNames = dir.list(new DirectoryFilter());
        File[] newDirs = new File[newDirNames.length];
        for (int i = 0; i < newDirNames.length; ++i) {
            newDirs[i] = new File(dir, newDirNames[i]);
            PersistentStorage.createDirectory(newDirs[i]);
            if (this.logger.level <= 500) {
                this.logger.log("Creating directory " + newDirNames[i]);
            }
            String[] subDirNames = this.getMatchingDirectories(newDirNames[i], dirNames);
            File[] newSubDirs = new File[subDirNames.length];
            for (int j = 0; j < subDirNames.length; ++j) {
                File oldDir = new File(dir, subDirNames[j]);
                newSubDirs[j] = new File(newDirs[i], subDirNames[j].substring(newDirNames[i].length()));
                if (this.logger.level <= 500) {
                    this.logger.log("Moving the old direcotry " + oldDir + " to " + newSubDirs[j]);
                }
                PersistentStorage.renameFile(oldDir, newSubDirs[j]);
                this.directories.remove(oldDir);
                this.directories.put(newSubDirs[j], new File[0]);
            }
            this.directories.put(newDirs[i], newSubDirs);
        }
        this.directories.put(dir, newDirs);
    }

    private void expandDirectory(File dir) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("Expanding directory " + dir + " due to too many files");
        }
        String[] fileNames = dir.list(new FileFilter());
        String[] dirNames = this.getDirectories(fileNames);
        File[] dirs = new File[dirNames.length];
        for (int i = 0; i < dirNames.length; ++i) {
            dirs[i] = new File(dir, dirNames[i]);
            this.directories.put(dirs[i], new File[0]);
            if (dirs[i].exists() && dirs[i].isFile()) {
                PersistentStorage.renameFile(dirs[i], new File(dir, dirs[i].getName() + ZERO_LENGTH_NAME));
            }
            PersistentStorage.createDirectory(dirs[i]);
            if (this.logger.level <= 500) {
                this.logger.log("Creating directory " + dirNames[i]);
            }
            if (!this.index) continue;
            this.dirty.add(dirs[i]);
        }
        this.directories.put(dir, dirs);
        File[] files = dir.listFiles(new FileFilter());
        block1: for (int i = 0; i < files.length; ++i) {
            for (int j = 0; j < dirs.length; ++j) {
                if (!files[i].getName().startsWith(dirs[j].getName())) continue;
                if (this.logger.level <= 300) {
                    this.logger.log("Renaming file " + files[i] + " to " + new File(dirs[j], files[i].getName().substring(dirs[j].getName().length())));
                }
                PersistentStorage.renameFile(files[i], new File(dirs[j], files[i].getName().substring(dirs[j].getName().length())));
                continue block1;
            }
        }
        PersistentStorage.deleteFile(new File(dir, METADATA_FILENAME));
        if (this.logger.level <= 500) {
            this.logger.log("Done expanding directory " + dir);
        }
    }

    private void moveFileToCorrectDirectory(File parent, String name) throws IOException {
        File file = new File(parent, name);
        Id id = this.readKeyFromFile(file);
        File dest = this.getDirectoryForId(id);
        if (!dest.equals(parent)) {
            if (this.logger.level <= 500) {
                this.logger.log("moving file " + file + " to correct directory " + dest + " from " + parent);
            }
            File other = new File(dest, id.toStringFull().substring(this.getPrefix(dest).length()));
            this.resolveConflict(file, other, other);
            this.checkDirectory(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDirectory(File dir) throws IOException {
        if (this.logger.level <= 500) {
            this.logger.log("Flushing file " + dir);
        }
        if (!dir.isDirectory()) {
            Id id = this.readKey(dir);
            if (this.index) {
                ReverseTreeMap reverseTreeMap = this.metadata;
                synchronized (reverseTreeMap) {
                    this.metadata.remove(id);
                }
            }
            this.decreaseUsedSpace(dir.length());
            PersistentStorage.deleteFile(dir);
        } else {
            File[] dirs = dir.listFiles();
            for (int i = 0; i < dirs.length; ++i) {
                this.flushDirectory(dirs[i]);
                this.directories.remove(dirs[i]);
                this.prefixes.remove(dirs[i]);
                PersistentStorage.deleteFile(dirs[i]);
            }
        }
    }

    private File makeTemporaryFile(Id id) throws IOException {
        File directory = this.getDirectoryForId(id);
        File file = new File(directory, id.toStringFull().substring(this.getPrefix(directory).length()) + "." + this.environment.getRandomSource().nextInt() % 100);
        while (file.exists()) {
            file = new File(directory, id.toStringFull().substring(this.getPrefix(directory).length()) + "." + this.environment.getRandomSource().nextInt() % 100);
        }
        return file;
    }

    private File[] append(File[] files, File file) {
        File[] result = new File[files.length + 1];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i];
        }
        result[files.length] = file;
        return result;
    }

    private int numDirectoriesDir(File dir) {
        return dir.listFiles(new DirectoryFilter()).length;
    }

    private int numFilesDir(File dir) {
        return dir.listFiles(new FileFilter()).length;
    }

    private boolean containsDir(File dir) {
        return dir.listFiles(new DirectoryFilter()).length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDirty() {
        File[] files = this.dirty.toArray(new File[0]);
        for (int i = 0; i < files.length; ++i) {
            Serializable next;
            HashMap<Id, Object> map = new HashMap<Id, Object>();
            IdRange range = this.getRangeForDirectory(files[i]);
            Iterator keys = null;
            keys = range.getCCWId().compareTo(range.getCWId()) <= 0 ? this.metadata.keySubMap(range.getCCWId(), range.getCWId()).keySet().iterator() : this.metadata.keyTailMap(range.getCCWId()).keySet().iterator();
            while (keys.hasNext()) {
                next = (Id)keys.next();
                map.put((Id)next, this.metadata.get(next));
            }
            try {
                PersistentStorage.writeMetadataFile(files[i], map);
                next = this.metadata;
                synchronized (next) {
                    this.dirty.remove(files[i]);
                    continue;
                }
            }
            catch (FileNotFoundException f) {
                try {
                    ReverseTreeMap reverseTreeMap = this.metadata;
                    synchronized (reverseTreeMap) {
                        this.dirty.remove(files[i]);
                    }
                    if (this.logger.level > 900) continue;
                    this.logger.logException("ERROR: Could not find directory while writing out metadata in '" + files[i].getCanonicalPath() + "' - removing from dirty list and continuing!", f);
                }
                catch (IOException g) {
                    if (this.logger.level > 1000) continue;
                    this.logger.logException("PANIC: Got IOException " + g + " trying to detail FNF exception " + f + " while writing out file " + files[i], g);
                }
                continue;
            }
            catch (IOException e) {
                try {
                    if (this.logger.level > 900) continue;
                    this.logger.logException("ERROR: Got error " + e + " while writing out metadata in '" + files[i].getCanonicalPath() + "' - aborting!", e);
                    continue;
                }
                catch (IOException f) {
                    if (this.logger.level > 1000) continue;
                    this.logger.logException("PANIC: Got IOException " + f + " trying to detail exception " + e + " while writing out file " + files[i], f);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long readMetadataFile(File file) throws IOException {
        File metadata = new File(file, METADATA_FILENAME);
        if (!metadata.exists()) {
            return -1L;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(metadata);
            ObjectInputStream objin = new ObjectInputStream(new BufferedInputStream(fin));
            IdRange range = this.getRangeForDirectory(file);
            try {
                HashMap map = (HashMap)objin.readObject();
                for (Id id : map.keySet()) {
                    if (range.containsId(id) && new File(file, id.toStringFull().substring(this.getPrefix(file).length())).exists()) {
                        this.metadata.put(id, map.get(id));
                        continue;
                    }
                    this.dirty.add(file);
                }
                long l = metadata.lastModified();
                return l;
            }
            catch (ClassNotFoundException e) {
                if (this.logger.level <= 900) {
                    this.logger.logException("ERROR: Got exception " + e + " while reading metadata file " + metadata + " - rebuilding file", e);
                }
                PersistentStorage.deleteFile(metadata);
                long l = 0L;
                fin.close();
                return l;
            }
            catch (IOException e) {
                if (this.logger.level <= 900) {
                    this.logger.logException("ERROR: Got exception " + e + " while reading metadata file " + metadata + " - rebuilding file", e);
                }
                PersistentStorage.deleteFile(metadata);
                long l = 0L;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                fin.close();
                return l;
            }
        }
        finally {
            fin.close();
        }
    }

    /*
     * Exception decompiling
     */
    private Serializable readMetadata(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Id readKey(File file) {
        String s = this.getPrefix(file.getParentFile()) + file.getName().replaceAll(ZERO_LENGTH_NAME, "");
        if (s.indexOf(".") >= 0) {
            return this.factory.buildIdFromToString(s.toCharArray(), 0, s.indexOf("."));
        }
        return this.factory.buildIdFromToString(s.toCharArray(), 0, s.length());
    }

    private Id readKeyFromFile(File file) throws IOException {
        return (Id)PersistentStorage.readObject(file, 0);
    }

    private void increaseUsedSpace(long i) {
        this.usedSize += i;
    }

    private void decreaseUsedSpace(long i) {
        this.usedSize -= i;
    }

    private static long getFileLength(File file) {
        return file != null && file.exists() ? file.length() : 0L;
    }

    private static void createDirectory(File directory) throws IOException {
        if (directory == null || directory.exists() && directory.isFile() || !directory.exists() && !directory.mkdir()) {
            throw new IOException("Creation of directory " + directory + " failed!");
        }
    }

    private static void deleteDirectory(File directory) throws IOException {
        if (directory != null && directory.exists()) {
            if (directory.listFiles().length > 0) {
                throw new IOException("Cannot delete " + directory + " - directory is not empty!");
            }
            if (!directory.delete()) {
                throw new IOException("Deletion of directory " + directory + " failed!");
            }
        }
    }

    private static void renameFile(File oldFile, File newFile) throws IOException {
        if (oldFile != null && oldFile.exists() && !oldFile.equals(newFile)) {
            PersistentStorage.deleteFile(newFile);
            if (!oldFile.renameTo(newFile)) {
                throw new IOException("Rename of " + oldFile + " to " + newFile + " failed!");
            }
        }
    }

    private static void deleteFile(File file) throws IOException {
        if (file != null && file.exists() && !file.delete()) {
            throw new IOException("Delete of " + file + " failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMetadataFile(File file, HashMap map) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(file, METADATA_FILENAME));
            ObjectOutputStream objout = new ObjectOutputStream(new BufferedOutputStream(fout));
            objout.writeObject(map);
            objout.close();
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    private static Serializable readObject(File file, int offset) throws IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            XMLObjectInputStream objin = new XMLObjectInputStream(new BufferedInputStream(new GZIPInputStream(fin)));
            for (int i = 0; i < offset; ++i) {
                objin.readObject();
            }
            Serializable serializable = (Serializable)objin.readObject();
            return serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            fin.close();
        }
    }

    private static Serializable readData(File file) throws IOException {
        return PersistentStorage.readObject(file, 1);
    }

    private static long readVersion(File file) throws IOException {
        Long temp = (Long)PersistentStorage.readObject(file, 2);
        return temp == null ? 0L : temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeObject(Serializable obj, Serializable metadata, Id key, long version, File file) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            XMLObjectOutputStream objout = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(fout)));
            objout.writeObject(key);
            objout.writeObject(obj);
            objout.writeObject(new Long(version));
            ((ObjectOutputStream)objout).close();
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
        long len1 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            XMLObjectOutputStream objout = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(fout)));
            objout.writeObject(metadata);
            ((ObjectOutputStream)objout).close();
        }
        finally {
            fout.close();
        }
        long len2 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            DataOutputStream dos = new DataOutputStream(fout);
            dos.writeLong(8038844221L);
            dos.writeLong(2L);
            dos.writeLong(1L);
            dos.writeLong(len2 - len1);
            dos.close();
        }
        finally {
            fout.close();
        }
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMetadata(File file, Serializable metadata) throws IOException {
        RandomAccessFile ras = null;
        FileOutputStream fout = null;
        if (file.length() > 32L) {
            try {
                ras = new RandomAccessFile(file, "rw");
                ras.seek(file.length() - 32L);
                if (ras.readLong() == 8038844221L && ras.readLong() == 2L && ras.readLong() <= 1L) {
                    long length = ras.readLong();
                    ras.setLength(file.length() - 32L - length);
                }
            }
            finally {
                ras.close();
            }
        }
        long len1 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            XMLObjectOutputStream objout = new XMLObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(fout)));
            objout.writeObject(metadata);
            ((ObjectOutputStream)objout).close();
        }
        finally {
            fout.close();
        }
        long len2 = file.length();
        try {
            fout = new FileOutputStream(file, true);
            DataOutputStream dos = new DataOutputStream(fout);
            dos.writeLong(8038844221L);
            dos.writeLong(2L);
            dos.writeLong(1L);
            dos.writeLong(len2 - len1);
            dos.close();
        }
        finally {
            fout.close();
        }
    }

    private static class OutofDiskSpaceException
    extends PersistenceException {
        private OutofDiskSpaceException() {
        }
    }

    private static class PersistenceException
    extends Exception {
        private PersistenceException() {
        }
    }

    private class CharacterHashSet {
        protected boolean[] bitMap = new boolean[256];

        private CharacterHashSet() {
        }

        public char[] get() {
            int[] nums = this.getOffsets();
            char[] result = new char[nums.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (char)nums[i];
            }
            return result;
        }

        private int[] getOffsets() {
            int[] result = new int[this.count()];
            boolean index = false;
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.getOffset(i);
            }
            return result;
        }

        private int getOffset(int index) {
            int location = 0;
            while (index > 0) {
                if (this.bitMap[location]) {
                    --index;
                }
                ++location;
            }
            while (!this.bitMap[location]) {
                ++location;
            }
            return location;
        }

        public void put(char a) {
            this.bitMap[a] = true;
        }

        public boolean contains(char a) {
            return this.bitMap[a];
        }

        public void remove(char a) {
            this.bitMap[a] = false;
        }

        private int count() {
            int total = 0;
            for (int i = 0; i < this.bitMap.length; ++i) {
                if (!this.bitMap[i]) continue;
                ++total;
            }
            return total;
        }
    }

    private class FileFilter
    implements FilenameFilter {
        private FileFilter() {
        }

        public boolean accept(File dir, String name) {
            return PersistentStorage.this.isFile(dir, name);
        }
    }

    private class DirectoryFilter
    implements FilenameFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File dir, String name) {
            return PersistentStorage.this.isDirectory(dir, name);
        }
    }
}

