/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.environment.Environment;
import rice.environment.random.RandomSource;
import rice.pastry.Id;
import rice.pastry.NodeId;

public class NodeIdUnit {
    private NodeId nid;
    private RandomSource rng;

    public NodeIdUnit() {
        Environment env = new Environment();
        this.rng = env.getRandomSource();
        System.out.println("Creating nid");
        this.nid = this.createNodeId();
        this.equalityTest();
        this.distanceTest();
        this.baseFiddlingTest();
        this.msdTest();
        this.alternateTest();
        this.domainPrefixTest();
    }

    public NodeId createNodeId() {
        int i;
        byte[] raw = new byte[20];
        this.rng.nextBytes(raw);
        NodeId nodeId = NodeId.buildNodeId(raw);
        System.out.println("created node " + nodeId);
        byte[] copy = new byte[raw.length];
        nodeId.blit(copy);
        for (i = 0; i < raw.length; ++i) {
            if (copy[i] == raw[i]) continue;
            System.out.println("blit test failed!");
        }
        copy = nodeId.copy();
        for (i = 0; i < raw.length; ++i) {
            if (copy[i] == raw[i]) continue;
            System.out.println("copy test failed!");
        }
        return nodeId;
    }

    public void equalityTest() {
        System.out.println("--------------------------");
        System.out.println("Creating oth");
        NodeId oth = this.createNodeId();
        if (!this.nid.equals(oth)) {
            System.out.println("not equal - as expected.");
        } else {
            System.out.println("ALERT: equal - warning this happens with very low probability");
        }
        if (this.nid.equals(this.nid)) {
            System.out.println("equality seems reflexive.");
        } else {
            System.out.println("ALERT: equality is not reflexive.");
        }
        System.out.println("hash code of nid: " + this.nid.hashCode());
        System.out.println("hash code of oth: " + oth.hashCode());
        System.out.println("--------------------------");
    }

    public void distanceTest() {
        System.out.println("--------------------------");
        System.out.println("creating a and b respectively");
        NodeId a = this.createNodeId();
        NodeId b = this.createNodeId();
        for (int i = 0; i < 100; ++i) {
            Id.Distance adist = this.nid.distance(a);
            Id.Distance adist2 = a.distance(this.nid);
            Id.Distance bdist = this.nid.distance(b);
            System.out.println("adist =" + adist + "\n bdist=" + bdist);
            if (adist.equals(adist2)) {
                System.out.println("distance seems reflexive");
            } else {
                System.out.println("ALERT: distance is non-reflexive.");
            }
            if (adist.equals(bdist)) {
                System.out.println("ALERT: nodes seem at equal distance - very unlikely");
            } else {
                System.out.println("nodes have different distance as expected.");
            }
            System.out.println("result of comparison with a and b " + adist.compareTo(bdist));
            System.out.println("result of comparison with a to itself " + adist.compareTo(adist2));
            if (a.clockwise(b)) {
                System.out.println("b is clockwise from a");
            } else {
                System.out.println("b is counter-clockwise from a");
            }
            Id.Distance abs = a.distance(b);
            Id.Distance abl = a.longDistance(b);
            if (abs.compareTo(abl) != -1) {
                System.out.println("ERROR: abs.compareTo(abl)=" + abs.compareTo(abl));
            }
            System.out.println("abs=" + abs);
            abs.shift(-1, 1);
            System.out.println("abs.shift(-1)=" + abs);
            abs.shift(1, 0);
            System.out.println("abs.shift(1)=" + abs);
            if (!abs.equals(a.distance(b))) {
                System.out.println("SHIFT ERROR!");
            }
            a = this.createNodeId();
            b = this.createNodeId();
        }
        byte[] raw0 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] raw80 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128};
        byte[] raw7f = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 127};
        byte[] t1 = new byte[]{98, -84, 10, 109, 38, 58, -21, -79, -28, -114, 37, -14, -27, 14, -94, 19};
        byte[] t2 = new byte[]{58, 63, -6, -126, 0, -111, -5, -126, -99, -46, -40, 66, -122, 64, 93, -41};
        a = NodeId.buildNodeId(t1);
        b = NodeId.buildNodeId(t2);
        NodeId n0 = NodeId.buildNodeId(raw0);
        NodeId n7f = NodeId.buildNodeId(raw7f);
        NodeId n80 = NodeId.buildNodeId(raw80);
        NodeId c = n0;
        System.out.println("a=" + a + "b=" + b + "c=" + c);
        System.out.println("a.clockwise(b)=" + a.clockwise(b));
        System.out.println("a.clockwise(a)=" + a.clockwise(a));
        System.out.println("b.clockwise(b)=" + b.clockwise(b));
        if (a.clockwise(c)) {
            System.out.println("c is clockwise from a");
        } else {
            System.out.println("c is counter-clockwise from a");
        }
        if (b.clockwise(c)) {
            System.out.println("c is clockwise from b");
        } else {
            System.out.println("c is counter-clockwise from b");
        }
        System.out.println("a.distance(b)" + a.distance(b) + "b.distance(a)=" + b.distance(a));
        System.out.println("a.longDistance(b)" + a.longDistance(b) + "b.longDistance(a)=" + b.longDistance(a));
        System.out.println("a.distance(a)" + a.distance(a) + "a.longDistance(a)=" + a.longDistance(a));
        System.out.println("a.isBetween(a,n7f)=" + a.isBetween(a, n7f));
        System.out.println("a.isBetween(n0,a)=" + a.isBetween(n0, a));
        System.out.println("a.isBetween(n0,n7f)=" + a.isBetween(n0, n7f));
        System.out.println("b.isBetween(n0,n80)=" + b.isBetween(n0, n80));
        System.out.println("a.isBetween(a,n80)=" + a.isBetween(a, n80));
        System.out.println("b.isBetween(n0,b)=" + b.isBetween(n0, b));
        System.out.println("--------------------------");
    }

    public void baseFiddlingTest() {
        System.out.println("--------------------------");
        String bitRep = "";
        for (int i = 0; i < 160; ++i) {
            bitRep = this.nid.checkBit(i) ? bitRep + "1" : bitRep + "0";
        }
        System.out.println(bitRep);
        String digRep = "";
        for (int i = 0; i < 160; ++i) {
            digRep = digRep + this.nid.getDigit(i, 1);
        }
        System.out.println(digRep);
        if (bitRep.equals(digRep)) {
            System.out.println("strings the same - as expected");
        } else {
            System.out.println("ALERT: strings differ - this is wrong.");
        }
        System.out.println("--------------------------");
    }

    public void msdTest() {
        System.out.println("--------------------------");
        System.out.println("creating a and b respectively");
        NodeId a = this.createNodeId();
        NodeId b = this.createNodeId();
        Id.Distance adist = this.nid.distance(a);
        Id.Distance bdist = this.nid.distance(b);
        Id.Distance aldist = this.nid.longDistance(a);
        Id.Distance bldist = this.nid.longDistance(b);
        System.out.println("nid.dist(a)=" + adist);
        System.out.println("nid.longDist(a)=" + aldist);
        System.out.println("nid.dist(b)=" + bdist);
        System.out.println("nid.longDist(b)=" + bldist);
        System.out.println("adist.compareTo(bdist) " + adist.compareTo(bdist));
        System.out.println("aldist.compareTo(bldist) " + aldist.compareTo(bldist));
        System.out.println("msdb a and nid " + this.nid.indexOfMSDB(a));
        System.out.println("msdb b and nid " + this.nid.indexOfMSDB(b));
        if (this.nid.indexOfMSDB(a) == a.indexOfMSDB(this.nid)) {
            System.out.println("msdb is symmetric");
        } else {
            System.out.println("ALERT: msdb is not symmetric");
        }
        for (int i = 2; i <= 6; ++i) {
            int msdd = this.nid.indexOfMSDD(a, i);
            System.out.println("msdd a and nid (base " + (1 << i) + ") " + msdd + " val=" + a.getDigit(msdd, i) + "," + this.nid.getDigit(msdd, i));
            msdd = this.nid.indexOfMSDD(b, i);
            System.out.println("msdd b and nid (base " + (1 << i) + ") " + msdd + " val=" + b.getDigit(msdd, i) + "," + this.nid.getDigit(msdd, i));
        }
        System.out.println("--------------------------");
    }

    public void alternateTest() {
        System.out.println("--------------------------");
        System.out.println("nid=" + this.nid);
        for (int b = 2; b < 7; ++b) {
            for (int num = 2; num <= 1 << b; num *= 2) {
                for (int i = 1; i < num; ++i) {
                    System.out.println("alternate (b=" + b + ") " + i + ":" + this.nid.getAlternateId(num, b, i));
                }
            }
        }
        System.out.println("--------------------------");
    }

    public void domainPrefixTest() {
        System.out.println("--------------------------");
        System.out.println("nid=" + this.nid);
        for (int b = 2; b < 7; ++b) {
            for (int row = 160 / b - 1; row >= 0; --row) {
                for (int col = 0; col < 1 << b; ++col) {
                    Id domainFirst = this.nid.getDomainPrefix(row, col, 0, b);
                    Id domainLast = this.nid.getDomainPrefix(row, col, -1, b);
                    System.out.println("prefixes " + this.nid + domainFirst + domainLast);
                    int cmp = domainFirst.compareTo(domainLast);
                    boolean equal = domainFirst.equals(domainLast);
                    if (cmp == 0 != equal) {
                        System.out.println("ERROR, compareTo=" + cmp + " equal=" + equal);
                    }
                    if (cmp != 1) continue;
                    System.out.println("ERROR, compareTo=" + cmp);
                }
            }
        }
        System.out.println("--------------------------");
    }

    public static void main(String[] args) {
        NodeIdUnit niu = new NodeIdUnit();
    }
}

