/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.NoSuchElementException;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.HelloWorldApp;

public class HelloWorld {
    private PastryNodeFactory factory;
    private NetworkSimulator simulator;
    private Vector pastryNodes;
    private Vector helloClients;
    Environment environment;
    private static int numnodes = 3;
    private static int nummsgs = 30;
    private static boolean simultaneous_joins = false;
    private static boolean simultaneous_msgs = false;

    public HelloWorld(Environment env) {
        this.environment = env;
        this.simulator = new EuclideanNetwork(env);
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(this.environment), this.simulator, this.environment);
        this.pastryNodes = new Vector();
        this.helloClients = new Vector();
    }

    private NodeHandle getBootstrap() {
        NodeHandle bootstrap = null;
        try {
            PastryNode lastnode = (PastryNode)this.pastryNodes.lastElement();
            bootstrap = lastnode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return bootstrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePastryNode() {
        PastryNode pn = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pn);
        HelloWorldApp app = new HelloWorldApp(pn);
        this.helloClients.addElement(app);
        PastryNode pastryNode = pn;
        synchronized (pastryNode) {
            while (!pn.isReady()) {
                try {
                    pn.wait(300L);
                }
                catch (InterruptedException ie) {}
            }
        }
        System.out.println("created " + pn);
    }

    private void printLeafSets() {
        for (int i = 0; i < this.pastryNodes.size(); ++i) {
            PastryNode pn = (PastryNode)this.pastryNodes.get(i);
            System.out.println(pn.getLeafSet().toString());
        }
    }

    private void sendRandomMessage() {
        int n = this.helloClients.size();
        int client = this.environment.getRandomSource().nextInt(n);
        HelloWorldApp app = (HelloWorldApp)this.helloClients.get(client);
        app.sendRndMsg(this.environment.getRandomSource());
    }

    private boolean simulate() {
        return false;
    }

    private static void doIinitstuff(String[] args, Environment env) {
        int i;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-verbosity") || i + 1 >= args.length) continue;
            int num = Integer.parseInt(args[i + 1]);
            env.getParameters().setInt("loglevel", num * 100);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-silent") || i + 1 >= args.length) continue;
            env.getParameters().setInt("loglevel", 1000);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("-verbose") || i + 1 >= args.length) continue;
            env.getParameters().setInt("loglevel", Integer.MIN_VALUE);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-nodes") && i + 1 < args.length) {
                numnodes = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-msgs") && i + 1 < args.length) {
                nummsgs = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-simultaneous_joins")) {
                simultaneous_joins = true;
            }
            if (args[i].equals("-simultaneous_msgs")) {
                simultaneous_msgs = true;
            }
            if (!args[i].equals("-help")) continue;
            System.out.println("Usage: HelloWorld [-msgs m] [-nodes n] [-verbose|-silent|-verbosity v]");
            System.out.println("                  [-simultaneous_joins] [-simultaneous_msgs] [-help]");
            System.out.println("  Default verbosity is 8, -verbose is 1, and -silent is 10 (error msgs only).");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        int i;
        Environment env = Environment.directEnvironment();
        HelloWorld.doIinitstuff(args, env);
        HelloWorld driver = new HelloWorld(env);
        for (i = 0; i < numnodes; ++i) {
            driver.makePastryNode();
            if (simultaneous_joins) continue;
            while (driver.simulate()) {
            }
        }
        if (simultaneous_joins) {
            System.out.println("let the joins begin!");
            while (driver.simulate()) {
            }
        }
        System.out.println(numnodes + " nodes constructed");
        driver.printLeafSets();
        for (i = 0; i < nummsgs; ++i) {
            driver.sendRandomMessage();
            if (simultaneous_msgs) continue;
            while (driver.simulate()) {
            }
        }
        if (simultaneous_msgs) {
            System.out.println("let the msgs begin!");
            while (driver.simulate()) {
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        env.destroy();
    }
}

