/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RouterAddress;
import rice.pastry.security.PastrySecurityManager;

public class StandardRouter
implements MessageReceiver {
    private PastryNode localNode;
    private PastrySecurityManager security;
    private Address routeAddress;

    public StandardRouter(PastryNode localNode, PastrySecurityManager sm) {
        this.localNode = localNode;
        this.security = sm;
        this.routeAddress = new RouterAddress();
    }

    public Address getAddress() {
        return this.routeAddress;
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            if (!rm.routeMessage(this.localNode.getLocalHandle())) {
                this.receiveRouteMessage(rm);
            }
        } else {
            throw new Error("message " + msg + " bounced at StandardRouter");
        }
    }

    private void receiveRouteMessage(RouteMessage msg) {
        Id target = msg.getTarget();
        if (target == null) {
            target = this.localNode.getNodeId();
        }
        int cwSize = this.localNode.getLeafSet().cwSize();
        int ccwSize = this.localNode.getLeafSet().ccwSize();
        int lsPos = this.localNode.getLeafSet().mostSimilar(target);
        if (lsPos == 0) {
            msg.nextHop = this.localNode.getLocalHandle();
        } else if (lsPos > 0 && (lsPos < cwSize || !this.localNode.getLeafSet().get(lsPos).getNodeId().clockwise(target)) || lsPos < 0 && (-lsPos < ccwSize || this.localNode.getLeafSet().get(lsPos).getNodeId().clockwise(target))) {
            NodeHandle handle = this.localNode.getLeafSet().get(lsPos);
            if (!handle.isAlive()) {
                this.localNode.getLeafSet().remove(handle);
                this.receiveRouteMessage(msg);
                return;
            }
            msg.nextHop = handle;
            msg.getOptions().setRerouteIfSuspected(false);
        } else {
            RouteSet rs = this.localNode.getRoutingTable().getBestEntry(target);
            NodeHandle handle = null;
            if (rs == null || (handle = rs.closestNode(1)) == null) {
                handle = this.localNode.getRoutingTable().bestAlternateRoute(1, target);
                if (handle == null) {
                    handle = this.localNode.getLeafSet().get(lsPos);
                    if (!handle.isAlive()) {
                        this.localNode.getLeafSet().remove(handle);
                        this.receiveRouteMessage(msg);
                        return;
                    }
                    msg.getOptions().setRerouteIfSuspected(false);
                } else {
                    Id.Distance altDist = handle.getNodeId().distance(target);
                    Id.Distance lsDist = this.localNode.getLeafSet().get(lsPos).getNodeId().distance(target);
                    if (lsDist.compareTo(altDist) < 0) {
                        handle = this.localNode.getLeafSet().get(lsPos);
                        if (!handle.isAlive()) {
                            this.localNode.getLeafSet().remove(handle);
                            this.receiveRouteMessage(msg);
                            return;
                        }
                        msg.getOptions().setRerouteIfSuspected(false);
                    }
                }
            } else {
                this.checkForRouteTableHole(msg, handle);
            }
            msg.nextHop = handle;
        }
        msg.setPrevNode(this.localNode.getLocalHandle());
        this.localNode.getLocalHandle().receiveMessage(msg);
    }

    private void checkForRouteTableHole(RouteMessage msg, NodeHandle handle) {
        Id key;
        if (msg.getPrevNode() == null) {
            return;
        }
        NodeId prevId = msg.getPrevNode().getNodeId();
        int diffDigit = prevId.indexOfMSDD(key = msg.getTarget(), this.localNode.getRoutingTable().baseBitLength());
        if (diffDigit == this.localNode.getNodeId().indexOfMSDD(key, this.localNode.getRoutingTable().baseBitLength())) {
            RouteSet[] row = this.localNode.getRoutingTable().getRow(diffDigit);
            BroadcastRouteRow brr = new BroadcastRouteRow(this.localNode.getLocalHandle(), row);
            NodeHandle prevNode = this.security.verifyNodeHandle(msg.getPrevNode());
            if (prevNode.isAlive()) {
                prevNode.receiveMessage(brr);
            }
        }
    }
}

