/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.ArrayList;
import java.util.HashSet;
import rice.environment.logging.Logger;
import rice.pastry.IdSet;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.leafset.RequestLeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class StandardLeafSetProtocol
implements MessageReceiver {
    protected final boolean failstop = true;
    protected NodeHandle localHandle;
    protected PastryNode localNode;
    protected PastrySecurityManager security;
    protected LeafSet leafSet;
    protected RoutingTable routeTable;
    private Address address;
    protected Logger logger;
    HashSet cachedSet = null;

    public StandardLeafSetProtocol(PastryNode ln, NodeHandle local, PastrySecurityManager sm, LeafSet ls, RoutingTable rt) {
        this.localNode = ln;
        this.localHandle = local;
        this.security = sm;
        this.leafSet = ls;
        this.cachedSet = new HashSet(this.leafSet.maxSize() * 2);
        this.routeTable = rt;
        this.logger = ln.getEnvironment().getLogManager().getLogger(this.getClass(), null);
        this.address = new LeafSetProtocolAddress();
    }

    public Address getAddress() {
        return this.address;
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof BroadcastLeafSet) {
            BroadcastLeafSet bls = (BroadcastLeafSet)msg;
            int type = bls.type();
            NodeHandle from = bls.from();
            LeafSet remotels = bls.leafSet();
            boolean changed = this.mergeLeafSet(remotels, from);
            if (type == 1) {
                // empty if block
            }
            if (type == 1) {
                this.broadcast();
            }
            if (type == 3 && changed) {
                this.broadcast();
            }
            this.checkLeafSet(remotels, from, true);
        } else if (msg instanceof RequestLeafSet) {
            RequestLeafSet rls = (RequestLeafSet)msg;
            NodeHandle returnHandle = rls.returnHandle();
            if ((returnHandle = this.security.verifyNodeHandle(returnHandle)).isAlive()) {
                BroadcastLeafSet bls = new BroadcastLeafSet(this.localHandle, this.leafSet, 0);
                returnHandle.receiveMessage(bls);
            }
        } else if (msg instanceof InitiateLeafSetMaintenance) {
            this.maintainLeafSet();
        } else {
            throw new Error("message received is of unknown type");
        }
    }

    protected boolean checkLeafSet(LeafSet remotels, NodeHandle from, boolean notifyMissing) {
        HashSet insertedHandles;
        if (notifyMissing) {
            this.cachedSet.clear();
            insertedHandles = this.cachedSet;
        } else {
            insertedHandles = null;
        }
        BroadcastLeafSet bl = new BroadcastLeafSet(this.localHandle, this.leafSet, 3);
        boolean changed = remotels.merge(this.leafSet, this.localHandle, null, this.security, true, insertedHandles);
        if (changed) {
            from = this.security.verifyNodeHandle(from);
            from.receiveMessage(bl);
            if (notifyMissing) {
                for (NodeHandle nh : new ArrayList(insertedHandles)) {
                    nh.receiveMessage(bl);
                }
            }
        }
        return changed;
    }

    protected boolean mergeLeafSet(LeafSet remotels, NodeHandle from) {
        return this.leafSet.merge(remotels, from, this.routeTable, this.security, false, null);
    }

    protected void broadcast() {
        this.broadcast(2);
    }

    protected void broadcast(int type) {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.localHandle, this.leafSet, type);
        int cwSize = this.leafSet.cwSize();
        int ccwSize = this.leafSet.ccwSize();
        IdSet sent = new IdSet();
        for (int i = -ccwSize; i <= cwSize; ++i) {
            NodeHandle nh;
            if (i == 0 || (nh = this.leafSet.get(i)) == null || !nh.isAlive() || sent.isMember(nh.getNodeId())) continue;
            nh.receiveMessage(bls);
            sent.addMember(nh.getNodeId());
        }
    }

    protected void broadcast(LeafSet ls, NodeHandle from) {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.localHandle, this.leafSet, 2);
        int cwSize = ls.cwSize();
        int ccwSize = ls.ccwSize();
        for (int i = -ccwSize; i <= cwSize; ++i) {
            NodeHandle nh = i == 0 ? from : ls.get(i);
            if (nh == null || !nh.isAlive()) continue;
            nh = this.security.verifyNodeHandle(nh);
            nh.receiveMessage(bls);
        }
    }

    public void maintainLeafSet() {
        NodeHandle nh;
        int i;
        if (this.logger.level <= 500) {
            this.logger.log("maintainLeafSet " + this.localHandle.getNodeId());
        }
        boolean lostMembers = false;
        for (i = -this.leafSet.ccwSize(); i < 0; ++i) {
            nh = this.leafSet.get(i);
            if (nh == null || nh.ping()) continue;
            this.leafSet.remove(nh);
            lostMembers = true;
        }
        for (i = this.leafSet.cwSize(); i > 0; --i) {
            nh = this.leafSet.get(i);
            if (nh == null || nh.ping()) continue;
            this.leafSet.remove(nh);
            lostMembers = true;
        }
        if (lostMembers || this.leafSet.size() < this.leafSet.maxSize()) {
            this.requestLeafSet();
        }
    }

    private void requestLeafSet() {
        NodeHandle handle;
        int i;
        RequestLeafSet rls = new RequestLeafSet(this.localHandle);
        int cwSize = this.leafSet.cwSize();
        int ccwSize = this.leafSet.ccwSize();
        boolean allDead = true;
        for (i = -ccwSize; i < 0; ++i) {
            handle = this.leafSet.get(i);
            if (handle == null || !handle.isAlive()) continue;
            handle.receiveMessage(rls);
            allDead = false;
            break;
        }
        if (allDead && this.leafSet.size() > 0 && this.logger.level <= 1000) {
            this.logger.log("Ring failure at" + this.localHandle.getNodeId() + "all ccw leafset entries failed");
        }
        allDead = true;
        for (i = cwSize; i > 0; --i) {
            handle = this.leafSet.get(i);
            if (handle == null || !handle.isAlive()) continue;
            handle.receiveMessage(rls);
            allDead = false;
            break;
        }
        if (allDead && this.leafSet.size() > 0 && this.logger.level <= 1000) {
            this.logger.log("Ring failure at" + this.localHandle.getNodeId() + "all cw leafset entries failed");
        }
    }
}

