/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.join.InitiateJoin;
import rice.pastry.join.JoinAddress;
import rice.pastry.join.JoinRequest;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.security.PermissiveCredentials;

public class StandardJoinProtocol
extends PastryAppl {
    protected NodeHandle localHandle;
    protected PastrySecurityManager security;
    protected RoutingTable routeTable;
    protected LeafSet leafSet;
    protected Credentials cred = new PermissiveCredentials();

    public StandardJoinProtocol(PastryNode ln, NodeHandle lh, PastrySecurityManager sm, RoutingTable rt, LeafSet ls) {
        super(ln);
        this.localHandle = lh;
        this.security = sm;
        this.routeTable = rt;
        this.leafSet = ls;
    }

    public Address getAddress() {
        return new JoinAddress();
    }

    public Credentials getCredentials() {
        return this.cred;
    }

    protected void setReady() {
        this.thePastryNode.setReady();
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof JoinRequest) {
            JoinRequest jr = (JoinRequest)msg;
            NodeHandle nh = jr.getHandle();
            nh = this.security.verifyNodeHandle(nh);
            if (!jr.accepted()) {
                if (this.thePastryNode.isReady()) {
                    jr.acceptJoin(this.localHandle, this.leafSet);
                    nh.receiveMessage(jr);
                } else if (this.logger.level <= 800) {
                    this.logger.log("NOTE: Dropping incoming JoinRequest " + jr + " because local node is not ready!");
                }
            } else {
                NodeHandle jh = jr.getJoinHandle();
                if ((jh = this.security.verifyNodeHandle(jh)).getId().equals(this.localHandle.getId()) && !jh.equals(this.localHandle)) {
                    if (this.logger.level <= 900) {
                        this.logger.log("NodeId collision, unable to join: " + this.localHandle + ":" + jh);
                    }
                } else if (jh.isAlive()) {
                    this.routeTable.put(jh);
                    this.broadcastRows(jr);
                    BroadcastLeafSet bls = new BroadcastLeafSet(jh, jr.getLeafSet(), 1);
                    this.localHandle.receiveMessage(bls);
                    this.setReady();
                }
            }
        } else if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            JoinRequest jr = (JoinRequest)rm.unwrap();
            NodeId localId = this.localHandle.getNodeId();
            NodeHandle jh = jr.getHandle();
            NodeId nid = jh.getNodeId();
            if (!(jh = this.security.verifyNodeHandle(jh)).equals(this.localHandle)) {
                int base = this.thePastryNode.getRoutingTable().baseBitLength();
                int msdd = localId.indexOfMSDD(nid, base);
                int last = jr.lastRow();
                for (int i = last - 1; msdd > 0 && i >= msdd; --i) {
                    RouteSet[] row = this.routeTable.getRow(i);
                    jr.pushRow(row);
                }
                rm.routeMessage(this.localHandle);
            }
        } else if (msg instanceof InitiateJoin) {
            InitiateJoin ij = (InitiateJoin)msg;
            NodeHandle nh = ij.getHandle();
            if (nh == null) {
                if (this.logger.level <= 1000) {
                    this.logger.log("ERROR: Cannot join ring.  All bootstraps are faulty.");
                }
            } else if ((nh = this.security.verifyNodeHandle(nh)).isAlive()) {
                JoinRequest jr = new JoinRequest(this.localHandle, this.thePastryNode.getRoutingTable().baseBitLength());
                RouteMessage rm = new RouteMessage((Id)this.localHandle.getNodeId(), (Message)jr, (Credentials)new PermissiveCredentials(), this.getAddress());
                rm.getOptions().setRerouteIfSuspected(false);
                nh.bootstrap(rm);
            }
        }
    }

    public void broadcastRows(JoinRequest jr) {
        BroadcastRouteRow brr;
        RouteSet[] row;
        int i;
        int n = jr.numRows();
        for (i = jr.lastRow(); i < n; ++i) {
            row = jr.getRow(i);
            if (row == null) continue;
            brr = new BroadcastRouteRow(this.localHandle, row);
            this.localHandle.receiveMessage(brr);
        }
        for (i = jr.lastRow(); i < n; ++i) {
            row = jr.getRow(i);
            brr = new BroadcastRouteRow(this.localHandle, row);
            for (int j = 0; j < row.length; ++j) {
                RouteSet rs = row[j];
                if (rs == null) continue;
                NodeHandle nh = rs.closestNode();
                if (nh != null) {
                    nh = this.security.verifyNodeHandle(nh);
                }
                if (nh == null) continue;
                nh.receiveMessage(brr);
            }
        }
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }

    public boolean deliverWhenNotReady() {
        return true;
    }
}

