/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.WeakHashMap;
import rice.environment.params.Parameters;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.client.PastryAppl;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.leafset.RequestLeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.standard.InitiatePingNeighbor;

public class PeriodicLeafSetProtocol
extends PastryAppl {
    protected NodeHandle localHandle;
    protected PastryNode localNode;
    protected PastrySecurityManager security;
    protected LeafSet leafSet;
    protected RoutingTable routeTable;
    protected WeakHashMap lastTimeReceivedBLS;
    public final int PING_NEIGHBOR_PERIOD;
    public final int CHECK_LIVENESS_PERIOD;
    ScheduledMessage pingNeighborMessage;
    RandomSource random;
    protected Credentials cred = new PermissiveCredentials();

    public PeriodicLeafSetProtocol(PastryNode ln, NodeHandle local, PastrySecurityManager sm, LeafSet ls, RoutingTable rt) {
        super(ln);
        this.localNode = ln;
        Parameters params = ln.getEnvironment().getParameters();
        this.random = params.contains("pastry_periodic_leafset_protocol_use_own_random") && params.getBoolean("pastry_periodic_leafset_protocol_use_own_random") ? (params.contains("pastry_periodic_leafset_protocol_random_seed") && !params.getString("pastry_periodic_leafset_protocol_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_periodic_leafset_protocol_random_seed"), ln.getEnvironment().getLogManager(), "socket") : new SimpleRandomSource(ln.getEnvironment().getLogManager(), "periodic_leaf_set")) : ln.getEnvironment().getRandomSource();
        this.localHandle = local;
        this.security = sm;
        this.leafSet = ls;
        this.routeTable = rt;
        this.lastTimeReceivedBLS = new WeakHashMap();
        Parameters p = ln.getEnvironment().getParameters();
        this.PING_NEIGHBOR_PERIOD = p.getInt("pastry_protocol_periodicLeafSet_ping_neighbor_period");
        this.CHECK_LIVENESS_PERIOD = this.PING_NEIGHBOR_PERIOD + p.getInt("pastry_protocol_periodicLeafSet_checkLiveness_neighbor_gracePeriod");
        this.pingNeighborMessage = this.localNode.scheduleMsgAtFixedRate(new InitiatePingNeighbor(), this.PING_NEIGHBOR_PERIOD, this.PING_NEIGHBOR_PERIOD);
    }

    public Credentials getCredentials() {
        return this.cred;
    }

    public Address getAddress() {
        return new LeafSetProtocolAddress();
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof BroadcastLeafSet) {
            BroadcastLeafSet bls = (BroadcastLeafSet)msg;
            this.lastTimeReceivedBLS.put(bls.from(), new Long(this.localNode.getEnvironment().getTimeSource().currentTimeMillis()));
            if (bls.type() == 1) {
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, this.security, false, null);
                this.broadcastAll();
            } else {
                int i;
                NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set.size(); ++i) {
                    if (!bls.leafSet().test(set.get(i))) continue;
                    set.get(i).checkLiveness();
                }
                set = bls.leafSet().neighborSet(Integer.MAX_VALUE);
                for (i = 0; i < set.size(); ++i) {
                    if (set.get(i).isAlive()) continue;
                    set.get(i).checkLiveness();
                }
                this.leafSet.merge(bls.leafSet(), bls.from(), this.routeTable, this.security, false, null);
            }
        } else if (msg instanceof RequestLeafSet) {
            RequestLeafSet rls = (RequestLeafSet)msg;
            rls.returnHandle().receiveMessage(new BroadcastLeafSet(this.localHandle, this.leafSet, 0));
        } else if (msg instanceof InitiateLeafSetMaintenance) {
            NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
            if (set.size() > 1) {
                NodeHandle handle = set.get(this.random.nextInt(set.size() - 1) + 1);
                handle.receiveMessage(new RequestLeafSet(this.localHandle));
                handle.receiveMessage(new BroadcastLeafSet(this.localHandle, this.leafSet, 0));
                NodeHandle check = set.get(this.random.nextInt(set.size() - 1) + 1);
                check.checkLiveness();
            }
        } else if (msg instanceof InitiatePingNeighbor) {
            Long time;
            NodeHandle left = this.leafSet.get(-1);
            NodeHandle right = this.leafSet.get(1);
            if (left != null) {
                left.receiveMessage(new BroadcastLeafSet(this.localHandle, this.leafSet, 0));
                left.receiveMessage(new RequestLeafSet(this.localHandle));
            }
            if (right != null && ((time = (Long)this.lastTimeReceivedBLS.get(right)) == null || time < this.localNode.getEnvironment().getTimeSource().currentTimeMillis() - (long)this.CHECK_LIVENESS_PERIOD)) {
                if (this.logger.level <= 500) {
                    this.logger.log("PeriodicLeafSetProtocol: Checking liveness on right neighbor:" + right);
                }
                right.checkLiveness();
            }
            if (left != null && ((time = (Long)this.lastTimeReceivedBLS.get(left)) == null || time < this.localNode.getEnvironment().getTimeSource().currentTimeMillis() - (long)this.CHECK_LIVENESS_PERIOD)) {
                if (this.logger.level <= 500) {
                    this.logger.log("PeriodicLeafSetProtocol: Checking liveness on left neighbor:" + left);
                }
                left.checkLiveness();
            }
        }
    }

    protected void broadcastAll() {
        BroadcastLeafSet bls = new BroadcastLeafSet(this.localHandle, this.leafSet, 2);
        NodeSet set = this.leafSet.neighborSet(Integer.MAX_VALUE);
        for (int i = 1; i < set.size(); ++i) {
            set.get(i).receiveMessage(bls);
        }
    }

    public void messageForAppl(Message msg) {
        throw new RuntimeException("Should not be called.");
    }

    public boolean deliverWhenNotReady() {
        return true;
    }

    public void destroy() {
        if (this.logger.level <= 800) {
            this.logger.log("PLSP: destroy() called");
        }
        this.pingNeighborMessage.cancel();
    }
}

