/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;

public class IPNodeIdFactory
implements NodeIdFactory {
    private InetAddress localIP;
    private int port;
    Environment environment;
    protected Logger logger;
    private static int nextInstance = 0;

    public IPNodeIdFactory(InetAddress localIP, int port, Environment env) {
        block3: {
            this.port = port;
            this.environment = env;
            this.logger = env.getLogManager().getLogger(this.getClass(), null);
            try {
                this.localIP = localIP;
                if (localIP.isLoopbackAddress()) {
                    throw new Exception("got loopback address: nodeIds will not be unique across computers!");
                }
            }
            catch (Exception e) {
                if (this.logger.level > 1000) break block3;
                this.logger.log("ALERT: IPNodeIdFactory cannot determine local IP address: " + e);
            }
        }
    }

    public NodeId generateNodeId() {
        byte[] rawIP = this.localIP.getAddress();
        byte[] rawPort = new byte[2];
        int tmp = this.port;
        for (int i = 0; i < 2; ++i) {
            rawPort[i] = (byte)(tmp & 0xFF);
            tmp >>= 8;
        }
        byte[] raw = new byte[4];
        tmp = ++nextInstance;
        for (int i = 0; i < 4; ++i) {
            raw[i] = (byte)(tmp & 0xFF);
            tmp >>= 8;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("No SHA support!");
            }
            throw new RuntimeException("No SHA support!", e);
        }
        md.update(rawIP);
        md.update(rawPort);
        md.update(raw);
        byte[] digest = md.digest();
        NodeId nodeId = NodeId.buildNodeId(digest);
        return nodeId;
    }
}

