/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import rice.environment.params.Parameters;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.standard.ConsistentJoinMsg;
import rice.pastry.standard.StandardJoinProtocol;
import rice.selector.LoopObserver;
import rice.selector.TimerTask;

public class ConsistentJoinProtocol
extends StandardJoinProtocol
implements Observer,
NodeSetListener,
LoopObserver {
    protected final int MAX_TIME_TO_BE_SCHEDULED;
    protected boolean tryingToGoReady = false;
    WeakHashMap gotResponse = new WeakHashMap();
    Hashtable failed = new Hashtable();
    TimerTask cleanupTask;
    int failedNodeExpirationTime;
    int maxFailedEntries;
    HashSet observing = new HashSet();
    public final int RETRY_INTERVAL;
    TimerTask retryTask;

    public ConsistentJoinProtocol(PastryNode ln, NodeHandle lh, PastrySecurityManager sm, RoutingTable rt, LeafSet ls) {
        super(ln, lh, sm, rt, ls);
        ls.addNodeSetListener(this);
        ln.addObserver(this);
        Parameters p = ln.getEnvironment().getParameters();
        this.MAX_TIME_TO_BE_SCHEDULED = p.getInt("pastry_protocol_consistentJoin_max_time_to_be_scheduled");
        this.RETRY_INTERVAL = p.getInt("pastry_protocol_consistentJoin_retry_interval");
        this.failedNodeExpirationTime = p.getInt("pastry_protocol_consistentJoin_failedRetentionTime");
        this.maxFailedEntries = p.getInt("pastry_protocol_consistentJoin_maxFailedToSend");
        int cleanupInterval = p.getInt("pastry_protocol_consistentJoin_cleanup_interval");
        ln.getEnvironment().getSelectorManager().addLoopObserver(this);
        this.cleanupTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (((ConsistentJoinProtocol)ConsistentJoinProtocol.this).logger.level <= 800) {
                    ConsistentJoinProtocol.this.logger.log("CJP: Cleanup task.");
                }
                Hashtable hashtable = ConsistentJoinProtocol.this.failed;
                synchronized (hashtable) {
                    long now = ConsistentJoinProtocol.this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis();
                    long expiration = now - (long)ConsistentJoinProtocol.this.failedNodeExpirationTime;
                    Iterator i = ConsistentJoinProtocol.this.failed.values().iterator();
                    while (i.hasNext()) {
                        FailedTime ft = (FailedTime)i.next();
                        if (ft.time < expiration) {
                            if (((ConsistentJoinProtocol)ConsistentJoinProtocol.this).logger.level <= 500) {
                                ConsistentJoinProtocol.this.logger.log("CJP: Removing " + ft.handle + " from failed set.");
                            }
                            i.remove();
                            ft.handle.deleteObserver(ConsistentJoinProtocol.this);
                            continue;
                        }
                        if (((ConsistentJoinProtocol)ConsistentJoinProtocol.this).logger.level > 400) continue;
                        ConsistentJoinProtocol.this.logger.log("CJP: Not Removing " + ft.handle + " from failed set until " + (ft.time + (long)ConsistentJoinProtocol.this.failedNodeExpirationTime) + " which is another " + (ft.time + (long)ConsistentJoinProtocol.this.failedNodeExpirationTime - now) + " millis.");
                    }
                }
            }
        };
        ln.getEnvironment().getSelectorManager().schedule(this.cleanupTask, cleanupInterval, cleanupInterval);
    }

    protected void setReady() {
        if (this.tryingToGoReady) {
            return;
        }
        this.tryingToGoReady = true;
        if (this.logger.level <= 800) {
            this.logger.log("ChurnJonProtocol.setReady()");
        }
        this.gotResponse.clear();
        Iterator i = this.leafSet.neighborSet(Integer.MAX_VALUE).iterator();
        while (i.hasNext()) {
            NodeHandle nh = (NodeHandle)i.next();
            this.sendTheMessage(nh, false);
        }
        this.retryTask = this.thePastryNode.scheduleMsg(new RequestFromEveryoneMsg(this.getAddress()), this.RETRY_INTERVAL, this.RETRY_INTERVAL);
    }

    public void addToLeafSet(NodeHandle nh) {
        this.leafSet.put(nh);
        if (!this.observing.contains(nh)) {
            if (this.logger.level <= 500) {
                this.logger.log("CJP observing " + nh);
            }
            nh.addObserver(this);
            this.observing.add(nh);
        }
    }

    public void requestFromEveryoneWeHaventHeardFrom() {
        if (this.thePastryNode.isReady()) {
            this.retryTask.cancel();
            return;
        }
        Collection c = this.whoDoWeNeedAResponseFrom();
        if (this.logger.level <= 800) {
            this.logger.log("CJP: timeout1, still waiting to hear from " + c.size() + " nodes.");
        }
        for (NodeHandle nh : c) {
            if (this.logger.level <= 500) {
                this.logger.log("CJP: timeout2, still waiting to hear from " + nh);
            }
            this.sendTheMessage(nh, false);
        }
    }

    public void otherNodesMaySuspectFaulty() {
        this.thePastryNode.setReady(false);
    }

    public Collection whoDoWeNeedAResponseFrom() {
        HashSet<NodeHandle> ret = new HashSet<NodeHandle>();
        for (int i = -this.leafSet.ccwSize(); i <= this.leafSet.cwSize(); ++i) {
            NodeHandle nh;
            if (i == 0 || this.gotResponse.get(nh = this.leafSet.get(i)) != null) continue;
            ret.add(nh);
        }
        return ret;
    }

    public void receiveMessage(Message msg) {
        if (msg instanceof ConsistentJoinMsg) {
            ConsistentJoinMsg cjm = (ConsistentJoinMsg)msg;
            NodeHandle j = cjm.ls.get(0);
            this.failed.remove(j);
            if (this.thePastryNode.isReady()) {
                if (cjm.request) {
                    this.sendTheMessage(j, true);
                }
                return;
            }
            this.addToLeafSet(j);
            for (NodeHandle nh : cjm.failed) {
                if (!this.leafSet.member(nh)) continue;
                if (nh.getLiveness() == 3) {
                    this.leafSet.remove(nh);
                    continue;
                }
                if (this.logger.level <= 500) {
                    this.logger.log("CJP: checking liveness2 on " + nh);
                }
                nh.checkLiveness();
            }
            LeafSet lprime = this.leafSet.copy();
            for (int i = -cjm.ls.ccwSize(); i <= cjm.ls.cwSize(); ++i) {
                NodeHandle nh = cjm.ls.get(i);
                if (this.failed.containsKey(nh) || nh.getLiveness() >= 3) continue;
                lprime.put(nh);
            }
            HashSet<NodeHandle> addThese = new HashSet<NodeHandle>();
            for (int i = -lprime.ccwSize(); i <= lprime.cwSize(); ++i) {
                NodeHandle nh;
                if (i == 0 || this.leafSet.member(nh = lprime.get(i))) continue;
                addThese.add(nh);
            }
            for (NodeHandle nh : addThese) {
                if (this.failed.containsKey(nh) || nh.getLiveness() >= 3) continue;
                this.addToLeafSet(nh);
                this.sendTheMessage(nh, false);
            }
            if (cjm.request) {
                this.sendTheMessage(j, true);
            }
            this.gotResponse.put(j, new Object());
            this.doneProbing();
        } else if (msg instanceof RequestFromEveryoneMsg) {
            this.requestFromEveryoneWeHaventHeardFrom();
        } else {
            super.receiveMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doneProbing() {
        if (this.leafSet.isComplete()) {
            HashSet<NodeHandle> toHearFrom = new HashSet<NodeHandle>();
            HashSet<NodeHandle> seen = new HashSet<NodeHandle>();
            String toHearFromStr = "";
            int numToHearFrom = 0;
            for (int i = -this.leafSet.ccwSize(); i <= this.leafSet.cwSize(); ++i) {
                if (i == 0) continue;
                NodeHandle nh = this.leafSet.get(i);
                if (!seen.contains(nh) && this.gotResponse.get(nh) == null) {
                    ++numToHearFrom;
                    toHearFrom.add(nh);
                    toHearFromStr = toHearFromStr + nh + ":" + nh.getLiveness() + ",";
                }
                seen.add(nh);
            }
            if (numToHearFrom == 0) {
                if (!this.thePastryNode.isReady()) {
                    this.thePastryNode.setReady();
                    this.retryTask.cancel();
                    this.tryingToGoReady = false;
                }
            } else if (this.logger.level <= 500) {
                this.logger.log("CJP: still need to hear from:" + toHearFromStr);
            }
        } else {
            if (this.logger.level <= 500) {
                this.logger.log("CJP: LS is not complete: " + this.leafSet);
            }
            NodeHandle left = null;
            NodeHandle right = null;
            LeafSet leafSet = this.leafSet;
            synchronized (leafSet) {
                int index = -this.leafSet.ccwSize();
                if (index != -this.leafSet.maxSize() / 2) {
                    left = this.leafSet.get(index);
                }
                if ((index = this.leafSet.cwSize()) != this.leafSet.maxSize() / 2) {
                    right = this.leafSet.get(index);
                }
            }
            if (left != null) {
                this.sendTheMessage(left, true);
            }
            if (right != null) {
                this.sendTheMessage(right, true);
            }
        }
    }

    public void sendTheMessage(NodeHandle nh, boolean reply) {
        HashSet<Object> toSend;
        if (!reply && !this.tryingToGoReady) {
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("CJP:  sendTheMessage(" + nh + "," + reply + ")");
        }
        if (this.failed.size() < this.maxFailedEntries) {
            toSend = new HashSet(this.failed.keySet());
        } else {
            ArrayList l = new ArrayList(this.failed.values());
            Collections.sort(l);
            toSend = new HashSet();
            for (int i = 0; i < this.maxFailedEntries; ++i) {
                FailedTime tf = (FailedTime)l.get(i);
                toSend.add(tf.handle);
            }
        }
        nh.receiveMessage(new ConsistentJoinMsg(this.getAddress(), this.leafSet, toSend, !reply));
    }

    public void nodeSetUpdate(NodeSetEventSource set, NodeHandle handle, boolean added) {
        if (this.thePastryNode.isReady()) {
            return;
        }
        if (added) {
            if (this.gotResponse.get(handle) == null) {
                this.sendTheMessage(handle, false);
            }
        } else {
            this.doneProbing();
        }
    }

    public void update(Observable arg0, Object arg) {
        if (this.logger.level <= 300) {
            this.logger.log("CJP: update(" + arg0 + "," + arg + ")" + arg.getClass().getName());
        }
        if (arg0 == this.thePastryNode && !((Boolean)arg).booleanValue()) {
            this.setReady();
        }
        if (arg0 instanceof NodeHandle) {
            NodeHandle nh = (NodeHandle)arg0;
            if ((Integer)arg == NodeHandle.DECLARED_DEAD) {
                if (this.logger.level <= 500) {
                    this.logger.log("CJP:" + arg0 + " declared dead");
                }
                if (!this.failed.containsKey(nh)) {
                    this.failed.put(nh, new FailedTime(nh, this.thePastryNode.getEnvironment().getTimeSource().currentTimeMillis()));
                }
                this.leafSet.remove(nh);
                this.doneProbing();
            }
            if ((Integer)arg == NodeHandle.DECLARED_LIVE) {
                this.failed.remove(nh);
                if (!this.thePastryNode.isReady() && this.leafSet.test(nh)) {
                    this.leafSet.put(nh);
                    this.sendTheMessage(nh, false);
                }
            }
        }
    }

    public int delayInterest() {
        return this.MAX_TIME_TO_BE_SCHEDULED;
    }

    public void loopTime(int loopTime) {
        if (loopTime > this.delayInterest()) {
            this.otherNodesMaySuspectFaulty();
        }
    }

    public void destroy() {
        if (this.logger.level <= 500) {
            this.logger.log("CJP: destroy() called");
        }
        this.thePastryNode.getEnvironment().getSelectorManager().removeLoopObserver(this);
        this.cleanupTask.cancel();
    }

    static class FailedTime
    implements Comparable {
        long time;
        NodeHandle handle;

        public FailedTime(NodeHandle handle, long time) {
            this.time = time;
            this.handle = handle;
        }

        public int compareTo(Object arg0) {
            FailedTime ft = (FailedTime)arg0;
            return (int)(ft.time - this.time);
        }

        public String toString() {
            return "FT:" + this.handle + " " + this.time;
        }
    }

    class RequestFromEveryoneMsg
    extends Message {
        public RequestFromEveryoneMsg(Address dest) {
            super(dest);
        }
    }
}

