/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.WeakHashMap;
import rice.pastry.socket.EpochInetSocketAddress;

public class SourceRoute
implements Serializable {
    protected EpochInetSocketAddress[] path;
    private static final long serialVersionUID = -4402277039316685149L;
    private static WeakHashMap SOURCE_ROUTE_MAP = new WeakHashMap();

    private SourceRoute(EpochInetSocketAddress[] path) {
        this.path = path;
    }

    public EpochInetSocketAddress getFirstHop() {
        return this.path[0];
    }

    public EpochInetSocketAddress getLastHop() {
        return this.path[this.path.length - 1];
    }

    public int getNumHops() {
        return this.path.length;
    }

    public EpochInetSocketAddress getHop(int i) {
        return this.path[i];
    }

    public boolean isDirect() {
        return this.path.length == 1;
    }

    private Object readResolve() throws ObjectStreamException {
        return SourceRoute.resolve(SOURCE_ROUTE_MAP, this);
    }

    public int hashCode() {
        int result = 399388937;
        for (int i = 0; i < this.path.length; ++i) {
            result ^= this.path[i].hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return Arrays.equals(this.path, ((SourceRoute)o).path);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (int i = 0; i < this.path.length; ++i) {
            EpochInetSocketAddress thePath = this.path[i];
            InetSocketAddress theAddr = thePath.getAddress();
            InetAddress theAddr2 = theAddr.getAddress();
            if (theAddr2 == null) {
                result.append(theAddr.toString());
            } else {
                String ha = theAddr2.getHostAddress();
                result.append(ha + ":" + theAddr.getPort());
            }
            if (i >= this.path.length - 1) continue;
            result.append(" -> ");
        }
        result.append("}");
        return result.toString();
    }

    public String toStringFull() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        for (int i = 0; i < this.path.length; ++i) {
            result.append(this.path[i].toString());
            if (i >= this.path.length - 1) continue;
            result.append(" -> ");
        }
        result.append("}");
        return result.toString();
    }

    public SourceRoute reverse(EpochInetSocketAddress localAddress) {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length];
        for (int i = 0; i < this.path.length - 1; ++i) {
            result[i] = this.path[this.path.length - 2 - i];
        }
        result[result.length - 1] = localAddress;
        return SourceRoute.build(result);
    }

    public SourceRoute reverse() {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length];
        for (int i = 0; i < this.path.length; ++i) {
            result[i] = this.path[this.path.length - 1 - i];
        }
        return SourceRoute.build(result);
    }

    public boolean goesThrough(EpochInetSocketAddress address) {
        for (int i = 0; i < this.path.length; ++i) {
            if (!this.path[i].equals(address)) continue;
            return true;
        }
        return false;
    }

    public InetSocketAddress[] toArray() {
        InetSocketAddress[] result = new InetSocketAddress[this.path.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.path[i].getAddress();
        }
        return result;
    }

    public SourceRoute removeLastHop() {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length - 1];
        System.arraycopy(this.path, 0, result, 0, result.length);
        return SourceRoute.build(result);
    }

    public SourceRoute append(EpochInetSocketAddress address) {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length + 1];
        System.arraycopy(this.path, 0, result, 0, this.path.length);
        result[result.length - 1] = address;
        return SourceRoute.build(result);
    }

    public SourceRoute prepend(EpochInetSocketAddress address) {
        EpochInetSocketAddress[] result = new EpochInetSocketAddress[this.path.length + 1];
        System.arraycopy(this.path, 0, result, 1, this.path.length);
        result[0] = address;
        return SourceRoute.build(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SourceRoute resolve(WeakHashMap map, SourceRoute route) {
        WeakHashMap weakHashMap = map;
        synchronized (weakHashMap) {
            WeakReference ref = (WeakReference)map.get(route);
            SourceRoute result = null;
            if (ref != null && (result = (SourceRoute)ref.get()) != null) {
                return result;
            }
            map.put(route, new WeakReference<SourceRoute>(route));
            return route;
        }
    }

    public static SourceRoute build(EpochInetSocketAddress[] path) {
        return SourceRoute.resolve(SOURCE_ROUTE_MAP, new SourceRoute(path));
    }

    public static SourceRoute build(EpochInetSocketAddress address) {
        return SourceRoute.resolve(SOURCE_ROUTE_MAP, new SourceRoute(new EpochInetSocketAddress[]{address}));
    }
}

