/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import rice.Continuation;
import rice.environment.Environment;
import rice.environment.logging.CloneableLogManager;
import rice.environment.logging.LogManager;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.processing.Processor;
import rice.environment.processing.simple.SimpleProcessor;
import rice.environment.random.RandomSource;
import rice.environment.random.simple.SimpleRandomSource;
import rice.p2p.commonapi.CancellableTask;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PingManager;
import rice.pastry.socket.SocketChannelReader;
import rice.pastry.socket.SocketChannelWriter;
import rice.pastry.socket.SocketCollectionManager;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketPastrySecurityManager;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.messaging.IPAddressRequestMessage;
import rice.pastry.socket.messaging.IPAddressResponseMessage;
import rice.pastry.socket.messaging.LeafSetRequestMessage;
import rice.pastry.socket.messaging.LeafSetResponseMessage;
import rice.pastry.socket.messaging.NodeIdRequestMessage;
import rice.pastry.socket.messaging.NodeIdResponseMessage;
import rice.pastry.socket.messaging.PingMessage;
import rice.pastry.socket.messaging.RouteRowRequestMessage;
import rice.pastry.socket.messaging.RouteRowResponseMessage;
import rice.pastry.socket.messaging.RoutesRequestMessage;
import rice.pastry.socket.messaging.RoutesResponseMessage;
import rice.pastry.standard.ConsistentJoinProtocol;
import rice.pastry.standard.PeriodicLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;
import rice.selector.SelectionKeyHandler;
import rice.selector.SelectorManager;

public class SocketPastryNodeFactory
extends DistPastryNodeFactory {
    private Environment environment;
    private NodeIdFactory nidFactory;
    private int port;
    private int leafSetMaintFreq;
    private int routeSetMaintFreq;
    private RandomSource random;
    private InetAddress localAddress;

    public SocketPastryNodeFactory(NodeIdFactory nf, InetAddress bindAddress, int startPort, Environment env) throws IOException {
        block4: {
            super(env);
            this.localAddress = bindAddress;
            if (this.localAddress == null && env.getParameters().contains("socket_bindAddress")) {
                this.localAddress = env.getParameters().getInetAddress("socket_bindAddress");
            }
            if (this.localAddress == null) {
                this.localAddress = InetAddress.getLocalHost();
                try {
                    ServerSocket test = new ServerSocket();
                    test.bind(new InetSocketAddress(this.localAddress, this.port));
                }
                catch (SocketException e) {
                    Socket temp = new Socket("yahoo.com", 80);
                    this.localAddress = temp.getLocalAddress();
                    temp.close();
                    if (this.logger.level > 900) break block4;
                    this.logger.log("Error binding to default IP, using " + this.localAddress);
                }
            }
        }
        this.environment = env;
        this.nidFactory = nf;
        this.port = startPort;
        Parameters params = env.getParameters();
        this.leafSetMaintFreq = params.getInt("pastry_leafSetMaintFreq");
        this.routeSetMaintFreq = params.getInt("pastry_routeSetMaintFreq");
        this.random = params.contains("pastry_socket_use_own_random") && params.getBoolean("pastry_socket_use_own_random") ? (params.contains("pastry_socket_random_seed") && !params.getString("pastry_socket_random_seed").equalsIgnoreCase("clock") ? new SimpleRandomSource(params.getLong("pastry_socket_random_seed"), env.getLogManager(), "socket") : new SimpleRandomSource(env.getLogManager(), "socket")) : env.getRandomSource();
    }

    public SocketPastryNodeFactory(NodeIdFactory nf, int startPort, Environment env) throws IOException {
        this(nf, null, startPort, env);
    }

    public SourceRoute[] getRoutes(NodeHandle handle, NodeHandle local) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        RoutesResponseMessage lm = (RoutesResponseMessage)this.getResponse(wHandle.getAddress(), new RoutesRequestMessage());
        return lm.getRoutes();
    }

    public LeafSet getLeafSet(NodeHandle handle) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        LeafSetResponseMessage lm = (LeafSetResponseMessage)this.getResponse(wHandle.getAddress(), new LeafSetRequestMessage());
        return lm.getLeafSet();
    }

    public CancellableTask getLeafSet(NodeHandle handle, final Continuation c) {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        return this.getResponse(wHandle.getAddress(), new LeafSetRequestMessage(), new Continuation(){

            public void receiveResult(Object result) {
                LeafSetResponseMessage lm = (LeafSetResponseMessage)result;
                c.receiveResult(lm.getLeafSet());
            }

            public void receiveException(Exception result) {
                c.receiveException(result);
            }
        });
    }

    public RouteSet[] getRouteRow(NodeHandle handle, int row) throws IOException {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        RouteRowResponseMessage rm = (RouteRowResponseMessage)this.getResponse(wHandle.getAddress(), new RouteRowRequestMessage(row));
        return rm.getRouteRow();
    }

    public CancellableTask getRouteRow(NodeHandle handle, int row, final Continuation c) {
        SocketNodeHandle wHandle = (SocketNodeHandle)handle;
        return this.getResponse(wHandle.getAddress(), new RouteRowRequestMessage(row), new Continuation(){

            public void receiveResult(Object result) {
                RouteRowResponseMessage rm = (RouteRowResponseMessage)result;
                c.receiveResult(rm.getRouteRow());
            }

            public void receiveException(Exception result) {
                c.receiveException(result);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProximity(NodeHandle local, NodeHandle handle) {
        EpochInetSocketAddress lAddress = ((SocketNodeHandle)local).getEpochAddress();
        EpochInetSocketAddress rAddress = ((SocketNodeHandle)handle).getEpochAddress();
        if ((lAddress = new EpochInetSocketAddress(new InetSocketAddress(lAddress.getAddress().getAddress(), lAddress.getAddress().getPort() + 1))).getAddress().equals(rAddress.getAddress())) {
            return Integer.MAX_VALUE;
        }
        DatagramSocket socket = null;
        SourceRoute route = SourceRoute.build(new EpochInetSocketAddress[]{rAddress});
        try {
            socket = new DatagramSocket(lAddress.getAddress().getPort());
            socket.setSoTimeout(5000);
            byte[] data = PingManager.addHeader(route, new PingMessage(route, route.reverse(lAddress), this.environment.getTimeSource().currentTimeMillis()), lAddress, this.environment, this.logger);
            socket.send(new DatagramPacket(data, data.length, rAddress.getAddress()));
            long start = this.environment.getTimeSource().currentTimeMillis();
            socket.receive(new DatagramPacket(new byte[10000], 10000));
            int n = (int)(this.environment.getTimeSource().currentTimeMillis() - start);
            return n;
        }
        catch (IOException e) {
            int n = 0x7FFFFFFE;
            return n;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    protected Message getResponse(InetSocketAddress address, Message message) throws IOException {
        SocketChannelWriter writer = new SocketChannelWriter(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        SocketChannelReader reader = new SocketChannelReader(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        SocketChannel channel = SocketChannel.open();
        channel.configureBlocking(true);
        channel.socket().connect(address, 20000);
        channel.socket().setSoTimeout(20000);
        writer.enqueue(SocketCollectionManager.HEADER_DIRECT);
        writer.enqueue(message);
        writer.write(channel);
        Object o = null;
        while (o == null) {
            o = reader.read(channel);
        }
        if (this.logger.level <= 400) {
            this.logger.log("SPNF.getResponse(): Closing " + channel);
        }
        channel.socket().shutdownOutput();
        channel.socket().close();
        channel.close();
        if (this.logger.level <= 400) {
            this.logger.log("SPNF.getResponse(): Closed " + channel);
        }
        return (Message)o;
    }

    protected CancellableTask getResponse(final InetSocketAddress address, final Message message, final Continuation c) {
        final SocketChannelWriter writer = new SocketChannelWriter(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        final SocketChannelReader reader = new SocketChannelReader(this.environment, SourceRoute.build(new EpochInetSocketAddress(address, -1L)));
        writer.enqueue(SocketCollectionManager.HEADER_DIRECT);
        writer.enqueue(message);
        try {
            final SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            final SelectionKey key = this.environment.getSelectorManager().register(channel, new SelectionKeyHandler(){

                public void connect(SelectionKey key) {
                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                        SocketPastryNodeFactory.this.logger.log("SPNF.getResponse(" + address + "," + message + ").connect()");
                    }
                    try {
                        if (channel.finishConnect()) {
                            key.interestOps(key.interestOps() & 0xFFFFFFF7);
                        }
                        if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                            SocketPastryNodeFactory.this.logger.log("(SPNF) Found connectable channel - completed connection");
                        }
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                    }
                }

                public void read(SelectionKey key) {
                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                        SocketPastryNodeFactory.this.logger.log("SPNF.getResponse(" + address + "," + message + ").read()");
                    }
                    try {
                        Object o = null;
                        while (o == null) {
                            o = reader.read(channel);
                        }
                        channel.socket().close();
                        channel.close();
                        key.cancel();
                        c.receiveResult(o);
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                    }
                }

                public void write(SelectionKey key) {
                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 500) {
                        SocketPastryNodeFactory.this.logger.log("SPNF.getResponse(" + address + "," + message + ").write()");
                    }
                    try {
                        if (writer.write(channel)) {
                            key.interestOps(1);
                        }
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleException(Exception e) {
                    try {
                        channel.socket().close();
                        channel.close();
                        channel.keyFor(SocketPastryNodeFactory.this.environment.getSelectorManager().getSelector()).cancel();
                    }
                    catch (IOException ioe) {
                        if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 900) {
                            SocketPastryNodeFactory.this.logger.logException("Error while trying requesting " + message + " from " + address, e);
                        }
                    }
                    finally {
                        c.receiveException(e);
                    }
                }
            }, 0);
            if (this.logger.level <= 500) {
                this.logger.log("(SPNF) Initiating socket connection to address " + address);
            }
            if (channel.connect(address)) {
                key.interestOps(5);
            } else {
                key.interestOps(13);
            }
            return new CancellableTask(){

                public void run() {
                }

                public boolean cancel() {
                    SocketPastryNodeFactory.this.environment.getSelectorManager().invoke(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            block5: {
                                try {
                                    SelectionKey selectionKey = key;
                                    synchronized (selectionKey) {
                                        channel.socket().close();
                                        channel.close();
                                        key.cancel();
                                    }
                                }
                                catch (Exception ioe) {
                                    if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level > 900) break block5;
                                    SocketPastryNodeFactory.this.logger.logException("Error cancelling task.", ioe);
                                }
                            }
                        }
                    });
                    return true;
                }

                public long scheduledExecutionTime() {
                    return 0L;
                }
            };
        }
        catch (IOException ioe) {
            c.receiveException(ioe);
            return null;
        }
    }

    private EpochInetSocketAddress getEpochAddress(int portNumber, long epoch) {
        EpochInetSocketAddress result = null;
        result = new EpochInetSocketAddress(new InetSocketAddress(this.localAddress, portNumber), epoch);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeHandle generateNodeHandle(InetSocketAddress address, int timeout) {
        if (timeout <= 0) {
            return this.generateNodeHandle(address);
        }
        TimerContinuation c = new TimerContinuation();
        CancellableTask task = this.generateNodeHandle(address, c);
        TimerContinuation timerContinuation = c;
        synchronized (timerContinuation) {
            try {
                c.wait(timeout);
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        task.cancel();
        if (this.logger.level <= 400) {
            this.logger.log("SPNF.generateNodeHandle() returning " + c.ret + " after trying to contact " + address);
        }
        return (NodeHandle)c.ret;
    }

    public NodeHandle generateNodeHandle(InetSocketAddress address) {
        if (this.logger.level <= 500) {
            this.logger.log("Socket: Contacting bootstrap node " + address);
        }
        try {
            NodeIdResponseMessage rm = (NodeIdResponseMessage)this.getResponse(address, new NodeIdRequestMessage());
            return new SocketNodeHandle(new EpochInetSocketAddress(address, rm.getEpoch()), rm.getNodeId());
        }
        catch (IOException e) {
            if (this.logger.level <= 900) {
                this.logger.log("Error connecting to address " + address + ": " + e);
            }
            return null;
        }
    }

    public CancellableTask generateNodeHandle(final InetSocketAddress address, final Continuation c) {
        if (this.logger.level <= 500) {
            this.logger.log("Socket: Contacting bootstrap node " + address);
        }
        return this.getResponse(address, new NodeIdRequestMessage(), new Continuation(){

            public void receiveResult(Object result) {
                NodeIdResponseMessage rm = (NodeIdResponseMessage)result;
                c.receiveResult(new SocketNodeHandle(new EpochInetSocketAddress(address, rm.getEpoch()), rm.getNodeId()));
            }

            public void receiveException(Exception result) {
                if (((SocketPastryNodeFactory)SocketPastryNodeFactory.this).logger.level <= 900) {
                    SocketPastryNodeFactory.this.logger.log("Error connecting to address " + address + ": " + result);
                }
                c.receiveException(result);
            }
        });
    }

    public PastryNode newNode(NodeHandle bootstrap) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(NodeHandle bootstrap, NodeId nodeId) {
        return this.newNode(bootstrap, nodeId, null);
    }

    public PastryNode newNode(NodeHandle bootstrap, InetSocketAddress proxy) {
        return this.newNode(bootstrap, this.nidFactory.generateNodeId(), proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PastryNode newNode(NodeHandle bootstrap, NodeId nodeId, InetSocketAddress pAddress) {
        if (bootstrap == null && this.logger.level <= 900) {
            this.logger.log("No bootstrap node provided, starting a new ring binding to address " + this.localAddress + "...");
        }
        Environment environment = this.environment;
        if (this.environment.getParameters().getBoolean("pastry_factory_multipleNodes") && this.environment.getLogManager() instanceof CloneableLogManager) {
            LogManager lman = ((CloneableLogManager)this.environment.getLogManager()).clone("0x" + nodeId.toStringBare());
            SelectorManager sman = this.environment.getSelectorManager();
            Processor proc = this.environment.getProcessor();
            if (this.environment.getParameters().getBoolean("pastry_factory_selectorPerNode")) {
                sman = new SelectorManager(nodeId.toString() + " Selector", this.environment.getTimeSource(), lman);
            }
            if (this.environment.getParameters().getBoolean("pastry_factory_processorPerNode")) {
                proc = new SimpleProcessor(nodeId.toString() + " Processor");
            }
            environment = new Environment(sman, proc, this.environment.getRandomSource(), this.environment.getTimeSource(), lman, this.environment.getParameters());
            this.environment.addDestructable(environment);
        }
        SocketPastryNode pn = new SocketPastryNode(nodeId, environment);
        SocketSourceRouteManager srManager = null;
        EpochInetSocketAddress localAddress = null;
        EpochInetSocketAddress proxyAddress = null;
        long epoch = this.random.nextLong();
        SocketPastryNodeFactory socketPastryNodeFactory = this;
        synchronized (socketPastryNodeFactory) {
            localAddress = this.getEpochAddress(this.port, epoch);
            proxyAddress = pAddress == null ? localAddress : new EpochInetSocketAddress(pAddress, epoch);
            srManager = new SocketSourceRouteManager(pn, localAddress, proxyAddress, this.random);
            if (environment.getParameters().getBoolean("pastry_socket_increment_port_after_construction")) {
                ++this.port;
            }
        }
        pn.setSocketSourceRouteManager(srManager);
        SocketNodeHandle localhandle = new SocketNodeHandle(proxyAddress, nodeId);
        localhandle = (SocketNodeHandle)pn.coalesce(localhandle);
        SocketPastrySecurityManager secureMan = new SocketPastrySecurityManager(localhandle);
        MessageDispatch msgDisp = new MessageDispatch(pn);
        RoutingTable routeTable = new RoutingTable(localhandle, this.rtMax, this.rtBase, environment);
        LeafSet leafSet = new LeafSet(localhandle, this.lSetSize);
        StandardRouter router = new StandardRouter(pn, secureMan);
        msgDisp.registerReceiver(router.getAddress(), router);
        StandardRouteSetProtocol rsProtocol = new StandardRouteSetProtocol(localhandle, secureMan, routeTable, environment);
        msgDisp.registerReceiver(rsProtocol.getAddress(), rsProtocol);
        pn.setElements(localhandle, secureMan, msgDisp, leafSet, routeTable);
        pn.setSocketElements(proxyAddress, this.leafSetMaintFreq, this.routeSetMaintFreq);
        secureMan.setLocalPastryNode(pn);
        PeriodicLeafSetProtocol lsProtocol = new PeriodicLeafSetProtocol(pn, localhandle, secureMan, leafSet, routeTable);
        ConsistentJoinProtocol jProtocol = new ConsistentJoinProtocol(pn, localhandle, secureMan, routeTable, leafSet);
        if (bootstrap != null) {
            bootstrap = (SocketNodeHandle)pn.coalesce(bootstrap);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        pn.doneNode(this.getNearest(localhandle, bootstrap));
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetSocketAddress verifyConnection(int timeout, InetSocketAddress local, InetSocketAddress[] existing, Environment env, Logger logger) throws IOException {
        if (logger.level <= 800) {
            logger.log("Verifying connection of local node " + local + " using " + existing[0] + " and " + existing.length + " more");
        }
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket(local);
            socket.setSoTimeout(timeout);
            for (int i = 0; i < existing.length; ++i) {
                byte[] buf = PingManager.addHeader(SourceRoute.build(new EpochInetSocketAddress(existing[i])), new IPAddressRequestMessage(env.getTimeSource().currentTimeMillis()), new EpochInetSocketAddress(local), env, logger);
                DatagramPacket send = new DatagramPacket(buf, buf.length, existing[i]);
                socket.send(send);
            }
            DatagramPacket receive = new DatagramPacket(new byte[10000], 10000);
            socket.receive(receive);
            byte[] data = new byte[receive.getLength() - 38];
            System.arraycopy(receive.getData(), 38, data, 0, data.length);
            InetSocketAddress inetSocketAddress = ((IPAddressResponseMessage)PingManager.deserialize(data, env, null, logger)).getAddress();
            return inetSocketAddress;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    class TimerContinuation
    implements Continuation {
        public Object ret = null;

        TimerContinuation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveResult(Object result) {
            this.ret = result;
            TimerContinuation timerContinuation = this;
            synchronized (timerContinuation) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveException(Exception result) {
            TimerContinuation timerContinuation = this;
            synchronized (timerContinuation) {
                this.notify();
            }
        }
    }
}

