/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.IOException;
import rice.environment.Environment;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.messaging.Message;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.SocketNodeHandle;
import rice.pastry.socket.SocketSourceRouteManager;

public class SocketPastryNode
extends DistPastryNode {
    private EpochInetSocketAddress address;
    SocketSourceRouteManager srManager;

    public SocketPastryNode(NodeId id, Environment e) {
        super(id, e);
    }

    public SocketSourceRouteManager getSocketSourceRouteManager() {
        return this.srManager;
    }

    public void setSocketElements(EpochInetSocketAddress address, int lsmf, int rsmf) {
        this.address = address;
        this.leafSetMaintFreq = lsmf;
        this.routeSetMaintFreq = rsmf;
    }

    public void setSocketSourceRouteManager(SocketSourceRouteManager srManager) {
        this.srManager = srManager;
    }

    public void doneNode(NodeHandle bootstrap) {
        super.doneNode(bootstrap);
        this.initiateJoin(bootstrap);
    }

    public String toString() {
        return "SocketNodeHandle (" + this.getNodeId() + "/" + this.address + ")";
    }

    public void destroy() {
        super.destroy();
        if (this.getEnvironment().getSelectorManager().isSelectorThread()) {
            try {
                super.destroy();
                this.srManager.destroy();
            }
            catch (IOException e) {
                this.getEnvironment().getLogManager().getLogger(SocketPastryNode.class, "ERROR: Got exception " + e + " while resigning node!");
            }
        } else {
            this.getEnvironment().getSelectorManager().invoke(new Runnable(){

                public void run() {
                    SocketPastryNode.this.destroy();
                }
            });
        }
    }

    public NodeHandle coalesce(NodeHandle newHandle) {
        return this.srManager.coalesce(newHandle);
    }

    public void send(NodeHandle handle, Message message) {
        SocketNodeHandle snh = (SocketNodeHandle)handle;
        if (this.getNodeId().equals(snh.getId())) {
            this.receiveMessage(message);
        } else {
            if (this.logger.level <= 400) {
                this.logger.log("Passing message " + message + " to the socket controller for writing");
            }
            this.getSocketSourceRouteManager().send(snh.getEpochAddress(), message);
        }
    }
}

