/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;

public class SocketChannelWriter {
    private final int MAXIMUM_QUEUE_LENGTH;
    private PastryNode spn;
    private ByteBuffer buffer;
    private LinkedList queue;
    protected SourceRoute path;
    protected Environment environment;
    protected Logger logger;
    static long bytesWritten;

    public SocketChannelWriter(PastryNode spn, SourceRoute path) {
        this(spn.getEnvironment(), path);
        this.spn = spn;
    }

    public SocketChannelWriter(Environment env, SourceRoute path) {
        this.environment = env;
        this.path = path;
        this.queue = new LinkedList();
        Parameters p = this.environment.getParameters();
        this.MAXIMUM_QUEUE_LENGTH = p.getInt("pastry_socket_writer_max_queue_length");
        this.logger = this.environment.getLogManager().getLogger(SocketChannelWriter.class, null);
    }

    public boolean isEmpty() {
        return this.buffer == null && this.queue.size() == 0;
    }

    public LinkedList getQueue() {
        return this.queue;
    }

    protected void setPath(SourceRoute path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueue(Object o) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.addToQueue(o);
            if (this.queue.size() > this.MAXIMUM_QUEUE_LENGTH) {
                Object remove = this.queue.removeLast();
                if (this.logger.level <= 900) {
                    this.logger.log("(W): Maximum TCP queue length reached to " + this.path + " - message " + remove + " will be dropped.");
                }
                return false;
            }
            if (this.queue.size() > 20 && this.logger.level <= 900) {
                this.logger.log("ERROR: Queue to " + this.path + " has " + this.queue.size() + " elements (more than " + this.MAXIMUM_QUEUE_LENGTH + ") - probably a bad sign - enqueue of " + o);
            }
        }
        return true;
    }

    public void reset() {
        this.queue = new LinkedList();
        this.buffer = null;
    }

    protected void record(String action, Object obj, int size, SourceRoute path) {
        boolean recorded = false;
        try {
            if (obj instanceof RouteMessage) {
                this.record(action, ((RouteMessage)obj).unwrap(), size, path);
                recorded = true;
            } else if (obj instanceof PastryEndpointMessage) {
                this.record(action, ((PastryEndpointMessage)obj).getMessage(), size, path);
                recorded = true;
            }
        }
        catch (NoClassDefFoundError exc) {
            // empty catch block
        }
        if (!recorded && this.logger.level <= 400) {
            this.logger.log("COUNT: " + action + " message " + obj.getClass() + " of size " + size + " to " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(SocketChannel sc) throws IOException {
        while (true) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                if (this.buffer == null) {
                    if (this.queue.isEmpty()) {
                        return true;
                    }
                    if (this.logger.level <= 400) {
                        this.logger.log("(W) About to serialize object " + this.queue.getFirst());
                    }
                    this.buffer = this.serialize(this.queue.getFirst());
                    if (this.buffer == null) {
                        this.queue.removeFirst();
                        return this.write(sc);
                    }
                    if (this.spn != null && this.spn instanceof SocketPastryNode) {
                        ((SocketPastryNode)this.spn).broadcastSentListeners(this.queue.getFirst(), this.path == null ? (InetSocketAddress)sc.socket().getRemoteSocketAddress() : this.path.getLastHop().address, this.buffer.limit(), 16);
                    }
                    this.record("Sent", this.queue.getFirst(), this.buffer.limit(), this.path);
                }
                int j = this.buffer.limit();
                int i = sc.write(this.buffer);
                this.record("Wrote " + i + " of " + j + " bytes of", this.queue.getFirst(), this.buffer.limit(), this.path);
                if (this.logger.level <= 300) {
                    this.logger.log("(W) Wrote " + i + " of " + j + " bytes to " + sc.socket().getRemoteSocketAddress());
                }
                if (this.buffer.remaining() != 0) {
                    return false;
                }
                if (this.logger.level <= 400) {
                    this.logger.log("(W) Finished writing message " + this.queue.getFirst() + " - queue now contains " + (this.queue.size() - 1) + " items");
                }
                this.queue.removeFirst();
                this.buffer = null;
            }
        }
    }

    private void addToQueue(Object o) {
        this.record("Enqueued", o, -1, this.path);
        if (this.queue.size() > 0 && o instanceof Message) {
            Object obj;
            int i;
            for (i = 1; !(i >= this.queue.size() || (obj = this.queue.get(i)) instanceof Message && ((Message)obj).getPriority() > ((Message)o).getPriority()); ++i) {
            }
            if (this.logger.level <= 400) {
                this.logger.log("COUNT: Enqueueing message " + o.getClass().getName() + " at location " + i + " in the pending queue (priority " + ((Message)o).getPriority() + ")");
            }
            this.queue.add(i, o);
        } else {
            this.queue.addLast(o);
        }
    }

    public ByteBuffer serialize(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return ByteBuffer.wrap((byte[])o);
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            int len = baos.toByteArray().length;
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos2);
            dos.writeInt(len);
            dos.flush();
            dos.write(baos.toByteArray());
            dos.flush();
            return ByteBuffer.wrap(baos2.toByteArray());
        }
        catch (InvalidClassException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Object to be serialized was an invalid class! [" + o + "]" + e);
            }
            throw new IOException("Invalid class during attempt to serialize.");
        }
        catch (NotSerializableException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Object to be serialized was not serializable! [" + o + "]" + e);
            }
            throw new IOException("Unserializable class during attempt to serialize.");
        }
        catch (NullPointerException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Object to be serialized caused null pointer exception! [" + o + "]" + e);
            }
            return null;
        }
        catch (Exception e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Object to be serialized caused excception! [" + e + "]" + e);
            }
            throw new IOException("Exception during attempt to serialize.");
        }
    }
}

