/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.PastryNode;
import rice.pastry.PastryObjectInputStream;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SourceRoute;

public class SocketChannelReader {
    public int SELECTOR_DESERIALIZATION_MAX_SIZE;
    private PastryNode spn;
    private int objectSize = -1;
    private ByteBuffer buffer;
    private ByteBuffer sizeBuffer;
    protected SourceRoute path;
    protected Environment environment;
    protected Logger logger;

    public SocketChannelReader(PastryNode spn, SourceRoute path) {
        this(spn.getEnvironment(), path);
        this.spn = spn;
    }

    public SocketChannelReader(Environment env, SourceRoute path) {
        this.environment = env;
        this.path = path;
        this.logger = env.getLogManager().getLogger(SocketChannelReader.class, null);
        this.sizeBuffer = ByteBuffer.allocateDirect(4);
        this.SELECTOR_DESERIALIZATION_MAX_SIZE = this.environment.getParameters().getInt("pastry_socket_reader_selector_deserialization_max_size");
    }

    protected void setPath(SourceRoute path) {
        this.path = path;
    }

    public Object read(final SocketChannel sc) throws IOException {
        int read;
        if (this.objectSize == -1) {
            read = sc.read(this.sizeBuffer);
            if (read == -1) {
                throw new IOException("Error on read - the channel has been closed.");
            }
            if (this.sizeBuffer.remaining() == 0) {
                this.initializeObjectBuffer(sc);
            } else {
                return null;
            }
        }
        if (this.objectSize != -1) {
            read = sc.read(this.buffer);
            if (this.logger.level <= 300) {
                this.logger.log("(R) Read " + read + " bytes of object..." + this.buffer.remaining());
            }
            if (read == -1) {
                throw new ClosedChannelException();
            }
            if (this.buffer.remaining() == 0) {
                this.buffer.flip();
                final byte[] objectArray = new byte[this.objectSize];
                this.buffer.get(objectArray);
                final int size = this.objectSize + 4;
                this.reset();
                if (size < this.SELECTOR_DESERIALIZATION_MAX_SIZE) {
                    Object obj = this.deserialize(objectArray);
                    if (obj != null) {
                        if (this.logger.level <= 400) {
                            this.logger.log("(R) Deserialized bytes into object " + obj);
                        }
                        if (this.spn != null && this.spn instanceof SocketPastryNode) {
                            ((SocketPastryNode)this.spn).broadcastReceivedListeners(obj, this.path == null ? (InetSocketAddress)sc.socket().getRemoteSocketAddress() : this.path.getLastHop().address, size, 16);
                        }
                        this.record(obj, size, this.path);
                        return obj;
                    }
                } else {
                    if (this.logger.level <= 800) {
                        this.logger.log("COUNT: Read message, but too big to deserialize on Selector thread");
                    }
                    ((SocketPastryNode)this.spn).process(new Executable(){

                        public String toString() {
                            return "Deserialization of message of size " + size + " from " + SocketChannelReader.this.path;
                        }

                        public Object execute() {
                            if (SocketChannelReader.this.logger.level <= 800) {
                                SocketChannelReader.this.logger.log("COUNT: Starting deserialization on message on processing thread");
                            }
                            try {
                                return SocketChannelReader.this.deserialize(objectArray);
                            }
                            catch (Exception e) {
                                return e;
                            }
                        }
                    }, new Continuation(){

                        public void receiveResult(Object o) {
                            if (SocketChannelReader.this.spn != null && SocketChannelReader.this.spn instanceof SocketPastryNode) {
                                ((SocketPastryNode)SocketChannelReader.this.spn).broadcastReceivedListeners(o, SocketChannelReader.this.path == null ? (InetSocketAddress)sc.socket().getRemoteSocketAddress() : SocketChannelReader.this.path.getLastHop().address, size, 16);
                            }
                            SocketChannelReader.this.record(o, size, SocketChannelReader.this.path);
                            if (o instanceof Message) {
                                SocketChannelReader.this.spn.receiveMessage((Message)o);
                            } else {
                                this.receiveException((Exception)o);
                            }
                        }

                        public void receiveException(Exception e) {
                            if (SocketChannelReader.this.logger.level <= 900) {
                                SocketChannelReader.this.logger.logException("Processing deserialization of message caused exception ", e);
                            }
                        }
                    });
                }
            }
        }
        return null;
    }

    protected void record(Object obj, int size, SourceRoute path) {
        boolean recorded = false;
        try {
            if (obj instanceof RouteMessage) {
                this.record(((RouteMessage)obj).unwrap(), size, path);
                recorded = true;
            } else if (obj instanceof PastryEndpointMessage) {
                this.record(((PastryEndpointMessage)obj).getMessage(), size, path);
                recorded = true;
            }
        }
        catch (NoClassDefFoundError exc) {
            // empty catch block
        }
        if (!recorded && this.logger.level <= 400) {
            this.logger.log("COUNT: Read message " + obj.getClass() + " of size " + size + " from " + path);
        }
    }

    public void reset() {
        this.objectSize = -1;
        this.buffer = null;
        this.sizeBuffer.clear();
    }

    private void initializeObjectBuffer(SocketChannel sc) throws IOException {
        this.sizeBuffer.flip();
        byte[] sizeArray = new byte[4];
        this.sizeBuffer.get(sizeArray, 0, 4);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(sizeArray));
        this.objectSize = dis.readInt();
        if (this.objectSize <= 0) {
            throw new IOException("Found message of improper number of bytes - " + this.objectSize + " bytes");
        }
        if (this.logger.level <= 400) {
            this.logger.log("(R) Found object of " + this.objectSize + " bytes from " + sc.socket().getRemoteSocketAddress());
        }
        try {
            this.buffer = ByteBuffer.allocateDirect(this.objectSize);
        }
        catch (OutOfMemoryError oome) {
            if (this.logger.level <= 1000) {
                this.logger.logException("SCR ran out of memory allocating an object of size " + this.objectSize + " from " + this.path, oome);
            }
            throw oome;
        }
    }

    private Object deserialize(byte[] array) throws IOException {
        PastryObjectInputStream ois = new PastryObjectInputStream(new ByteArrayInputStream(array), this.spn);
        Object o = null;
        try {
            Object ret = ois.readObject();
            return ret;
        }
        catch (ClassCastException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Serialized message was not a pastry message!");
            }
            throw new IOException("Message recieved " + o + " was not a pastry message - closing channel.");
        }
        catch (ClassNotFoundException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Unknown class type in serialized message!");
            }
            throw new IOException("Unknown class type in message - closing channel.");
        }
        catch (InvalidClassException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Serialized message was an invalid class! " + e.getMessage());
            }
            throw new IOException("Invalid class in message - closing channel.");
        }
        catch (IllegalStateException e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Serialized message caused an illegal state exception! " + e.getMessage());
            }
            throw new IOException("Illegal state from deserializing message - closing channel.");
        }
        catch (NullPointerException e) {
            if (this.logger.level <= 1000) {
                this.logger.logException("PANIC: Serialized message caused a null pointer exception! ", e);
            }
            return null;
        }
        catch (Exception e) {
            if (this.logger.level <= 1000) {
                this.logger.log("PANIC: Serialized message caused exception! " + e.getMessage());
            }
            throw new IOException("Exception from deserializing message - closing channel.");
        }
    }
}

