/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.socket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.WeakHashMap;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.environment.params.Parameters;
import rice.environment.time.TimeSource;
import rice.pastry.PastryObjectInputStream;
import rice.pastry.socket.EpochInetSocketAddress;
import rice.pastry.socket.PingResponseListener;
import rice.pastry.socket.SocketChannelRepeater;
import rice.pastry.socket.SocketPastryNode;
import rice.pastry.socket.SocketSourceRouteManager;
import rice.pastry.socket.SourceRoute;
import rice.pastry.socket.messaging.DatagramMessage;
import rice.pastry.socket.messaging.IPAddressRequestMessage;
import rice.pastry.socket.messaging.IPAddressResponseMessage;
import rice.pastry.socket.messaging.PingMessage;
import rice.pastry.socket.messaging.PingResponseMessage;
import rice.pastry.socket.messaging.WrongEpochMessage;
import rice.selector.SelectionKeyHandler;

public class PingManager
extends SelectionKeyHandler {
    public final boolean USE_SHORT_PINGS;
    public final int DATAGRAM_RECEIVE_BUFFER_SIZE;
    public final int DATAGRAM_SEND_BUFFER_SIZE;
    protected WeakHashMap pingListeners;
    protected WeakHashMap lastPingTime;
    protected ArrayList pendingMsgs;
    private ByteBuffer buffer;
    private DatagramChannel channel;
    private SelectionKey key;
    private SocketSourceRouteManager manager;
    private EpochInetSocketAddress localAddress;
    private SocketPastryNode spn;
    private Logger logger;
    private TimeSource timeSource;
    private Environment environment;
    long lastTimePrinted;
    public static final int PING_THROTTLE = 1500;
    protected static byte[] HEADER_PING = new byte[]{73, 58, 9, 92};
    protected static byte[] HEADER_SHORT_PING = new byte[]{49, 28, 14, 17};
    protected static byte[] HEADER_SHORT_PING_RESPONSE = new byte[]{49, 28, 14, 18};
    public static int HEADER_SIZE = HEADER_PING.length;

    public PingManager(SocketPastryNode spn, SocketSourceRouteManager manager, EpochInetSocketAddress bindAddress, EpochInetSocketAddress proxyAddress) {
        block2: {
            this.pingListeners = new WeakHashMap();
            this.lastPingTime = new WeakHashMap();
            this.lastTimePrinted = 0L;
            this.spn = spn;
            this.environment = spn.getEnvironment();
            this.logger = this.environment.getLogManager().getLogger(PingManager.class, null);
            this.timeSource = this.environment.getTimeSource();
            Parameters p = this.environment.getParameters();
            this.manager = manager;
            this.pendingMsgs = new ArrayList();
            this.localAddress = proxyAddress;
            this.USE_SHORT_PINGS = p.getBoolean("pastry_socket_pingmanager_smallPings");
            this.DATAGRAM_RECEIVE_BUFFER_SIZE = p.getInt("pastry_socket_pingmanager_datagram_receive_buffer_size");
            this.DATAGRAM_SEND_BUFFER_SIZE = p.getInt("pastry_socket_pingmanager_datagram_send_buffer_size");
            this.buffer = ByteBuffer.allocateDirect(this.DATAGRAM_SEND_BUFFER_SIZE);
            try {
                this.channel = DatagramChannel.open();
                this.channel.configureBlocking(false);
                this.channel.socket().setReuseAddress(true);
                this.channel.socket().bind(bindAddress.getAddress());
                this.channel.socket().setSendBufferSize(this.DATAGRAM_SEND_BUFFER_SIZE);
                this.channel.socket().setReceiveBufferSize(this.DATAGRAM_RECEIVE_BUFFER_SIZE);
                this.key = this.environment.getSelectorManager().register(this.channel, this, 0);
                this.key.interestOps(1);
            }
            catch (IOException e) {
                if (this.logger.level > 1000) break block2;
                this.logger.log("PANIC: Error binding datagram server to address " + this.localAddress + ": " + e);
            }
        }
    }

    protected void ping(SourceRoute path, PingResponseListener prl) {
        Long time;
        long curTime = this.timeSource.currentTimeMillis();
        if (prl == null && (time = (Long)this.lastPingTime.get(path)) != null && time + 1500L > curTime) {
            if (this.logger.level <= 500) {
                this.logger.log("(PM) Suppressing ping via path " + path + " local " + this.localAddress);
            }
            return;
        }
        if (this.logger.level <= 500) {
            this.logger.log("(PM) Actually sending ping via path " + path + " local " + this.localAddress);
        }
        this.lastPingTime.put(path, new Long(curTime));
        this.addPingResponseListener(path, prl);
        if (this.USE_SHORT_PINGS) {
            this.sendShortPing(path);
        } else {
            this.enqueue(path, new PingMessage(path, path.reverse(this.localAddress), this.environment.getTimeSource().currentTimeMillis()));
        }
    }

    protected void resign() throws IOException {
        if (this.key != null) {
            if (this.key.channel() != null) {
                this.key.channel().close();
            }
            this.key.cancel();
        }
    }

    public void stall() {
        this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
    }

    protected void sendShortPing(SourceRoute route) {
        block2: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.write(HEADER_SHORT_PING);
                dos.writeLong(this.environment.getTimeSource().currentTimeMillis());
                dos.flush();
                this.enqueue(route, baos.toByteArray());
            }
            catch (Exception canthappen) {
                if (this.logger.level > 1000) break block2;
                this.logger.log("CANT HAPPEN: " + canthappen);
            }
        }
    }

    protected void shortPingReceived(SourceRoute route, byte[] payload) throws IOException {
        System.arraycopy(HEADER_SHORT_PING_RESPONSE, 0, payload, 0, HEADER_SHORT_PING_RESPONSE.length);
        this.enqueue(route.reverse(), payload);
    }

    protected void shortPingResponseReceived(SourceRoute route, byte[] payload) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(payload));
        dis.readFully(new byte[HEADER_SHORT_PING_RESPONSE.length]);
        long start = dis.readLong();
        int ping = (int)(this.environment.getTimeSource().currentTimeMillis() - start);
        SourceRoute from = route.reverse();
        this.manager.markAlive(from);
        this.manager.markProximity(from, ping);
        this.notifyPingResponseListeners(from, ping, start);
    }

    protected void removePingResponseListener(SourceRoute path, PingResponseListener prl) {
        if (prl == null) {
            return;
        }
        ArrayList list = (ArrayList)this.pingListeners.get(path);
        if (list != null) {
            while (list.remove(prl)) {
            }
        }
    }

    protected void addPingResponseListener(SourceRoute path, PingResponseListener prl) {
        if (prl == null) {
            return;
        }
        ArrayList<PingResponseListener> list = (ArrayList<PingResponseListener>)this.pingListeners.get(path);
        if (list == null) {
            list = new ArrayList<PingResponseListener>();
            this.pingListeners.put(path, list);
        }
        list.add(prl);
    }

    protected void notifyPingResponseListeners(SourceRoute path, int proximity, long lastTimePinged) {
        ArrayList list = (ArrayList)this.pingListeners.remove(path);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ((PingResponseListener)i.next()).pingResponse(path, proximity, lastTimePinged);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(SourceRoute path, Object msg) {
        block13: {
            try {
                byte[] data = PingManager.addHeader(path, msg, this.localAddress, this.environment, this.logger);
                ArrayList arrayList = this.pendingMsgs;
                synchronized (arrayList) {
                    this.pendingMsgs.add(new Envelope(path.getFirstHop(), data));
                }
                if (this.spn != null) {
                    this.spn.broadcastSentListeners(msg, path.getLastHop().address, data.length, 1);
                }
                if (!(msg instanceof byte[])) {
                    if (this.logger.level <= 400) {
                        this.logger.log("COUNT: Sent message " + msg.getClass() + " of size " + data.length + " to " + path);
                    }
                } else if (((byte[])msg)[3] == 17) {
                    if (this.logger.level <= 400) {
                        this.logger.log("COUNT: Sent message rice.pastry.socket.messaging.ShortPingMessage of size " + data.length + " to " + path);
                    }
                } else if (((byte[])msg)[3] == 18 && this.logger.level <= 400) {
                    this.logger.log("COUNT: Sent message rice.pastry.socket.messaging.ShortPingResponseMessage of size " + data.length + " to " + path);
                }
                this.environment.getSelectorManager().modifyKey(this.key);
            }
            catch (IOException e) {
                if (this.logger.level > 1000) break block13;
                this.logger.log("ERROR: Received exceptoin " + e + " while enqueuing ping " + msg);
            }
        }
    }

    public void receiveMessage(Object message, int size, InetSocketAddress from) throws IOException {
        if (message instanceof DatagramMessage) {
            DatagramMessage dm = (DatagramMessage)message;
            long start = dm.getStartTime();
            SourceRoute path = dm.getInboundPath();
            if (path == null) {
                path = SourceRoute.build(new EpochInetSocketAddress(from));
            }
            if (this.spn != null) {
                this.spn.broadcastReceivedListeners(dm, path.reverse().getLastHop().address, size, 1);
            }
            if (dm instanceof PingMessage) {
                if (this.logger.level <= 400) {
                    this.logger.log("COUNT: Read message " + message.getClass() + " of size " + size + " from " + dm.getInboundPath().reverse());
                }
                this.enqueue(dm.getInboundPath(), new PingResponseMessage(dm.getOutboundPath(), dm.getInboundPath(), start));
            } else if (dm instanceof PingResponseMessage) {
                if (this.logger.level <= 400) {
                    this.logger.log("COUNT: Read message " + message.getClass() + " of size " + size + " from " + dm.getOutboundPath().reverse());
                }
                int ping = (int)(this.environment.getTimeSource().currentTimeMillis() - start);
                this.manager.markAlive(dm.getOutboundPath());
                this.manager.markProximity(dm.getOutboundPath(), ping);
                this.notifyPingResponseListeners(dm.getOutboundPath(), ping, start);
            } else if (dm instanceof WrongEpochMessage) {
                WrongEpochMessage wem = (WrongEpochMessage)dm;
                if (this.logger.level <= 400) {
                    this.logger.log("COUNT: Read message " + message.getClass() + " of size " + size + " from " + dm.getOutboundPath().reverse());
                }
                this.manager.markAlive(dm.getOutboundPath());
                this.manager.markDead(wem.getIncorrect());
            } else if (dm instanceof IPAddressRequestMessage) {
                if (this.logger.level <= 400) {
                    this.logger.log("COUNT: Read message " + message.getClass() + " of size " + size + " from " + SourceRoute.build(new EpochInetSocketAddress(from)));
                }
                this.enqueue(SourceRoute.build(new EpochInetSocketAddress(from)), new IPAddressResponseMessage(from, this.environment.getTimeSource().currentTimeMillis()));
            } else if (this.logger.level <= 900) {
                this.logger.log("ERROR: Received unknown DatagramMessage " + dm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(SelectionKey key) {
        try {
            InetSocketAddress address = null;
            while ((address = (InetSocketAddress)this.channel.receive(this.buffer)) != null) {
                this.buffer.flip();
                if (this.buffer.remaining() > 0) {
                    this.readHeader(address);
                    continue;
                }
                if (this.logger.level <= 800) {
                    this.logger.log("(PM) Read from datagram channel, but no bytes were there - no bad, but wierd.");
                }
                break;
            }
        }
        catch (IOException e) {
            if (this.logger.level <= 900) {
                this.logger.logException("ERROR (datagrammanager:read): ", e);
            }
        }
        finally {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SelectionKey key) {
        Envelope write = null;
        try {
            ArrayList arrayList = this.pendingMsgs;
            synchronized (arrayList) {
                Iterator i = this.pendingMsgs.iterator();
                while (i.hasNext()) {
                    write = (Envelope)i.next();
                    try {
                        if (this.channel.send(ByteBuffer.wrap(write.data), write.destination.getAddress()) != write.data.length) break;
                        i.remove();
                    }
                    catch (IOException e) {
                        i.remove();
                        throw e;
                    }
                }
            }
        }
        catch (IOException e) {
            if (this.logger.level <= 900) {
                long now = this.timeSource.currentTimeMillis();
                if (this.lastTimePrinted + 1000L > now) {
                    return;
                }
                this.lastTimePrinted = now;
                this.logger.logException("ERROR (datagrammanager:write) to " + (write == null ? null : write.destination.getAddress()), e);
            }
        }
        finally {
            if (this.pendingMsgs.isEmpty()) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyKey(SelectionKey key) {
        ArrayList arrayList = this.pendingMsgs;
        synchronized (arrayList) {
            if (!this.pendingMsgs.isEmpty()) {
                key.interestOps(key.interestOps() | 4);
            }
        }
    }

    public SourceRoute decodeHeader(byte[] header) throws IOException {
        EpochInetSocketAddress[] route = new EpochInetSocketAddress[header.length / SocketChannelRepeater.HEADER_BUFFER_SIZE];
        for (int i = 0; i < route.length; ++i) {
            route[i] = SocketChannelRepeater.decodeHeader(header, i);
        }
        return SourceRoute.build(route);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readHeader(InetSocketAddress address) throws IOException {
        byte[] header = new byte[HEADER_SIZE];
        this.buffer.get(header);
        if (!Arrays.equals(header, HEADER_PING)) {
            if (this.logger.level > 900) throw new IOException("Improper message header received - ignoring from " + address + ". Read " + header[0] + " " + header[1] + " " + header[2] + " " + header[3]);
            this.logger.log("WARNING: Received unrecognized message header - ignoring from " + address + ".");
            throw new IOException("Improper message header received - ignoring from " + address + ". Read " + header[0] + " " + header[1] + " " + header[2] + " " + header[3]);
        }
        byte[] metadata = new byte[2];
        this.buffer.get(metadata);
        byte[] route = new byte[SocketChannelRepeater.HEADER_BUFFER_SIZE * metadata[1]];
        this.buffer.get(route);
        EpochInetSocketAddress eisa = SocketChannelRepeater.decodeHeader(route, metadata[0]);
        if (eisa.equals(this.localAddress) || eisa.getAddress().equals(this.localAddress.getAddress()) && eisa.getEpoch() == -1L) {
            if (metadata[0] + 1 == metadata[1]) {
                byte[] array = new byte[this.buffer.remaining()];
                this.buffer.get(array);
                this.buffer.clear();
                byte[] test = new byte[HEADER_SHORT_PING.length];
                System.arraycopy(array, 0, test, 0, test.length);
                SourceRoute sr = this.decodeHeader(route).removeLastHop();
                if (Arrays.equals(test, HEADER_SHORT_PING)) {
                    int len = header.length + metadata.length + array.length + route.length;
                    if (this.logger.level <= 400) {
                        this.logger.log("COUNT: Read message rice.pastry.socket.messaging.ShortPingMessage of size " + len + " from " + sr);
                    }
                    if (this.spn != null) {
                        this.spn.broadcastReceivedListeners(array, address, len, 1);
                    }
                    this.shortPingReceived(sr, array);
                    return;
                }
                if (!Arrays.equals(test, HEADER_SHORT_PING_RESPONSE)) {
                    this.receiveMessage(PingManager.deserialize(array, this.environment, this.spn, this.logger), array.length, address);
                    return;
                }
                int len = header.length + metadata.length + array.length + route.length;
                if (this.logger.level <= 400) {
                    this.logger.log("COUNT: Read message rice.pastry.socket.messaging.ShortPingResponseMessage of size " + len + " from " + sr);
                }
                if (this.spn != null) {
                    this.spn.broadcastReceivedListeners(array, address, len, 1);
                }
                this.shortPingResponseReceived(sr, array);
                return;
            }
            EpochInetSocketAddress next = SocketChannelRepeater.decodeHeader(route, metadata[0] + 1);
            this.buffer.position(0);
            byte[] packet = new byte[this.buffer.remaining()];
            this.buffer.get(packet);
            int n = HEADER_SIZE;
            packet[n] = (byte)(packet[n] + 1);
            if (this.spn != null) {
                this.spn.broadcastReceivedListeners(packet, address, packet.length, 257);
                this.spn.broadcastSentListeners(packet, next.address, packet.length, 257);
            }
            ArrayList sr = this.pendingMsgs;
            synchronized (sr) {
                this.pendingMsgs.add(new Envelope(next, packet));
            }
            this.environment.getSelectorManager().modifyKey(this.key);
            return;
        }
        if (!eisa.getAddress().equals(this.localAddress.getAddress())) {
            if (this.logger.level > 900) throw new IOException("Received packet destined for EISA (" + metadata[0] + " " + metadata[1] + ") " + eisa + " but the local address is " + this.localAddress + " - dropping silently.");
            this.logger.log("WARNING: Received packet destined for EISA (" + metadata[0] + " " + metadata[1] + ") " + eisa + " but the local address is " + this.localAddress + " - dropping silently.");
            throw new IOException("Received packet destined for EISA (" + metadata[0] + " " + metadata[1] + ") " + eisa + " but the local address is " + this.localAddress + " - dropping silently.");
        }
        SourceRoute back = SourceRoute.build(new EpochInetSocketAddress[0]);
        SourceRoute outbound = SourceRoute.build(new EpochInetSocketAddress[0]);
        int i = 0;
        while (true) {
            if (i >= metadata[0]) {
                outbound = outbound.append(this.localAddress);
                this.enqueue(back.reverse(), new WrongEpochMessage(outbound, back.reverse(), eisa, this.localAddress, this.environment.getTimeSource().currentTimeMillis()));
                return;
            }
            back = back.append(SocketChannelRepeater.decodeHeader(route, i));
            if (i > 0) {
                outbound = outbound.append(SocketChannelRepeater.decodeHeader(route, i));
            }
            ++i;
        }
    }

    public static byte[] serialize(Object message, Environment environment, Logger logger) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(message);
            oos.close();
            byte[] ret = baos.toByteArray();
            return ret;
        }
        catch (InvalidClassException e) {
            if (logger.level <= 1000) {
                logger.logException("PANIC: Object to be serialized was an invalid class!", e);
            }
            throw new IOException("Invalid class during attempt to serialize.");
        }
        catch (NotSerializableException e) {
            if (logger.level <= 1000) {
                logger.logException("PANIC: Object to be serialized was not serializable! [" + message + "]", e);
            }
            throw new IOException("Unserializable class " + message + " during attempt to serialize.");
        }
    }

    public static Object deserialize(byte[] array, Environment env, SocketPastryNode spn, Logger logger) throws IOException {
        PastryObjectInputStream ois = new PastryObjectInputStream(new ByteArrayInputStream(array), spn);
        try {
            Object ret = ois.readObject();
            return ret;
        }
        catch (ClassNotFoundException e) {
            if (logger.level <= 1000) {
                logger.logException("PANIC: Unknown class type in serialized message!", e);
            }
            throw new IOException("Unknown class type in message - closing channel.");
        }
        catch (InvalidClassException e) {
            if (logger.level <= 1000) {
                logger.logException("PANIC: Serialized message was an invalid class!", e);
            }
            throw new IOException("Invalid class in message - closing channel.");
        }
    }

    public static byte[] addHeader(SourceRoute path, Object data, EpochInetSocketAddress localAddress, Environment env, Logger logger) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(HEADER_PING);
        dos.write(1);
        dos.write((byte)path.getNumHops() + 1);
        dos.write(SocketChannelRepeater.encodeHeader(localAddress));
        for (int i = 0; i < path.getNumHops(); ++i) {
            dos.write(SocketChannelRepeater.encodeHeader(path.getHop(i)));
        }
        if (data instanceof byte[]) {
            dos.write((byte[])data);
        } else {
            dos.write(PingManager.serialize(data, env, logger));
        }
        dos.flush();
        return baos.toByteArray();
    }

    public class Envelope {
        protected EpochInetSocketAddress destination;
        protected byte[] data;

        public Envelope(EpochInetSocketAddress destination, byte[] data) {
            this.destination = destination;
            this.data = data;
        }
    }
}

