/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.Serializable;
import rice.p2p.commonapi.Message;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.Address;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;

public class RouteMessage
extends rice.pastry.messaging.Message
implements Serializable,
rice.p2p.commonapi.RouteMessage {
    private Id target;
    private rice.pastry.messaging.Message internalMsg;
    private NodeHandle prevNode;
    private transient SendOptions opts;
    private Address auxAddress;
    public transient NodeHandle nextHop;
    private static final long serialVersionUID = 3492981895989180093L;

    public RouteMessage(Id target, rice.pastry.messaging.Message msg, Credentials cred) {
        super(new RouterAddress());
        this.target = target;
        this.internalMsg = msg;
        this.opts = new SendOptions();
        this.nextHop = null;
    }

    public RouteMessage(Id target, rice.pastry.messaging.Message msg, Credentials cred, SendOptions opts) {
        super(new RouterAddress());
        this.target = target;
        this.internalMsg = msg;
        this.opts = opts;
        this.nextHop = null;
    }

    public RouteMessage(NodeHandle dest, rice.pastry.messaging.Message msg, Credentials cred, SendOptions opts, Address aux) {
        super(new RouterAddress());
        this.target = dest.getNodeId();
        this.internalMsg = msg;
        this.opts = opts;
        this.nextHop = dest;
        this.auxAddress = aux;
    }

    public RouteMessage(Id target, rice.pastry.messaging.Message msg, Credentials cred, Address aux) {
        super(new RouterAddress());
        this.target = target;
        this.internalMsg = msg;
        this.opts = new SendOptions();
        this.auxAddress = aux;
        this.nextHop = null;
    }

    public RouteMessage(Id target, rice.pastry.messaging.Message msg, Credentials cred, SendOptions opts, Address aux) {
        super(new RouterAddress());
        this.target = target;
        this.internalMsg = msg;
        this.opts = opts;
        this.auxAddress = aux;
        this.nextHop = null;
    }

    public RouteMessage(Id target, rice.pastry.messaging.Message msg, NodeHandle firstHop, Address aux) {
        super(new RouterAddress());
        this.target = target;
        this.internalMsg = msg;
        this.opts = new SendOptions();
        this.auxAddress = aux;
        this.nextHop = firstHop;
    }

    public Id getTarget() {
        return this.target;
    }

    public NodeHandle getPrevNode() {
        return this.prevNode;
    }

    public NodeHandle getNextHop() {
        return this.nextHop;
    }

    public int getPriority() {
        return this.internalMsg.getPriority();
    }

    public Address getDestination() {
        if (this.nextHop == null || this.auxAddress == null) {
            return super.getDestination();
        }
        return this.auxAddress;
    }

    public SendOptions getOptions() {
        if (this.opts == null) {
            this.opts = new SendOptions();
        }
        return this.opts;
    }

    public rice.p2p.commonapi.Id getDestinationId() {
        return this.getTarget();
    }

    public rice.p2p.commonapi.NodeHandle getNextHopHandle() {
        return this.nextHop;
    }

    public Message getMessage() {
        return ((PastryEndpointMessage)this.unwrap()).getMessage();
    }

    public void setPrevNode(NodeHandle n) {
        this.prevNode = n;
    }

    public void setNextHop(NodeHandle nh) {
        this.nextHop = nh;
    }

    public void setDestinationId(rice.p2p.commonapi.Id id) {
        this.target = (Id)id;
    }

    public void setNextHopHandle(rice.p2p.commonapi.NodeHandle nextHop) {
        this.nextHop = (NodeHandle)nextHop;
    }

    public void setMessage(Message message) {
        ((PastryEndpointMessage)this.unwrap()).setMessage(message);
    }

    public boolean routeMessage(NodeHandle localHandle) {
        if (this.nextHop == null) {
            return false;
        }
        this.setSender(localHandle);
        NodeHandle handle = this.nextHop;
        this.nextHop = null;
        if (localHandle.equals(handle)) {
            localHandle.getLocalNode().send(handle, this.internalMsg);
        } else {
            localHandle.getLocalNode().send(handle, this);
        }
        return true;
    }

    public rice.pastry.messaging.Message unwrap() {
        return this.internalMsg;
    }

    public String toString() {
        String str = "";
        str = str + "[ " + this.internalMsg + " ]";
        return str;
    }
}

