/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.messaging;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import rice.environment.logging.Logger;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;

public class MessageDispatch {
    private int bufferSize;
    private HashMap addressBook;
    private Hashtable buffer;
    private int bufferCount;
    protected PastryNode localNode;
    private boolean bufferIfNotReady;
    protected Logger logger;
    public static final String BUFFER_IF_NOT_READY_PARAM = "pastry_messageDispatch_bufferIfNotReady";
    public static final String BUFFER_SIZE_PARAM = "pastry_messageDispatch_bufferSize";

    public MessageDispatch(PastryNode pn) {
        this.bufferIfNotReady = pn.getEnvironment().getParameters().getBoolean(BUFFER_IF_NOT_READY_PARAM);
        this.bufferSize = pn.getEnvironment().getParameters().getInt(BUFFER_SIZE_PARAM);
        this.addressBook = new HashMap();
        this.buffer = new Hashtable();
        this.bufferCount = 0;
        this.localNode = pn;
        this.logger = pn.getEnvironment().getLogManager().getLogger(this.getClass(), null);
    }

    public MessageReceiver getDestination(Message msg) {
        MessageReceiver mr = (MessageReceiver)this.addressBook.get(msg.getDestination());
        return mr;
    }

    public MessageReceiver getDestinationByAddress(Address addr) {
        MessageReceiver mr = (MessageReceiver)this.addressBook.get(addr);
        return mr;
    }

    public void registerReceiver(Address address, MessageReceiver receiver) {
        if (this.addressBook.get(address) != null && this.logger.level <= 1000) {
            this.logger.log("ERROR - Registering receiver for already-registered address " + address);
        }
        this.addressBook.put(address, receiver);
    }

    public boolean dispatchMessage(Message msg) {
        if (msg.getDestination() == null) {
            Logger logger = this.localNode.getEnvironment().getLogManager().getLogger(MessageDispatch.class, null);
            if (logger.level <= 900) {
                logger.logException("Message " + msg + "," + msg.getClass().getName() + " has no destination.", new Exception("Stack Trace"));
            }
            return false;
        }
        MessageReceiver mr = (MessageReceiver)this.addressBook.get(msg.getDestination());
        if (mr != null && (!(mr instanceof PastryAppl) || ((PastryAppl)mr).deliverWhenNotReady() || this.localNode.isReady())) {
            Address address = msg.getDestination();
            this.deliverBuffered(address);
            mr.receiveMessage(msg);
            return true;
        }
        if (this.bufferCount <= this.bufferSize && (this.localNode.isReady() || this.bufferIfNotReady)) {
            Vector<Message> vector = (Vector<Message>)this.buffer.get(msg.getDestination());
            if (vector == null) {
                vector = new Vector<Message>();
                this.buffer.put(msg.getDestination(), vector);
            }
            if (this.logger.level <= 800) {
                this.logger.log("Buffering message " + msg + " because the application address " + msg.getDestination() + " is unknown." + "Message will be delivered when the an application with that address is registered.");
            }
            vector.add(msg);
            ++this.bufferCount;
        } else if (this.localNode.isReady()) {
            if (this.logger.level <= 900) {
                this.logger.log("Could not dispatch message " + msg + " because the application address " + msg.getDestination() + " was unknown." + "Message is going to be dropped on the floor.");
            }
        } else if (this.logger.level <= 900) {
            this.logger.log("Could not dispatch message " + msg + " because the pastry node is not yet ready." + "Message is going to be dropped on the floor.");
        }
        return false;
    }

    protected void deliverBuffered(Address address) {
        Vector vector;
        MessageReceiver mr = (MessageReceiver)this.addressBook.get(address);
        if (mr != null && (!(mr instanceof PastryAppl) || ((PastryAppl)mr).deliverWhenNotReady() || this.localNode.isReady()) && (vector = (Vector)this.buffer.remove(address)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                mr.receiveMessage((Message)vector.elementAt(i));
                --this.bufferCount;
            }
        }
    }

    public void deliverAllBufferedMessages() {
        for (Address addr : ((Hashtable)this.buffer.clone()).keySet()) {
            this.deliverBuffered(addr);
        }
    }

    public void destroy() {
        for (MessageReceiver mr : this.addressBook.values()) {
            if (!(mr instanceof PastryAppl)) continue;
            ((PastryAppl)mr).destroy();
        }
        this.addressBook.clear();
    }
}

