/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.messaging;

import java.io.Serializable;
import java.util.Date;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.messaging.Address;
import rice.pastry.security.Credentials;

public abstract class Message
implements Serializable {
    private Address destination;
    private NodeHandle sender;
    private boolean priority;
    private int priorityLevel = 5;
    private transient Credentials credentials;
    private transient Date theStamp;
    private static final long serialVersionUID = 8921944904321235696L;
    public static final int DEFAULT_PRIORITY_LEVEL = 5;

    public Message(Address dest) {
        this.destination = dest;
        this.sender = null;
        this.credentials = null;
        this.theStamp = null;
        this.priority = false;
    }

    public Message(Address dest, Credentials cred) {
        this.destination = dest;
        this.sender = null;
        this.credentials = cred;
        this.theStamp = null;
        this.priority = false;
    }

    public Message(Address dest, Credentials cred, Date timestamp) {
        this.destination = dest;
        this.sender = null;
        this.credentials = cred;
        this.theStamp = timestamp;
        this.priority = false;
    }

    public Message(Address dest, Date timestamp) {
        this.destination = dest;
        this.theStamp = timestamp;
        this.sender = null;
        this.priority = false;
    }

    public Address getDestination() {
        return this.destination;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Date getDate() {
        return this.theStamp;
    }

    public NodeId getSenderId() {
        if (this.sender == null) {
            return null;
        }
        return this.sender.getNodeId();
    }

    public NodeHandle getSender() {
        return this.sender;
    }

    public int getPriority() {
        return this.priorityLevel;
    }

    public void setSender(NodeHandle nh) {
        this.sender = nh;
    }

    protected void setPriority(int prio) {
        this.priorityLevel = prio;
    }

    public boolean stamp(Date time) {
        if (this.theStamp.equals(null)) {
            this.theStamp = time;
            return true;
        }
        return false;
    }
}

