/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.join;

import java.io.Serializable;
import java.util.Date;
import rice.pastry.NodeHandle;
import rice.pastry.join.JoinAddress;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteSet;
import rice.pastry.security.Credentials;

public class JoinRequest
extends Message
implements Serializable {
    private NodeHandle handle;
    private NodeHandle joinHandle;
    private int rowCount;
    private RouteSet[][] rows;
    private LeafSet leafSet;
    static final long serialVersionUID = 231671018732832563L;

    public JoinRequest(NodeHandle nh, int rtBase) {
        super(new JoinAddress());
        this.handle = nh;
        this.initialize(rtBase);
        this.setPriority(0);
    }

    public JoinRequest(NodeHandle nh, Date stamp, int rtBase) {
        super((Address)new JoinAddress(), stamp);
        this.handle = nh;
        this.initialize(rtBase);
        this.setPriority(0);
    }

    public JoinRequest(NodeHandle nh, Credentials cred, int rtBase) {
        super((Address)new JoinAddress(), cred);
        this.handle = nh;
        this.initialize(rtBase);
        this.setPriority(0);
    }

    public JoinRequest(NodeHandle nh, Credentials cred, Date stamp, int rtBase) {
        super(new JoinAddress(), cred, stamp);
        this.handle = nh;
        this.initialize(rtBase);
        this.setPriority(0);
    }

    public NodeHandle getHandle() {
        return this.handle;
    }

    public NodeHandle getJoinHandle() {
        return this.joinHandle;
    }

    public LeafSet getLeafSet() {
        return this.leafSet;
    }

    public RouteSet[] getRow(int i) {
        return this.rows[i];
    }

    public boolean accepted() {
        return this.joinHandle != null;
    }

    public void acceptJoin(NodeHandle nh, LeafSet ls) {
        this.joinHandle = nh;
        this.leafSet = ls;
    }

    public int lastRow() {
        return this.rowCount;
    }

    public void pushRow(RouteSet[] row) {
        this.rows[--this.rowCount] = row;
    }

    public int numRows() {
        return this.rows.length;
    }

    private void initialize(int rtBaseBitLength) {
        this.joinHandle = null;
        this.rowCount = 160 / rtBaseBitLength;
        this.rows = new RouteSet[this.rowCount][];
    }

    public String toString() {
        return "JoinRequest(" + (this.handle != null ? this.handle.getNodeId() : null) + "," + (this.joinHandle != null ? this.joinHandle.getNodeId() : null) + ")";
    }
}

