/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import rice.environment.Environment;
import rice.pastry.direct.BasicNetworkSimulator;
import rice.pastry.direct.NodeRecord;

public class SphereNetwork
extends BasicNetworkSimulator {
    public SphereNetwork(Environment env) {
        super(env);
    }

    public NodeRecord generateNodeRecord() {
        return new SphereNodeRecord();
    }

    private class SphereNodeRecord
    implements NodeRecord {
        public double theta;
        public double phi;

        public SphereNodeRecord() {
            this.theta = Math.asin(2.0 * SphereNetwork.this.random.nextDouble() - 1.0);
            this.phi = Math.PI * 2 * SphereNetwork.this.random.nextDouble();
        }

        public int proximity(NodeRecord that) {
            SphereNodeRecord nr = (SphereNodeRecord)that;
            return (int)(10000.0 * Math.acos(Math.cos(this.phi - nr.phi) * Math.cos(this.theta) * Math.cos(nr.theta) + Math.sin(this.theta) * Math.sin(nr.theta)));
        }
    }
}

