/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import rice.environment.Environment;
import rice.pastry.direct.BasicNetworkSimulator;
import rice.pastry.direct.NodeRecord;

public class GenericNetwork
extends BasicNetworkSimulator {
    private int countIndex = 0;
    private int[][] distance;
    public Hashtable nodePos = new Hashtable();
    public Vector assignedIndices = new Vector();
    public String inFile_Matrix = "GNPINPUT";
    public String inFile_Coord = "COORD";
    public String outFile_RawGNPError = "RawGNPError";
    public static int MAXOVERLAYSIZE = 1000;

    public GenericNetwork(Environment env, String inFile) {
        super(env);
        MAXOVERLAYSIZE = env.getParameters().getInt("pastry_direct_gtitm_max_overlay_size");
        this.inFile_Matrix = inFile;
        if (this.inFile_Matrix == null) {
            this.inFile_Matrix = env.getParameters().getString("pastry_direct_gtitm_matrix_file");
        }
        this.readOverlayMatrix();
    }

    public NodeRecord generateNodeRecord() {
        return new GNNodeRecord();
    }

    public void readOverlayMatrix() {
        FileReader fr = null;
        try {
            fr = new FileReader(this.inFile_Matrix);
        }
        catch (Exception e) {
            System.out.println("ERROR: The required inter-host distance matrix for Generic Network not found");
            System.exit(1);
        }
        BufferedReader in = new BufferedReader(fr);
        int lineCount = 0;
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                String[] words = line.split("[ \t]+");
                if (this.distance == null) {
                    MAXOVERLAYSIZE = words.length;
                    this.distance = new int[MAXOVERLAYSIZE][MAXOVERLAYSIZE];
                }
                int nodeCount = 0;
                for (int i = 0; i < MAXOVERLAYSIZE; ++i) {
                    if (words[i].length() <= 0) continue;
                    this.distance[lineCount][nodeCount] = (int)Float.parseFloat(words[i]);
                    ++nodeCount;
                }
                ++lineCount;
            }
            System.out.println("Size of Generic Network matrix= " + lineCount);
        }
        catch (IOException e) {
            System.out.println("Exception" + e);
        }
    }

    public void readOverlayPos() {
        BufferedReader fin = null;
        try {
            String[] words;
            fin = new BufferedReader(new FileReader(this.inFile_Coord));
            String line = fin.readLine();
            while (line != null && !(words = line.split("[ \t]+"))[0].equals("Done")) {
                if (words[0].equals("##index=")) {
                    double[] pos = new double[Coordinate.GNPDIMENSIONS];
                    int index = Integer.parseInt(words[1]);
                    for (int i = 0; i < Coordinate.GNPDIMENSIONS; ++i) {
                        pos[i] = Double.parseDouble(words[2 + i]);
                    }
                    Coordinate state = new Coordinate(index, pos);
                    this.nodePos.put(new Integer(index), state);
                }
                line = fin.readLine();
            }
            fin.close();
        }
        catch (IOException e) {
            System.out.println("ERROR: In opening input/output files");
        }
    }

    public void computeRawGNPError() {
        BufferedWriter fout = null;
        try {
            String s = "";
            fout = new BufferedWriter(new FileWriter(this.outFile_RawGNPError));
            for (int i = 0; i < MAXOVERLAYSIZE; ++i) {
                for (int j = 0; j < MAXOVERLAYSIZE; ++j) {
                    double min;
                    double actual = this.distance[i][j];
                    Coordinate state_i = (Coordinate)this.nodePos.get(new Integer(i));
                    Coordinate state_j = (Coordinate)this.nodePos.get(new Integer(j));
                    double predicted = state_i.distance(state_j);
                    if (actual == -1.0 || !((min = actual < predicted ? actual : predicted) > 0.0)) continue;
                    double gnpError = 0.0;
                    gnpError = Math.abs(predicted - actual) / min;
                    s = "" + gnpError;
                    fout.write(s, 0, s.length());
                    fout.newLine();
                    fout.flush();
                }
            }
        }
        catch (IOException e) {
            System.out.println("ERROR: In opening input/output files");
        }
    }

    public static class Coordinate
    implements Serializable {
        public int index;
        public double[] pos = new double[GNPDIMENSIONS];
        public static int GNPDIMENSIONS = 8;

        public Coordinate(int _index, double[] arr) {
            for (int i = 0; i < GNPDIMENSIONS; ++i) {
                this.pos[i] = arr[i];
            }
        }

        public double distance(Coordinate o) {
            double[] dpos = new double[GNPDIMENSIONS];
            double sumDist = 0.0;
            for (int i = 0; i < GNPDIMENSIONS; ++i) {
                dpos[i] = Math.abs(o.pos[i] - this.pos[i]);
                sumDist += dpos[i] * dpos[i];
            }
            double dist = Math.sqrt(sumDist);
            return dist;
        }

        public String toString() {
            String s = "(";
            for (int i = 0; i < GNPDIMENSIONS; ++i) {
                s = s + this.pos[i] + ",";
            }
            s = s + ")";
            return s;
        }
    }

    private class GNNodeRecord
    implements NodeRecord {
        public boolean alive;
        public int index;

        public GNNodeRecord() {
            if (GenericNetwork.this.countIndex >= MAXOVERLAYSIZE) {
                throw new RuntimeException("No more nodes int he network.");
            }
            this.alive = true;
            this.index = GenericNetwork.this.random.nextInt(MAXOVERLAYSIZE);
            while (GenericNetwork.this.assignedIndices.contains(new Integer(this.index))) {
                this.index = GenericNetwork.this.random.nextInt(MAXOVERLAYSIZE);
            }
            GenericNetwork.this.assignedIndices.add(new Integer(this.index));
            GenericNetwork.this.countIndex++;
        }

        public int getIndex() {
            return this.index;
        }

        public int proximity(NodeRecord that) {
            GNNodeRecord nr = (GNNodeRecord)that;
            int res = GenericNetwork.this.distance[this.index][nr.index];
            if (res < 0) {
                return Integer.MAX_VALUE;
            }
            return res;
        }
    }
}

