/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.Hashtable;
import rice.environment.Environment;
import rice.environment.logging.Logger;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.ScheduledMessage;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.NodeRecord;
import rice.pastry.join.InitiateJoin;
import rice.pastry.messaging.Message;
import rice.selector.Timer;

public class DirectPastryNode
extends PastryNode {
    private NetworkSimulator simulator;
    protected boolean alive = true;
    NodeRecord record;
    protected Timer timer;
    Hashtable nodeHandles = new Hashtable();
    public static DirectPastryNode currentNode = null;

    public DirectPastryNode(NodeId id, NetworkSimulator sim, Environment e, NodeRecord nr) {
        super(id, e);
        this.timer = e.getSelectorManager().getTimer();
        this.simulator = sim;
        this.record = nr;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setDirectElements() {
    }

    public void doneNode(NodeHandle bootstrap) {
        this.initiateJoin(bootstrap);
    }

    public void destroy() {
        super.destroy();
        this.alive = false;
        this.setReady(false);
        this.simulator.removeNode(this);
    }

    public final void initiateJoin(NodeHandle bootstrap) {
        NodeHandle[] boots = new NodeHandle[]{bootstrap};
        this.initiateJoin(boots);
    }

    public final void initiateJoin(NodeHandle[] bootstrap) {
        if (bootstrap != null && bootstrap[0] != null) {
            this.simulator.deliverMessage(new InitiateJoin(bootstrap), this);
        } else {
            this.setReady();
        }
    }

    public final void nodeIsReady() {
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay) {
        return this.simulator.deliverMessage(msg, this, (int)delay);
    }

    public ScheduledMessage scheduleMsg(Message msg, long delay, long period) {
        return this.simulator.deliverMessage(msg, this, (int)delay, (int)period);
    }

    public ScheduledMessage scheduleMsgAtFixedRate(Message msg, long delay, long period) {
        return this.simulator.deliverMessageFixedRate(msg, this, (int)delay, (int)period);
    }

    public NodeHandle coalesce(NodeHandle newHandle) {
        NodeHandle ret = (NodeHandle)this.nodeHandles.get(newHandle);
        if (ret == null) {
            this.nodeHandles.put(newHandle, newHandle);
            ret = newHandle;
        }
        return ret;
    }

    public synchronized void receiveMessage(Message msg) {
        if (!this.getEnvironment().getSelectorManager().isSelectorThread()) {
            this.simulator.deliverMessage(msg, this);
            return;
        }
        DirectPastryNode temp = currentNode;
        currentNode = this;
        super.receiveMessage(msg);
        currentNode = temp;
    }

    public void send(NodeHandle handle, Message message) {
        handle.receiveMessage(message);
    }
}

