/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.direct;

import java.util.Observable;
import java.util.Observer;
import rice.environment.logging.Logger;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Message;

public class DirectNodeHandle
extends NodeHandle
implements Observer {
    private DirectPastryNode remoteNode;
    public NetworkSimulator simulator;
    protected Logger logger;

    DirectNodeHandle(DirectPastryNode ln, DirectPastryNode rn, NetworkSimulator sim) {
        this.localnode = ln;
        this.logger = ln.getEnvironment().getLogManager().getLogger(this.getClass(), null);
        if (rn == null) {
            throw new IllegalArgumentException("rn must be non-null");
        }
        this.remoteNode = rn;
        this.simulator = sim;
        rn.addObserver(this);
    }

    public DirectPastryNode getRemote() {
        return this.remoteNode;
    }

    public NodeId getNodeId() {
        return this.remoteNode.getNodeId();
    }

    public int getLiveness() {
        if (this.remoteNode.isAlive()) {
            return 1;
        }
        return 3;
    }

    public NetworkSimulator getSimulator() {
        return this.simulator;
    }

    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    public boolean ping() {
        return this.isAlive();
    }

    public final void assertLocalNode() {
        if (DirectPastryNode.currentNode == null) {
            throw new RuntimeException("PANIC: localnode is null in " + this + "@" + System.identityHashCode(this));
        }
    }

    public int proximity() {
        this.assertLocalNode();
        if (!this.simulator.getEnvironment().getSelectorManager().isSelectorThread()) {
            throw new RuntimeException("Must be called on selector thread.");
        }
        int result = this.simulator.proximity((DirectNodeHandle)DirectPastryNode.currentNode.getLocalHandle(), this);
        return result;
    }

    public void receiveMessage(Message msg) {
        if (this.simulator.getEnvironment().getSelectorManager().isSelectorThread() && this.remoteNode == DirectPastryNode.currentNode) {
            this.remoteNode.receiveMessage(msg);
            return;
        }
        if (!this.remoteNode.isAlive()) {
            if (this.logger.level <= 900) {
                this.logger.log("DirectNodeHandle: attempt to send message " + msg + " to a dead node " + this.getNodeId() + "!");
            }
        } else {
            this.simulator.deliverMessage(msg, this.remoteNode);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        NodeHandle nh = (NodeHandle)obj;
        return this.getNodeId().equals(nh.getNodeId());
    }

    public int hashCode() {
        return this.getNodeId().hashCode();
    }

    public String toString() {
        return "[DNH " + this.getNodeId() + "]";
    }

    public void update(Observable arg0, Object arg1) {
        if (this.remoteNode.alive) {
            this.notifyObservers(NodeHandle.DECLARED_LIVE);
        } else {
            this.notifyObservers(NodeHandle.DECLARED_DEAD);
        }
    }
}

