/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.commonapi;

import java.security.InvalidParameterException;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.CancellableTask;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.NodeHandleSet;
import rice.p2p.commonapi.RouteMessage;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;

public class PastryEndpoint
extends PastryAppl
implements Endpoint {
    protected Credentials credentials = new PermissiveCredentials();
    protected Application application;
    protected String instance;

    public PastryEndpoint(PastryNode pn, Application application, String instance) {
        super(pn, application.getClass().getName() + instance, null);
        this.instance = application.getClass().getName() + instance;
        this.application = application;
        this.register();
    }

    public PastryEndpoint(PastryNode pn, Application application, int port) {
        super(pn, port);
        this.instance = "[PORT " + port + "]";
        this.application = application;
        this.register();
    }

    public rice.p2p.commonapi.Id getId() {
        return this.thePastryNode.getNodeId();
    }

    public rice.p2p.commonapi.NodeHandle getLocalNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getInstance() {
        return this.instance;
    }

    public Environment getEnvironment() {
        return this.thePastryNode.getEnvironment();
    }

    public void route(rice.p2p.commonapi.Id key, rice.p2p.commonapi.Message msg, rice.p2p.commonapi.NodeHandle hint) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] route " + msg + " to " + key);
        }
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        if (key == null && hint == null) {
            throw new InvalidParameterException("key and hint are null!");
        }
        boolean noKey = false;
        if (key == null) {
            noKey = true;
            key = hint.getId();
        }
        rice.pastry.routing.RouteMessage rm = new rice.pastry.routing.RouteMessage((Id)key, (Message)pm, (NodeHandle)hint, this.getAddress());
        if (noKey) {
            rm.getOptions().setMultipleHopsAllowed(false);
        }
        this.thePastryNode.receiveMessage(rm);
    }

    public CancellableTask scheduleMessage(rice.p2p.commonapi.Message message, long delay) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), message, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsg(pm, delay);
    }

    public CancellableTask scheduleMessage(rice.p2p.commonapi.Message message, long delay, long period) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), message, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsg(pm, delay, period);
    }

    public CancellableTask scheduleMessageAtFixedRate(rice.p2p.commonapi.Message msg, long delay, long period) {
        PastryEndpointMessage pm = new PastryEndpointMessage(this.getAddress(), msg, this.thePastryNode.getLocalHandle());
        return this.thePastryNode.scheduleMsgAtFixedRate(pm, delay, period);
    }

    public NodeHandleSet localLookup(rice.p2p.commonapi.Id key, int num, boolean safe) {
        return this.getRoutingTable().alternateRoutes((Id)key, num);
    }

    public NodeHandleSet neighborSet(int num) {
        return this.getLeafSet().neighborSet(num);
    }

    public NodeHandleSet replicaSet(rice.p2p.commonapi.Id id, int maxRank) {
        LeafSet leafset = this.getLeafSet();
        if (maxRank > leafset.maxSize() / 2 + 1) {
            throw new IllegalArgumentException("maximum replicaSet size for this configuration exceeded; asked for " + maxRank + " but max is " + leafset.maxSize() / 2 + 1);
        }
        if (maxRank > leafset.size() && this.logger.level <= 400) {
            this.logger.log("trying to get a replica set of size " + maxRank + " but only " + leafset.size() + " nodes in leafset");
        }
        return leafset.replicaSet((Id)id, maxRank);
    }

    public NodeHandleSet replicaSet(rice.p2p.commonapi.Id id, int maxRank, rice.p2p.commonapi.NodeHandle root, NodeHandleSet set) {
        LeafSet leaf = new LeafSet((NodeHandle)root, this.getLeafSet().maxSize(), false);
        for (int i = 0; i < set.size(); ++i) {
            leaf.put((NodeHandle)set.getHandle(i));
        }
        return leaf.replicaSet((Id)id, maxRank);
    }

    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle n, int r, rice.p2p.commonapi.Id key, boolean cumulative) {
        Id pKey = (Id)key;
        if (cumulative) {
            return this.getLeafSet().range((NodeHandle)n, r);
        }
        IdRange ccw = this.getLeafSet().range((NodeHandle)n, r, false);
        IdRange cw = this.getLeafSet().range((NodeHandle)n, r, true);
        if (cw == null || ccw.contains(pKey) || pKey.isBetween(cw.getCW(), ccw.getCCW())) {
            return ccw;
        }
        return cw;
    }

    public rice.p2p.commonapi.IdRange range(rice.p2p.commonapi.NodeHandle n, int r, rice.p2p.commonapi.Id key) {
        return this.range(n, r, key, false);
    }

    public final void messageForAppl(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] deliver " + msg + " from " + msg.getSenderId());
        }
        if (msg instanceof PastryEndpointMessage) {
            this.application.deliver(null, ((PastryEndpointMessage)msg).getMessage());
        } else if (this.logger.level <= 900) {
            this.logger.log("Received unknown message " + msg + " - dropping on floor");
        }
    }

    public final boolean enrouteMessage(rice.p2p.commonapi.Message msg, rice.p2p.commonapi.Id key, rice.p2p.commonapi.NodeHandle nextHop, SendOptions opt) {
        if (msg instanceof RouteMessage) {
            if (this.logger.level <= 400) {
                this.logger.log("[" + this.thePastryNode + "] forward " + msg);
            }
            return this.application.forward((RouteMessage)((Object)msg));
        }
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
        this.application.update(nh, wasAdded);
    }

    public void receiveMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] recv " + msg);
        }
        if (msg instanceof rice.pastry.routing.RouteMessage) {
            rice.pastry.routing.RouteMessage rm = (rice.pastry.routing.RouteMessage)msg;
            if (this.logger.level <= 400) {
                this.logger.log("[" + this.thePastryNode + "] forward " + msg);
            }
            if (this.application.forward(rm) && rm.nextHop != null) {
                NodeHandle nextHop = rm.nextHop;
                if (this.getNodeId().equals(nextHop.getNodeId())) {
                    PastryEndpointMessage pMsg = (PastryEndpointMessage)rm.unwrap();
                    if (this.logger.level <= 400) {
                        this.logger.log("[" + this.thePastryNode + "] deliver " + pMsg + " from " + pMsg.getSenderId());
                    }
                    this.application.deliver(rm.getTarget(), pMsg.getMessage());
                } else {
                    rm.routeMessage((NodeHandle)this.getLocalNodeHandle());
                }
            }
        } else {
            this.messageForAppl(msg);
        }
    }

    public void process(Executable task, Continuation command) {
        this.thePastryNode.process(task, command);
    }
}

