/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.client;

import rice.environment.logging.Logger;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSetEventSource;
import rice.pastry.NodeSetListener;
import rice.pastry.PastryNode;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RoutingTable;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.standard.StandardAddress;

public abstract class PastryAppl
implements MessageReceiver {
    protected String instance;
    protected PastryNode thePastryNode;
    protected Address address;
    protected Logger logger;

    public PastryAppl(PastryNode pn) {
        this(pn, null);
    }

    public PastryAppl(PastryNode pn, String instance) {
        this(pn, instance, null);
        this.register();
    }

    public PastryAppl(PastryNode pn, String instance, Address address) {
        this.address = address;
        if (instance != null) {
            this.instance = instance;
            if (address == null) {
                this.address = new StandardAddress(this.getClass(), instance, pn.getEnvironment());
            }
        }
        this.thePastryNode = pn;
        this.logger = pn.getEnvironment().getLogManager().getLogger(this.getClass(), instance);
    }

    public PastryAppl(PastryNode pn, int port) {
        this(pn, "[PORT " + port + "]", new StandardAddress(port));
    }

    public Address getAddress() {
        return this.address;
    }

    public final NodeId getNodeId() {
        return this.thePastryNode.getNodeId();
    }

    public NodeHandle getNodeHandle() {
        return this.thePastryNode.getLocalHandle();
    }

    public LeafSet getLeafSet() {
        return this.thePastryNode.getLeafSet().copy();
    }

    public RoutingTable getRoutingTable() {
        return this.thePastryNode.getRoutingTable();
    }

    public boolean isClosest(NodeId key) {
        return this.thePastryNode.isClosest(key);
    }

    public abstract Credentials getCredentials();

    protected void register() {
        this.thePastryNode.registerReceiver(this.getCredentials(), this.getAddress(), this);
        this.thePastryNode.addLeafSetListener(new LeafSetObserver());
        this.thePastryNode.addRouteSetListener(new RouteSetObserver());
        this.thePastryNode.registerApp(this);
    }

    public final void registerReceiver(Credentials cred, Address addr, MessageReceiver mr) {
        this.thePastryNode.registerReceiver(cred, addr, mr);
    }

    public final void sendMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] send " + msg);
        }
        this.thePastryNode.receiveMessage(msg);
    }

    public void receiveMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] recv " + msg);
        }
        if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            if (this.enrouteMessage(rm.unwrap(), rm.getTarget(), rm.nextHop, rm.getOptions())) {
                rm.routeMessage(this.thePastryNode.getLocalHandle());
            }
        } else {
            this.messageForAppl(msg);
        }
    }

    public boolean routeMsgDirect(NodeHandle dest, Message msg, Credentials cred, SendOptions opt) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] routemsgdirect " + msg + " to " + dest);
        }
        if (!dest.isAlive()) {
            return false;
        }
        dest.receiveMessage(msg);
        return dest.isAlive();
    }

    public void routeMsg(Id key, Message msg, Credentials cred, SendOptions opt) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] routemsg " + msg + " to " + key);
        }
        RouteMessage rm = new RouteMessage(key, msg, cred, opt, this.getAddress());
        this.thePastryNode.receiveMessage(rm);
    }

    public abstract void messageForAppl(Message var1);

    public boolean enrouteMessage(Message msg, Id key, NodeHandle nextHop, SendOptions opt) {
        return true;
    }

    public void leafSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void routeSetChange(NodeHandle nh, boolean wasAdded) {
    }

    public void notifyReady() {
    }

    public boolean deliverWhenNotReady() {
        return false;
    }

    public void destroy() {
    }

    private class RouteSetObserver
    implements NodeSetListener {
        private RouteSetObserver() {
        }

        public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
            PastryAppl.this.routeSetChange(handle, added);
        }
    }

    private class LeafSetObserver
    implements NodeSetListener {
        private LeafSetObserver() {
        }

        public void nodeSetUpdate(NodeSetEventSource nodeSetEventSource, NodeHandle handle, boolean added) {
            PastryAppl.this.leafSetChange(handle, added);
        }
    }
}

