/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.client;

import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.security.Credentials;

public abstract class CommonAPIAppl
extends PastryAppl {
    public CommonAPIAppl(PastryNode pn) {
        super(pn);
    }

    public CommonAPIAppl(PastryNode pn, String instance) {
        super(pn, instance);
    }

    public abstract Credentials getCredentials();

    public void route(Id key, Message msg, NodeHandle hint) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] route " + msg + " to " + key);
        }
        RouteMessage rm = new RouteMessage(key, msg, hint, this.getAddress());
        this.thePastryNode.receiveMessage(rm);
    }

    public NodeSet localLookup(Id key, int num, boolean safe) {
        return this.getRoutingTable().alternateRoutes(key, num);
    }

    public NodeSet neighborSet(int num) {
        return this.getLeafSet().neighborSet(num);
    }

    public NodeSet replicaSet(Id key, int max_rank) {
        return this.getLeafSet().replicaSet(key, max_rank);
    }

    public IdRange range(NodeHandle n, int r, Id key, boolean cumulative) {
        if (cumulative) {
            return this.getLeafSet().range(n, r);
        }
        IdRange ccw = this.getLeafSet().range(n, r, false);
        IdRange cw = this.getLeafSet().range(n, r, true);
        if (cw == null || ccw.contains(key) || key.isBetween(cw.getCW(), ccw.getCCW())) {
            return ccw;
        }
        return cw;
    }

    public IdRange range(NodeHandle n, int r, Id key) {
        return this.range(n, r, key, false);
    }

    public abstract void deliver(Id var1, Message var2);

    public void forward(RouteMessage msg) {
    }

    public void update(NodeHandle nh, boolean joined) {
    }

    public void notifyReady() {
    }

    public final void messageForAppl(Message msg) {
    }

    public final void leafSetChange(NodeHandle nh, boolean wasAdded) {
        this.update(nh, wasAdded);
    }

    public void receiveMessage(Message msg) {
        if (this.logger.level <= 400) {
            this.logger.log("[" + this.thePastryNode + "] recv " + msg);
        }
        if (msg instanceof RouteMessage) {
            RouteMessage rm = (RouteMessage)msg;
            this.forward(rm);
            if (rm.nextHop != null) {
                NodeHandle nextHop = rm.nextHop;
                if (this.getNodeId().equals(nextHop.getNodeId())) {
                    this.deliver(rm.getTarget(), rm.unwrap());
                } else {
                    rm.routeMessage(this.getNodeHandle());
                }
            }
        } else {
            this.deliver(null, msg);
        }
    }
}

